package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 农户信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_peasant_household",autoResultMap = true)
public class PeasantHousehold extends BaseEntity {

    private static final long serialVersionUID = 1L;


    /**
     * 勘察表id
     */
    @TableField("survey_information_id")
    private Long surveyInformationId;
    /**
     * 农户信息编号
     */
	@TableField("peasant_household_no")
    private String peasantHouseholdNo;

    /**
     * 业主姓名
     */
	@TableField("owners_name")
    private String ownersName;

    /**
     * 联系电话
     */
	@TableField("telephone")
    private String telephone;

    /**
     * 开发方名称
     */
	@TableField("developer_name")
    private String developerName;

    /**
     * 开发方code
     */
	@TableField("developer_code")
    private String developerCode;

    /**
     * 定金
     */
	@TableField("deposit")
    private Float deposit;

    /**
     * 创建时间
     */
	@TableField("creation_time")
    private Date creationTime;

    /**
     * 项目地址
     */
	@TableField(value = "project_address",typeHandler = FastjsonTypeHandler.class)
    private List<Integer> projectAddress;

    /**
     * 常住地址
     */
	@TableField(value = "permanent_address",typeHandler = FastjsonTypeHandler.class)
    private List<Integer> permanentAddress;

    /**
     * 常住地址
     */
    @TableField("permanent_address_name")
    private String permanentAddressName;

    /**
     * 项目地址
     */
    @TableField("project_address_name")
    private String projectAddressName;

    /**
     * 是否勘察 0,1
     */
	@TableField("survey_or_not")
    private Integer surveyOrNot;

    /**
     * 身份证号
     */
	@TableField("id_card")
    private String idCard;

    /**
     * 邮箱
     */
	@TableField("mailbox")
    private String mailbox;

    /**
     *  审核状态 0未审核,1审核中，2审核结束
     */
	@TableField("review")
    private Integer review;

    /**
     * 项目详细地址
     */
	@TableField("project_address_detail")
    private String projectAddressDetail;

    /**
     * 常住详细地址
     */
	@TableField("permanent_address_detail")
    private String permanentAddressDetail;

	/*
	* 开发人
	* */
    @TableField("developer")
    private String developer;
}
