package com.yeejoin.amos.boot.module.hygf.api.service;


import com.yeejoin.amos.boot.module.hygf.api.entity.PowerStation;

import java.util.Map;

/**
 * 接口类
 *
 * @author system_generator
 * @date 2023-07-15
 */
public interface IPowerStationService {

    /**
     * 保存审核实例
     * @param powerStation 审核对象
     * @param flag 是否是最后一个节点
     * @return 状态
     */
    boolean savePowerStation(PowerStation powerStation, boolean flag);


    /**
     * 根据农户id和流程状态获取实例
     * @param id 农户id
     * @param state 流程状态
     * @return 电站实例
     */
    PowerStation getObjByNhId(String id, String state);

    /**
     * 电站审核接口
     * @param pageId 表单id
     * @param nodeCode 执行节点code
     * @param stationId 电站审核记录id
     * @param taskId 任务id
     * @param planInstanceId 实例id
     * @param kv 表单数据
     * @return idx表id
     */
    String powerStationExamine(long pageId, String nodeCode, String stationId, String taskId, String planInstanceId, Map<String, Object> kv);
}
