package com.yeejoin.amos.boot.module.jxiop.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.Indicator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.context.annotation.Primary;

import javax.ws.rs.DefaultValue;
import java.util.ArrayList;
import java.util.List;

/**
 * 场站基础信息表
 *
 * @author system_generator
 * @date 2023-04-20
 */
@Data
@ApiModel(value = "StationInfoDto", description = "场站基础信息表")
public class StationInfoDto  {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value ="场站id")
    private Long stationId;

    @ApiModelProperty(value ="平台id")
    private String platformStationId;

    @ApiModelProperty(value = "场站名称")
    private String stationName;


    @ApiModelProperty(value = "场站类型")
    private String type;

    @ApiModelProperty(value = "url")
    private String url;

    @ApiModelProperty(value = "三维跳转路径")
    private String jumpPath;

    @ApiModelProperty(value = "图钉所属区域")
    private String region;

    @ApiModelProperty(value = "数据偏移量")
    private ArrayList<Double> titlePos;

    @ApiModelProperty(value = "卡片数据")
    private List<Indicator> indicatorData ;

    @ApiModelProperty(value = "风险等级")
    private String riskLevel;
}
