package com.yeejoin.amos.boot.module.jxiop.biz.ESDto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.github.classgraph.json.Id;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/8/9
 */
@Data
@Accessors(chain = true)
@Document(indexName = "jxiop_dailyPowerGeneration")
public class ESDailyPowerGeneration  {

    @Id
    private String  id;

    @Field(type = FieldType.Keyword )
    private String stationId;
    //场站名称
    @Field(type = FieldType.Text )
    private String stationName;
    //场站类型
    @Field(type = FieldType.Text )
    private String stationType;
    //所属省份
    @Field(type = FieldType.Text )
    private String belongProvince;
    //所属片区
    @Field(type = FieldType.Text )
    private String belongArea;

    @Field(type = FieldType.Keyword )
    private String  day;//时间标识

    @Field(type = FieldType.Keyword)
    private String  gatewayId;
    @Field(type = FieldType.Date, format = DateFormat.basic_date_time, index = false)
    private Date createdTime;
    @Field(type = FieldType.Double, index = false)
    private Double  value;
    @Field(type = FieldType.Keyword )
    private String  equipmentIndexName;
    @Field(type = FieldType.Keyword )
    private String  equipmentNumber;
    @Field(type = FieldType.Text, index = false)
    private String  address;

    public ESDailyPowerGeneration(String id, String stationId, String stationName, String stationType, String belongProvince, String belongArea, String day, String gatewayId, Date createdTime, Double value, String equipmentIndexName, String equipmentNumber, String address) {
        this.id = id;
        this.stationId = stationId;
        this.stationName = stationName;
        this.stationType = stationType;
        this.belongProvince = belongProvince;
        this.belongArea = belongArea;
        this.day = day;
        this.gatewayId = gatewayId;
        this.createdTime = createdTime;
        this.value = value;
        this.equipmentIndexName = equipmentIndexName;
        this.equipmentNumber = equipmentNumber;
        this.address = address;
    }

    public ESDailyPowerGeneration() {
    }
}
