package com.yeejoin.amos.boot.module.jxiop.biz.controller;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.api.dto.IndexDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.MonitorFanIndicator;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.MonitorFanIndicatorMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESEquipments;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IndicatorsDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.QueryDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.StationCacheInfoDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.Test;
import com.yeejoin.amos.boot.module.jxiop.biz.initdata.StationCacheDataInit;
import com.yeejoin.amos.boot.module.jxiop.biz.repository.ESEquipmentsRepository;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.StationBasicServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.TestServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.utils.InfluxDButils;
import com.yeejoin.amos.component.influxdb.InfluxDbConnection;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedAvg;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;


@RestController
@Api(tags = "Demo-test")
@RequestMapping(value = "/demo")
public class DemoController extends BaseController {
    Logger logger = LoggerFactory.getLogger(DemoController.class);

    @Autowired
    StationBasicServiceImpl stationBasicServiceimpl;
    @Autowired
    TestServiceImpl testServiceimpl;

    @Autowired
    InfluxDbConnection influxDbConnection;

    @Autowired
    InfluxDButils influxDButils;

    @Autowired
    EmqKeeper emqKeeper;

    @Autowired
    private MonitorFanIndicatorMapper monitorFanIndicatorregionMapper;
    @Autowired
    private ElasticsearchRestTemplate elasticsearchTemplate;
    @Autowired
    ESEquipmentsRepository  equipmentsRepository;
    @Autowired
    CommonServiceImpl commonServiceImpl;
    @Autowired
    StationCacheDataInit stationCacheDataInit;

    private final String   ss=  "瞬时风速";
    private final String   zfs=  "WTX-801_25_WTX-801_总辐射";
    private final String   zfslj=  "WTX-801_25_WTX-801_总辐射累计";





    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "手动更新场站缓存信息接口")
    @GetMapping("/updateStationCacheInfo")
    public String updateStationCacheInfo() {
        String updateResult = "更新场站信息缓存成功";
        try {
            stationCacheDataInit.run();
        } catch (Exception e) {
             updateResult = "更新场站信息缓存成功";
            throw new RuntimeException(e);
        }
        return updateResult;
    }




    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "demo测试prodcutcion 库")
    @GetMapping("/test")
    public StationBasic demoTest() {
        return stationBasicServiceimpl.getById(1660231556607774721L);
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "demo测试中间库")
    @GetMapping("/test1")
    public List<Test> demoTest1() {
        return testServiceimpl.getList();
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "demo测试influxdb")
    @GetMapping("/test3")
    public void demoTest2() {
        String sql = "SELECT * FROM indicators_1668801435891929089";
        String sql1 = "SELECT * FROM indicators_1668801570352926721";
        List<IndicatorsDto> list = influxDButils.getListData(sql, IndicatorsDto.class);
        List<IndicatorsDto> list2 = influxDButils.getListData(sql1, IndicatorsDto.class);
        System.out.println(list.size());
        System.out.println(list2.size());
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "初始化influxdb-风电、光伏、升压站")
    @GetMapping("/test4")
    public ResponseModel<Integer> demoTest3() {
        //数据说明 夏造风电、泰和光伏、夏造升压站、泰和升压站
        String [] strings = {"1668801435891929089","1669524885619085313"};
//        String [] strings = {"1669524885619085313"};
//        Object o=this.monitorFanIndicatorImpl.getIndicatoralueAvage("1668801435891929089","60秒平均风速");
//        System.out.println(o.toString());
        elasticsearchTemplate.deleteIndex(ESEquipments.class);
        int  num=0;
        for (int i = 0; i < strings.length; i++) {
            QueryWrapper<MonitorFanIndicator> QueryWrapper = new QueryWrapper<>();
//        夏造风电
//        QueryWrapper.eq("gateway", "1668801435891929089");
//        泰和光伏
            QueryWrapper.eq("gateway", strings[i]);
            long DATE = new Date().getTime();
            System.out.println(DATE);
            List<MonitorFanIndicator> list = monitorFanIndicatorregionMapper.selectList(QueryWrapper);
            num=num+list.size();
            List<ESEquipments> listit =new ArrayList<>();
            for (MonitorFanIndicator monitorFanIndicator : list) {

                ESEquipments eSEquipments=new ESEquipments(
                        3.55,
                 monitorFanIndicator.getAddressGateway(),
                 monitorFanIndicator.getIndexAddress(),
                 monitorFanIndicator.getDataType(),
                 monitorFanIndicator.getFanCode(),
                 monitorFanIndicator.getGateway(),
                 monitorFanIndicator.getIsAlarm(),
                 new Date(),
                 monitorFanIndicator.getUnit(),
                 "",
                 "" ,
                 "",
                 monitorFanIndicator.getIndicator(),
                 monitorFanIndicator.getEquipmentNumber(),
                 monitorFanIndicator.getFrontModule(),
                 monitorFanIndicator.getSystemType(),
                 monitorFanIndicator.getPictureName(),
                 "" );

                listit.add(eSEquipments);


//                Map<String, String> tag = new HashMap<>();
//                Map<String, Object> maps2 = new HashMap<>();
//
//                maps2.put("address", monitorFanIndicator.getIndexAddress());
//                maps2.put("dataType", monitorFanIndicator.getDataType());
//                maps2.put("equipmentSpecificName", monitorFanIndicator.getFanCode());
//                tag.put("equipmentsIdx", monitorFanIndicator.getAddressGateway());
//                maps2.put("gatewayId", monitorFanIndicator.getGateway());
//                maps2.put("isAlarm", monitorFanIndicator.getIsAlarm());
//                maps2.put("createdTime", "2023-07-05 18:30:26");
//                maps2.put("unit", monitorFanIndicator.getUnit());
//                maps2.put("value", "");
//                maps2.put("valueLabel","" );
//                maps2.put("traceId", "");
//                maps2.put("equipmentIndexName", monitorFanIndicator.getIndicator());
//                maps2.put("equipmentNumber", monitorFanIndicator.getEquipmentNumber());
//                maps2.put("frontModule", monitorFanIndicator.getFrontModule());
//                maps2.put("systemType", monitorFanIndicator.getSystemType());
//                maps2.put("pictureName", monitorFanIndicator.getPictureName());
//                //升压站的字段显示名称
//                maps2.put("displayName", "");
//                influxDbConnection.insert("indicators_" + monitorFanIndicator.getGateway(), tag, maps2, 1688558007051L, TimeUnit.MILLISECONDS);

            }
            equipmentsRepository.saveAll(listit);
        }
        return ResponseHelper.buildResponse(num);
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "测试消息发送")
    @GetMapping("/test5")
    public void demoTest4() {
        HashMap<String, String> hashMap = new HashMap<>();
        hashMap.put("test", String.valueOf(Math.random() * 1000));
        hashMap.put("test1", String.valueOf(Math.random() * 100));
        try {
            emqKeeper.getMqttClient().publish("test_topic", JSON.toJSON(hashMap).toString().getBytes("UTF-8"), 1, true);
            emqKeeper.getMqttClient().publish("test_topic1", JSON.toJSON(hashMap).toString().getBytes("UTF-8"), 1, true);
            logger.info("++++++++++++++++++++++++++++++++++发送消息成功++++++++++++++++++++++++++++++++++++++");
        } catch (Exception exception) {
            logger.error("============================================================发送消息报错");
        }
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "初始化升压站")
    @GetMapping("/test6")
    public ResponseModel<Integer> demoTest5() {
        //数据说明 夏造风电、泰和光伏、夏造升压站、泰和升压站
        String [] strings = {"1668801570352926721","1669525017559306241"};
//        String [] strings = {"1669525017559306241"};
//        Object o=this.monitorFanIndicatorImpl.getIndicatoralueAvage("1668801435891929089","60秒平均风速");
//        System.out.println(o.toString());

        int  num=0;
        for (int i = 0; i < strings.length; i++) {
            QueryWrapper<MonitorFanIndicator> QueryWrapper = new QueryWrapper<>();
//        夏造风电
//        QueryWrapper.eq("gateway", "1668801435891929089");
//        泰和光伏
            QueryWrapper.eq("gateway", strings[i]);
            long DATE = new Date().getTime();
            System.out.println(DATE);
            List<MonitorFanIndicator> list = monitorFanIndicatorregionMapper.selectList(QueryWrapper);
            num=num+list.size();

            List<ESEquipments> listit =new ArrayList<>();
            for (MonitorFanIndicator monitorFanIndicator : list) {


                ESEquipments eSEquipments=new ESEquipments(
                        3.55,
                        monitorFanIndicator.getAddressGateway(),
                        monitorFanIndicator.getIndexAddress(),
                        monitorFanIndicator.getDataType(),
                        monitorFanIndicator.getFanCode(),
                        monitorFanIndicator.getGateway(),
                        monitorFanIndicator.getIsAlarm(),
                        new Date(),
                        monitorFanIndicator.getUnit(),
                        "",
                        "" ,
                        "",
                        monitorFanIndicator.getIndicator(),
                        monitorFanIndicator.getEquipmentNumber(),
                        monitorFanIndicator.getFrontModule(),
                        monitorFanIndicator.getSystemType(),
                        monitorFanIndicator.getPictureName(),
                        monitorFanIndicator.getEquipmentNumber() );

                listit.add(eSEquipments);







//                Map<String, String> tag = new HashMap<>();
//                Map<String, Object> maps2 = new HashMap<>();
//
//                maps2.put("address", monitorFanIndicator.getIndexAddress());
//                maps2.put("dataType", monitorFanIndicator.getDataType());
//                maps2.put("equipmentSpecificName", monitorFanIndicator.getFanCode());
//                tag.put("equipmentsIdx", monitorFanIndicator.getAddressGateway());
//                maps2.put("gatewayId", monitorFanIndicator.getGateway());
//                maps2.put("isAlarm", monitorFanIndicator.getIsAlarm());
//                maps2.put("createdTime", "2023-07-05 18:30:26");
//                maps2.put("unit", monitorFanIndicator.getUnit());
//                maps2.put("value", "");
//                maps2.put("valueLabel","" );
//                maps2.put("traceId", "");
//                maps2.put("equipmentIndexName", monitorFanIndicator.getIndicator());
//                maps2.put("equipmentNumber", monitorFanIndicator.getEquipmentNumber());
//                maps2.put("frontModule", monitorFanIndicator.getFrontModule());
//                maps2.put("systemType", monitorFanIndicator.getSystemType());
//                maps2.put("pictureName", monitorFanIndicator.getPictureName());
//                //升压站的字段显示名称
//                maps2.put("displayName", monitorFanIndicator.getEquipmentNumber());
//                influxDbConnection.insert("indicators_" + monitorFanIndicator.getGateway(), tag, maps2, 1688558007051L, TimeUnit.MILLISECONDS);
            }

            equipmentsRepository.saveAll(listit);
        }
        return ResponseHelper.buildResponse(num);
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "测试动态图片")
    @GetMapping("/test7")
    public ResponseModel<HashMap<String, String>> demoTest6() {
        HashMap<String, String> hashMap = new HashMap<>();
        hashMap.put("url", "upload/jxiop/amos_studio/758F6F4BC695B777899485DB0C7E5D3.gif");

        return ResponseHelper.buildResponse(hashMap);
    }
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "测试求和")
    @GetMapping("/test8")
    public ResponseModel<Object> demoTest8() {

        QueryBuilder queryBuilder = QueryBuilders.matchQuery("equipmentIndexName", "有功功率");
        SumAggregationBuilder buyCountSum = AggregationBuilders.sum("buyCountSum").field("valueDouble");
        Query query = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .addAggregation(buyCountSum)
                .withPageable(PageRequest.of(0, 1))
                .build();
        query.setTrackTotalHits(true);  // 允许返回查询结果的total - search.getTotalHits()
        SearchHits<ESEquipments> search = elasticsearchTemplate.search(query, ESEquipments.class);
        return ResponseHelper.buildResponse(search);

    }
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "测试平均数")
    @GetMapping("/test9")
    public ResponseModel<Object> demoTest9() {
        QueryBuilder queryBuilder = QueryBuilders.matchQuery("equipmentIndexName", "有功功率");


        AvgAggregationBuilder buyCountAvg = AggregationBuilders.avg("buyCountAvg").field("valueDouble");
        Query query = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .addAggregation(buyCountAvg)
                .withPageable(PageRequest.of(0, 1))
                .build();

        query.setTrackTotalHits(true);
        SearchHits<ESEquipments> search = elasticsearchTemplate.search(query, ESEquipments.class);

        return ResponseHelper.buildResponse(search);
    }


    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "分组求和数")
    @GetMapping("/test10")
    public SearchHits demoTest10() {
        QueryBuilder queryBuilder = QueryBuilders.matchQuery("equipmentIndexName", "有功功率");



        // 如果只对一个字段进行分组写一个就好
        TermsAggregationBuilder tb1 = AggregationBuilders.terms("group_gatewayId").field("gatewayId.keyword");//gatewayId 是分组字段名，group_gatewayId是查询结果的别名
//        TermsAggregationBuilder tb2 = AggregationBuilders.terms("group_equipmentNumber").field("equipmentNumber.keyword");//equipmentNumber 是分组字段名，group_equipmentNumber是查询结果的别名
        SumAggregationBuilder sb = AggregationBuilders.sum("sum_valueDouble").field("valueDouble");//valueDouble是求和字段名称，sun_valueDouble是结果别名

        // 注意顺序,决定先通过谁分组
        tb1.subAggregation(sb);	// 通过typeId字段分组统计总数
//        tb2.subAggregation(sb); // 通过houseId字段分组统计总数
//        tb1.subAggregation(tb2); // 合并


        Query query = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .addAggregation(tb1)
                .withPageable(PageRequest.of(0, 1))
                .build();

        query.setTrackTotalHits(true);
        SearchHits search = elasticsearchTemplate.search(query, ESEquipments.class);

        return search;
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "分组求和数")
    @GetMapping("/test11")
    public Map demoTest11() {

        List<QueryDto> queryDto=new ArrayList<>();
        QueryDto ff1=new QueryDto("gatewayId.keyword","1668801435891929089");
        QueryDto ff2=new QueryDto("equipmentIndexName.keyword","有功功率");
        queryDto.add(ff1);
        queryDto.add(ff2);
        Double avg= commonServiceImpl.getavg(queryDto,"valueDouble",ESEquipments.class);
        Double sum= commonServiceImpl.getsum(queryDto,"valueDouble",ESEquipments.class);

        Map<String,Double> map=new HashMap();
        map.put("1668801435891929089_avg",avg);
        map.put("1668801435891929089_sum",sum);
        return map;
    }
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "取缓存数据")
    @GetMapping("/test12")
    public List<StationCacheInfoDto> demoTest12() {
        return commonServiceImpl.getListStationCacheInfoDto();
    }





    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "分组平均数")
    @GetMapping("/test13")
    public Map demoTest13() {

        List<String> value=new ArrayList<>();
        value.add(ss);
        value.add(zfs);
        value.add(zfslj);
        Map<String,List<String>> map=new HashMap<>();
        map.put("equipmentIndexName.keyword",value);
//        List<String> value1=new ArrayList<>();
//        value1.add("1668801435891929089");
//        map.put("gatewayId.keyword",value1);

        List<? extends Terms.Bucket> lidate=  commonServiceImpl.getgroupavg(map,"valueDouble" ,"equipmentIndexName.keyword",ESEquipments.class);

        Map<String,Object>  mapdta=new HashMap<>();
        DecimalFormat format2 = new DecimalFormat("#.0000");

        for (Terms.Bucket bucket : lidate) {
            Aggregations aggregation= bucket.getAggregations();
            List<Aggregation>  listdata= Objects.nonNull(aggregation)?aggregation.asList():null;
            for (Aggregation agg : listdata) {
                ParsedAvg parsedAvg  =(ParsedAvg)agg;
                mapdta.put(bucket.getKeyAsString(), format2.format(parsedAvg.getValue()));
            }
        }
        return mapdta;
    }



    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "分组求和数")
    @GetMapping("/test14")
    public Map demoTest14() {

        List<String> value=new ArrayList<>();
        value.add(ss);
        value.add(zfs);
        value.add(zfslj);
        Map<String,List<String>> map=new HashMap<>();
        map.put("equipmentIndexName.keyword",value);
//        List<String> value1=new ArrayList<>();
//        value1.add("1668801435891929089");
//        map.put("gatewayId.keyword",value1);

        List<? extends Terms.Bucket> lidate=  commonServiceImpl.getgroupsum(map,"valueDouble" ,"equipmentIndexName.keyword",ESEquipments.class);

        Map<String,Object>  mapdta=new HashMap<>();
        DecimalFormat format2 = new DecimalFormat("#.0000");

        for (Terms.Bucket bucket : lidate) {
            Aggregations aggregation= bucket.getAggregations();
            List<Aggregation>  listdata= Objects.nonNull(aggregation)?aggregation.asList():null;
            for (Aggregation agg : listdata) {
                ParsedSum parsedSum  =(ParsedSum)agg;
                mapdta.put(bucket.getKeyAsString(), format2.format(parsedSum.getValue()));
            }
        }
        return mapdta;
    }






}
