package com.yeejoin.amos.boot.module.jxiop.biz.scheduled;

import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESDailyPowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESMoonPowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.StationCacheInfoDto;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.PowerGenerationImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/8/9
 */

@Component
@EnableScheduling
public class PowerGeneration {

    @Autowired
    PowerGenerationImpl powerGenerationImpl;
    @Autowired
    CommonServiceImpl commonServiceImpl;

    private final  String dayvalue="日发电量";
    private final  String moonValue="月发电量";
    private final  String yearValue="年发电量";

    private final  String dayDateFormat="YYYY-MM-DD";
    private final  String moonDateFormat="YYYY-MM";
    private final  String yearDateFormat="YYYY";


    private final  String dayType="day";
    private final  String moonType="moon";
    private final  String yearType="year";

    //定时更新日发电量
   // @Scheduled(cron = "${daily.power.generation.cron}")
    public void addESDailyPowerGeneration(){
        List<StationCacheInfoDto>  list =commonServiceImpl.getListStationCacheInfoDto();
        for (StationCacheInfoDto stationCacheInfoDto : list) {
            //风机
            powerGenerationImpl.addPowerGeneration( stationCacheInfoDto, stationCacheInfoDto.getFanGatewayId(),  dayvalue,  dayDateFormat,  dayType);
            //光伏
            powerGenerationImpl.addPowerGeneration( stationCacheInfoDto, stationCacheInfoDto.getBoosterGatewayId(), dayvalue,  dayDateFormat,  dayType);
        }


    }
    //定时更新月发电量
   // @Scheduled(cron = "${moon.power.generation.cron}")
    public void addESMoonPowerGeneration(){
        List<StationCacheInfoDto>  list =commonServiceImpl.getListStationCacheInfoDto();
        for (StationCacheInfoDto stationCacheInfoDto : list) {
            //风机
            powerGenerationImpl.addPowerGeneration( stationCacheInfoDto, stationCacheInfoDto.getFanGatewayId(),  moonValue,  moonDateFormat,  moonType);
            //光伏
            powerGenerationImpl.addPowerGeneration( stationCacheInfoDto, stationCacheInfoDto.getBoosterGatewayId(), moonValue,  moonDateFormat,  moonType);
        }
    }
    //定时更新年发电量
    //@Scheduled(cron = "${year.power.generation.cron}")
    public void addESYearPowerGeneration(){
        List<StationCacheInfoDto>  list =commonServiceImpl.getListStationCacheInfoDto();
        for (StationCacheInfoDto stationCacheInfoDto : list) {
            //风机
            powerGenerationImpl.addPowerGeneration( stationCacheInfoDto, stationCacheInfoDto.getFanGatewayId(),  yearValue,  yearDateFormat,  yearType);
            //光伏
            powerGenerationImpl.addPowerGeneration( stationCacheInfoDto, stationCacheInfoDto.getBoosterGatewayId(), yearValue,  yearDateFormat,  yearType);
        }
    }



}
