package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.yeejoin.amos.boot.module.jxiop.api.dto.IndexDto;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESDailyPowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESMoonPowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESYearPowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.StationCacheInfoDto;
import com.yeejoin.amos.boot.module.jxiop.biz.repository.ESDailyPowerGenerationRepository;
import com.yeejoin.amos.boot.module.jxiop.biz.repository.ESEquipmentsRepository;
import com.yeejoin.amos.boot.module.jxiop.biz.repository.ESMoonPowerGenerationRepository;
import com.yeejoin.amos.boot.module.jxiop.biz.repository.ESYearPowerGenerationRepository;
import com.yeejoin.amos.boot.module.jxiop.biz.utils.InfluxDButils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/8/9
 */
@Service
public class PowerGenerationImpl {

    @Autowired
    InfluxDButils influxDButils;
    @Autowired
    private ElasticsearchRestTemplate elasticsearchTemplate;
    @Autowired
    ESYearPowerGenerationRepository yearPowerGenerationRepository;
    @Autowired
    ESMoonPowerGenerationRepository moonPowerGenerationRepository;
    @Autowired
    ESDailyPowerGenerationRepository dailyPowerGenerationRepository;


    //获取指定指标，当天最后一条数据
    public List<IndexDto> getlast(String gatewayId, String value){
        IndexDto indexDto=null;
        //获取时间天字符串
        SimpleDateFormat myFmt2=new SimpleDateFormat("yyyy-MM-dd");
        Date now=new Date();
        String daty= myFmt2.format(now);
        String querySql = " SELECT * FROM iot_data_%s  WHERE equipmentIndexName='%s'  and time >='%sT23:55:00Z' AND time < '%sT23:59:59Z'  group by address order by time desc  LIMIT   1";
        querySql = String.format(querySql, gatewayId, value,daty,daty);
        List<IndexDto> queryList  = influxDButils.getListData(querySql,IndexDto.class);
        return queryList;
    }

    //更新es 数据

    @Async("jxiopAsyncExecutor")
    public void addPowerGeneration(StationCacheInfoDto stationCacheInfoDto,String gatewayId, String value, String dateFormat, String type){
        //获取指标值
        List<IndexDto> indexDto= this.getlast(gatewayId,value);
        SimpleDateFormat myFmt2=new SimpleDateFormat(dateFormat);
        Date now=new Date();
        String daty= myFmt2.format(now);
        this.PowerGeneration(stationCacheInfoDto,indexDto,daty,type);
    }


    //更新es
    public void PowerGeneration(StationCacheInfoDto stationCacheInfoDto,List<IndexDto> indexDto,String daty,String type){

        switch (type) {
            case "day":
                List<ESDailyPowerGeneration> listd=   this.getESDailyPowerGeneration(stationCacheInfoDto,indexDto,type);
                dailyPowerGenerationRepository.saveAll(listd);
                break;
            case "moon":
                List<ESMoonPowerGeneration> listm=   this.getESMoonPowerGeneration(stationCacheInfoDto,indexDto,type);
                moonPowerGenerationRepository.saveAll(listm);

                break;
            case "year":
                List<ESYearPowerGeneration> listy=   this.getESYearPowerGeneration(stationCacheInfoDto,indexDto,type);
                yearPowerGenerationRepository.saveAll(listy);
                break;
            default:
                break;
        }

    }

// 组装数据

    public List<ESDailyPowerGeneration> getESDailyPowerGeneration(StationCacheInfoDto stationCacheInfoDto,List<IndexDto> indexDto,String daty){

        List<ESDailyPowerGeneration> list=new ArrayList<>();
        if(indexDto!=null&&!indexDto.isEmpty()){
            for (IndexDto dto : indexDto) {
                ESDailyPowerGeneration dailyPowerGeneration=new ESDailyPowerGeneration(
                        daty+"_"+dto.getAddress(),
                        stationCacheInfoDto.getStationId(),
                        stationCacheInfoDto.getStationName(),
                        stationCacheInfoDto.getStationType(),
                        stationCacheInfoDto.getBelongProvince(),
                        stationCacheInfoDto.getBelongArea(),
                        daty,
                        dto.getGatewayId(),
                        new Date(),
                        dto.getValue()!=null?Double.valueOf(dto.getValue()):null,
                        dto.getEquipmentIndexName(),
                        dto.getEquipmentNumber(),
                        dto.getAddress()
                );
                list.add(dailyPowerGeneration);
            }
        }
        return list;
    }
    public List<ESMoonPowerGeneration> getESMoonPowerGeneration(StationCacheInfoDto stationCacheInfoDto,List<IndexDto> indexDto,String daty){
        List<ESMoonPowerGeneration> list=new ArrayList<>();
        if(indexDto!=null&&!indexDto.isEmpty()){
            for (IndexDto dto : indexDto) {
                ESMoonPowerGeneration moonPowerGeneration=new ESMoonPowerGeneration(
                        daty+"_"+dto.getAddress(),
                        stationCacheInfoDto.getStationId(),
                        stationCacheInfoDto.getStationName(),
                        stationCacheInfoDto.getStationType(),
                        stationCacheInfoDto.getBelongProvince(),
                        stationCacheInfoDto.getBelongArea(),
                        daty,
                        dto.getGatewayId(),
                        new Date(),
                        dto.getValue()!=null?Double.valueOf(dto.getValue()):null,
                        dto.getEquipmentIndexName(),
                        dto.getEquipmentNumber(),
                        dto.getAddress()
                );
                list.add(moonPowerGeneration);
            }
        }
        return list;
    }
    public List<ESYearPowerGeneration> getESYearPowerGeneration(StationCacheInfoDto stationCacheInfoDto,List<IndexDto> indexDto,String daty){
        List<ESYearPowerGeneration> list=new ArrayList<>();
        if(indexDto!=null&&!indexDto.isEmpty()){
            for (IndexDto dto : indexDto) {
                ESYearPowerGeneration yearPowerGeneration=new ESYearPowerGeneration(
                        daty+"_"+dto.getAddress(),
                        stationCacheInfoDto.getStationId(),
                        stationCacheInfoDto.getStationName(),
                        stationCacheInfoDto.getStationType(),
                        stationCacheInfoDto.getBelongProvince(),
                        stationCacheInfoDto.getBelongArea(),
                        daty,
                        dto.getGatewayId(),
                        new Date(),
                        dto.getValue()!=null?Double.valueOf(dto.getValue()):null,
                        dto.getEquipmentIndexName(),
                        dto.getEquipmentNumber(),
                        dto.getAddress()
                );
                list.add(yearPowerGeneration);
            }
        }
        return list;
    }







}
