package com.yeejoin.amos.boot.module.jg.biz.edit.process.equip;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.biz.edit.constant.EditConstant;
import com.yeejoin.amos.boot.module.jg.biz.edit.esUpdate.service.EsUpdateService;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.strategy.IBizDataChangeHandleStrategy;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.equip.strategy.HandleResult;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.equip.strategy.IEquipChangeDataProcessStrategy;
import com.yeejoin.amos.boot.module.jg.biz.edit.typeHandler.PieLineLevelTypeHandler;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgRegisterInfoServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.*;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 单个装置维护-策略实现类
 */
@Component
@RequiredArgsConstructor
public class SingleProjectEquipChangeProcess implements IEquipChangeDataProcessStrategy {

    private final CommonEquipDataProcessService commonEquipDataProcessService;

    private final PieLineDataChangeServiceImpl pieLineDataChangeService;

    private final PieLineLevelTypeHandler pieLineLevelTypeHandler;

    private final EsUpdateService esUpdateService;
    private final IdxBizJgRegisterInfoServiceImpl idxBizJgRegisterInfoServiceImpl;


    @Override
    public HandleResult handle(Map<String, Object> changeData, String projectContraptionId) {
        JSONObject data = (JSONObject) changeData;
        // 新增编辑的管道------------------tableData
        JSONArray insertOrEditPieLines = data.getJSONArray(RequestChangeData.multiDataKey);
        // 删除的管道----------------------deleteData
        JSONArray deletedPieLines = data.getJSONArray(RequestChangeData.deletedDataKey);
        List<FieldChangeMeta> allChangeColumns = new ArrayList<>();
        List<PipelineChangeItemDto> items = insertOrEditPieLines.toJavaList(PipelineChangeItemDto.class);
        // 1.设备技术参数入库前校验，约束：同一个装置下的管道编号不能重复
        // 同一工程装置下管道编号不能重复校验
//        if (items.size() != items.stream().map(TechParamsPipelineChangeFieldDto::getPipelineNumber).distinct().count()) {
//            throw new BadRequest("同一工程装置下管道编号不能重复！");
//        }
        List<PipelineChangeItemDto> newPipelines = new ArrayList<>();
        List<PipelineChangeItemDto> updatePipelines = new ArrayList<>();
        List<PipelineChangeItemDto> deletePipelines = new ArrayList<>();

        if (deletedPieLines != null && !deletedPieLines.isEmpty()) {
            List<PipelineChangeItemDto> deletedPieLinesJavaList = deletedPieLines.toJavaList(PipelineChangeItemDto.class);
            deletePipelines = new ArrayList<>(deletedPieLinesJavaList);
            pieLineDataChangeService.deletePieLineBatch(deletedPieLinesJavaList, allChangeColumns, projectContraptionId);
        }
        // 2.装置基本信息校验、保存(前端返回的装置信息为大写 需注意)
        ProjectContraptionChangeDataDto projectContraptionChangeDataDto = CommonEquipDataProcessService.castMap2Bean(changeData, ProjectContraptionChangeDataDto.class);
        this.setNameForDictKey(projectContraptionChangeDataDto);
        // 校验使用登记证编号是否重复
        if (Objects.toString(projectContraptionChangeDataDto.getDataSource(), "").startsWith("jg_his")) {
            commonEquipDataProcessService.beforeCheckForUseOrgCode(projectContraptionChangeDataDto);
        }
        pieLineDataChangeService.update(projectContraptionChangeDataDto, allChangeColumns);
        Boolean isRequireTemporarySave = data.getBoolean(DefaultBizDataChangeHandler.IS_REQUIRES_TEMPORARY_SAVE);
        JSONArray oldPieLineJSONArray = data.getJSONArray(DefaultBizDataChangeHandler.TEMPORARY_PIPELINES_DATA);
        List<PipelineChangeItemDto> oriPipelineList = oldPieLineJSONArray.toJavaList(PipelineChangeItemDto.class);
        Map<String, PipelineChangeItemDto> oldRecordPipelineMap = oriPipelineList.stream().collect(Collectors.toMap(TechParamsPipelineChangeFieldDto::getRecord, Function.identity()));
        // 3.管道信息入库保存
        items.forEach(pipelineNew -> {
            String record = pipelineNew.getRecord();
            if (record == null) {    // 新增的管道逻辑
                pieLineDataChangeService.newPieLine(projectContraptionChangeDataDto, pipelineNew, allChangeColumns);
                newPipelines.add(pipelineNew);
            } else {                 // 更新管道逻辑
                if (isRequireTemporarySave) {// 记录变化流水
                    PipelineChangeItemDto pipelineOld = oldRecordPipelineMap.get(record);
                    // 安装信息变更日志
                    this.buildConstructionInfoChangeLog(record, pipelineNew, pipelineOld, projectContraptionChangeDataDto, allChangeColumns);
                    // 检验信息变更日志
                    this.buildInspectInfoChangeLog(record, pipelineNew, pipelineOld, projectContraptionChangeDataDto, allChangeColumns);
                    // 设计信息变更日志
                    this.buildDesignForPieLineChangeLog(record, pipelineNew, pipelineOld, projectContraptionChangeDataDto, allChangeColumns);
                    // 技术参数变更日志
                    this.buildTechParamChangeLog(record, pipelineNew, pipelineOld, projectContraptionChangeDataDto, allChangeColumns);
                } else {// 实时更新
                    // 基本信息-特殊管道的使用信息变化更新但是不记录变更流水
                    this.updateUseInfo(pipelineNew, projectContraptionChangeDataDto, allChangeColumns);
                    // 更新管道的使用登记证编号
                    this.updateRegisterInfo(record, projectContraptionChangeDataDto);
                    // 安装信息
                    this.updateConstructionInfo(pipelineNew, projectContraptionChangeDataDto, allChangeColumns);
                    // 检验信息
                    this.updateInspectInfo(pipelineNew, projectContraptionChangeDataDto, allChangeColumns);
                    // 设计信息更新
                    pieLineDataChangeService.saveDesignForPieLine(record, allChangeColumns, pipelineNew);
                    // 技术参数入库保存
                    TechParamsPipelineChangeFieldDto paramsPipelineChangeFieldDto = new TechParamsPipelineChangeFieldDto();
                    BeanUtil.copyProperties(pipelineNew, paramsPipelineChangeFieldDto, true);
                    commonEquipDataProcessService.savePieLineTechParam(record, allChangeColumns, paramsPipelineChangeFieldDto);
                }
                updatePipelines.add(pipelineNew);
            }
        });
        Map<String, List<PipelineChangeItemDto>> pmap = MapUtil.<String, List<PipelineChangeItemDto>>builder().put(EditConstant.NEW_PIPELINES, newPipelines).put(EditConstant.UPDATE_PIPELINES, updatePipelines).put(EditConstant.DELETE_PIPELINES, deletePipelines).build();
        // 4.更新所有管道的的冗余的管道名称字段（重点注意包括本次没做使用登记的管道也要更新)
        pieLineDataChangeService.updateEs(projectContraptionChangeDataDto);
        // 5.更新管道长度，按照装置下的已经入库的全量更新（todo 流程中编辑时数据不体现在这 还是原数据）
        pieLineDataChangeService.updatePipelineLength(projectContraptionChangeDataDto.getProjectContraptionId());
        return HandleResult.builder().fieldChangeMetas(allChangeColumns).pipelineChangeItemMap(pmap).build();
    }

    private void updateRegisterInfo(String record, ProjectContraptionChangeDataDto projectContraptionChangeDataDto) {
        // 管道不记录使用信息变化，使用信息的变化已装置来体现
        LambdaUpdateWrapper<IdxBizJgRegisterInfo> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgRegisterInfo::getRecord, record);
        updateWrapper.set(IdxBizJgRegisterInfo::getUseOrgCode, projectContraptionChangeDataDto.getUseRegistrationCode());
        idxBizJgRegisterInfoServiceImpl.update(updateWrapper);
    }


    private void buildTechParamChangeLog(String record, PipelineChangeItemDto pipelineNew, PipelineChangeItemDto pipelineOld, ProjectContraptionChangeDataDto projectContraptionChangeDataDto, List<FieldChangeMeta> allChangeColumns) {
        TechParamsPipelineChangeFieldDto paramsPipelineChangeFieldNew = new TechParamsPipelineChangeFieldDto();
        BeanUtil.copyProperties(pipelineNew, paramsPipelineChangeFieldNew, true);
        TechParamsPipelineChangeFieldDto paramsPipelineChangeFieldOld = new TechParamsPipelineChangeFieldDto();
        BeanUtil.copyProperties(pipelineOld, paramsPipelineChangeFieldOld, true);
        // 使用登记兼容处理,使用登记老数据存的name,这里统一转换为code进行比较
        paramsPipelineChangeFieldOld.setDeviceLevel(pieLineLevelTypeHandler.getCodeByName(pipelineOld.getDeviceLevel()));
        // 字段行转列
        List<FieldChangeMeta> newPipelineChangeData = commonEquipDataProcessService.convertBeanField2Column2(paramsPipelineChangeFieldNew, projectContraptionChangeDataDto.getProjectContraptionId() + "/" + record);
        List<FieldChangeMeta> oldPipelineChangeData = commonEquipDataProcessService.convertBeanField2Column2(paramsPipelineChangeFieldOld, projectContraptionChangeDataDto.getProjectContraptionId() + "/" + record);
        // 比对
        List<FieldChangeMeta> pipelineChangeFields = commonEquipDataProcessService.mergeChangeFields(newPipelineChangeData, oldPipelineChangeData);
        allChangeColumns.addAll(pipelineChangeFields);
    }

    private void buildDesignForPieLineChangeLog(String record, PipelineChangeItemDto pipelineNew, PipelineChangeItemDto pipelineOld, ProjectContraptionChangeDataDto projectContraptionChangeDataDto, List<FieldChangeMeta> allChangeColumns) {
        // 1.记录变化的数据对象
        PieLineDesignChangeDataDto pieLineDesignChangeDataNew = BeanUtil.copyProperties(pipelineNew, PieLineDesignChangeDataDto.class);
        PieLineDesignChangeDataDto pieLineDesignChangeDataOld = BeanUtil.copyProperties(pipelineOld, PieLineDesignChangeDataDto.class);
        // 构造新对象行转列
        List<FieldChangeMeta> designInfoNew = commonEquipDataProcessService.convertBeanField2Column2(pieLineDesignChangeDataNew, projectContraptionChangeDataDto.getProjectContraptionId() + "/" + record);
        List<FieldChangeMeta> designInfoOld = commonEquipDataProcessService.convertBeanField2Column2(pieLineDesignChangeDataOld, projectContraptionChangeDataDto.getProjectContraptionId() + "/" + record);
        // 老数据查询行转列
        allChangeColumns.addAll(commonEquipDataProcessService.mergeChangeFields(designInfoNew, designInfoOld));
    }

    private void buildInspectInfoChangeLog(String record, PipelineChangeItemDto pipelineNew, PipelineChangeItemDto pipelineOld, ProjectContraptionChangeDataDto projectContraptionChangeDataDto, List<FieldChangeMeta> allChangeColumns) {
        IdxBizJgInspectionDetectionInfo inspectionDetectionInfoNew = castPipelineItem2Inspection(pipelineNew);
        IdxBizJgInspectionDetectionInfo inspectionDetectionInfoOld = castPipelineItem2Inspection(pipelineOld);
        List<FieldChangeMeta> inspectionFieldChangeMetas = commonEquipDataProcessService.simpleTrackDiff(inspectionDetectionInfoOld, inspectionDetectionInfoNew, projectContraptionChangeDataDto.getProjectContraptionId() + "/" + record);
        allChangeColumns.addAll(inspectionFieldChangeMetas);
    }

    private IdxBizJgInspectionDetectionInfo castPipelineItem2Inspection(PipelineChangeItemDto pipelineChangeItemDto) {
        IdxBizJgInspectionDetectionInfo inspectionDetectionInfo = new IdxBizJgInspectionDetectionInfo();
        inspectionDetectionInfo.setInspectConclusion(pipelineChangeItemDto.getInspectConclusionCode());
        inspectionDetectionInfo.setInspectDate(pipelineChangeItemDto.getInspectDate());
        inspectionDetectionInfo.setInspectReport(pipelineChangeItemDto.getInspectReport());
        inspectionDetectionInfo.setInspectOrgCode(pipelineChangeItemDto.getInspectOrgCode());
        inspectionDetectionInfo.setInspectOrgName(pipelineChangeItemDto.getInspectOrgName());
        inspectionDetectionInfo.setInspectStaff(pipelineChangeItemDto.getInspectStaff());
        inspectionDetectionInfo.setInspectType(pipelineChangeItemDto.getInspectType());
        inspectionDetectionInfo.setNextInspectDate(pipelineChangeItemDto.getNextInspectDate());
        return inspectionDetectionInfo;
    }

    private void buildConstructionInfoChangeLog(String record, PipelineChangeItemDto pipelineNew, PipelineChangeItemDto pipelineOld, ProjectContraptionChangeDataDto projectContraptionChangeDataDto, List<FieldChangeMeta> allChangeColumns) {
        IdxBizJgConstructionInfo constructionInfoOld = new IdxBizJgConstructionInfo();
        constructionInfoOld.setUscUnitName(pipelineOld.getUscUnitName());
        constructionInfoOld.setUscDate(pipelineOld.getUscDate() != null ? DateUtil.parse(pipelineOld.getUscDate(), DatePattern.NORM_MONTH_FORMAT) : null);
        IdxBizJgConstructionInfo constructionInfoNew = new IdxBizJgConstructionInfo();
        constructionInfoNew.setUscUnitName(pipelineNew.getUscUnitName());
        constructionInfoNew.setUscDate(pipelineNew.getUscDate() != null ? DateUtil.parse(pipelineNew.getUscDate(), DatePattern.NORM_MONTH_FORMAT) : null);
        List<FieldChangeMeta> constructionInfoFieldChangeMetas = commonEquipDataProcessService.simpleTrackDiff(constructionInfoOld, constructionInfoNew, projectContraptionChangeDataDto.getProjectContraptionId() + "/" + record);
        allChangeColumns.addAll(constructionInfoFieldChangeMetas);
    }

    private void updateInspectInfo(PipelineChangeItemDto item, ProjectContraptionChangeDataDto projectContraptionChangeDataDto, List<FieldChangeMeta> allChangeColumns) {
        String jySeq = item.getJySeq();
        if (jySeq != null) {
            IdxBizJgInspectionDetectionInfo inspectionDetectionInfoOld = commonEquipDataProcessService.getJgUseRegistrationService().getInspectionDetectionInfoService().getById(jySeq);
            IdxBizJgInspectionDetectionInfo inspectionDetectionInfoNew = new IdxBizJgInspectionDetectionInfo();
            BeanUtil.copyProperties(inspectionDetectionInfoOld, inspectionDetectionInfoNew, true);
            BeanUtil.copyProperties(item, inspectionDetectionInfoNew, true);
            inspectionDetectionInfoNew.setInspectConclusion(item.getInspectConclusionCode());
            inspectionDetectionInfoNew.setSequenceNbr(inspectionDetectionInfoOld.getSequenceNbr());
            List<FieldChangeMeta> inspectionFieldChangeMetas = commonEquipDataProcessService.simpleTrackAndUpdate(commonEquipDataProcessService.getJgUseRegistrationService().getInspectionDetectionInfoService().getBaseMapper(), inspectionDetectionInfoOld, inspectionDetectionInfoNew, projectContraptionChangeDataDto.getProjectContraptionId() + "/" + item.getRecord(), "SEQUENCE_NBR", inspectionDetectionInfoOld.getSequenceNbr());
            allChangeColumns.addAll(inspectionFieldChangeMetas);
            esUpdateService.updateEsData(item.getRecord(), inspectionDetectionInfoNew);
        }
    }

    private void updateConstructionInfo(PipelineChangeItemDto item, ProjectContraptionChangeDataDto projectContraptionChangeDataDto, List<FieldChangeMeta> allChangeColumns) {
        String constructionInfoSeq = item.getConstructionInfoSeq();
        if (constructionInfoSeq != null) {
            IdxBizJgConstructionInfo constructionInfoOld = commonEquipDataProcessService.getJgUseRegistrationService().getIdxBizJgConstructionInfoService().getById(constructionInfoSeq);
            // todo 安装年月特殊处理 格式刷yyyy-MM
            IdxBizJgConstructionInfo constructionInfoNew = new IdxBizJgConstructionInfo();
            // 统一格式按照年月进行比较
            Optional.ofNullable(constructionInfoOld.getUscDate()).ifPresent(u -> constructionInfoOld.setUscDate(DateUtil.parse(DateUtil.format(u, DatePattern.NORM_MONTH_FORMAT), DatePattern.NORM_MONTH_FORMAT)));
            BeanUtil.copyProperties(constructionInfoOld, constructionInfoNew, true);
            Optional.ofNullable(item.getUscDate()).ifPresent(u -> item.setUscDate(DateUtil.parse(u, DatePattern.NORM_MONTH_FORMAT).toDateStr()));
            BeanUtil.copyProperties(item, constructionInfoNew, true);
            constructionInfoNew.setSequenceNbr(constructionInfoOld.getSequenceNbr());
            List<FieldChangeMeta> constructionInfoFieldChangeMetas = commonEquipDataProcessService.simpleTrackAndUpdate(commonEquipDataProcessService.getJgUseRegistrationService().getIdxBizJgConstructionInfoService().getBaseMapper(), constructionInfoOld, constructionInfoNew, projectContraptionChangeDataDto.getProjectContraptionId() + "/" + item.getRecord(), "SEQUENCE_NBR", constructionInfoOld.getSequenceNbr());
            allChangeColumns.addAll(constructionInfoFieldChangeMetas);
        }
    }

    private void updateUseInfo(PipelineChangeItemDto updatePieLine, ProjectContraptionChangeDataDto projectContraptionChangeDataDto, List<FieldChangeMeta> allChangeColumns) {
        IdxBizJgUseInfo useInfoOld = commonEquipDataProcessService.getJgUseRegistrationService().getUseInfoMapper().selectOne(new LambdaQueryWrapper<IdxBizJgUseInfo>().eq(IdxBizJgUseInfo::getRecord, updatePieLine.getRecord()));
        IdxBizJgUseInfo useInfoNew = new IdxBizJgUseInfo();
        BeanUtil.copyProperties(useInfoOld, useInfoNew, true);
        BeanUtil.copyProperties(updatePieLine, useInfoNew, true);
        useInfoNew.setUseDate(projectContraptionChangeDataDto.getUseDate());
        useInfoNew.setSequenceNbr(useInfoOld.getSequenceNbr());
        setNewUseAddressInfo(projectContraptionChangeDataDto, useInfoNew);
        // 冗余的字典名称字段更新
        commonEquipDataProcessService.setNameByCode2UseInfo(useInfoNew);
        List<FieldChangeMeta> useInfoFieldChangeMetas = commonEquipDataProcessService.simpleTrackAndUpdate(commonEquipDataProcessService.getJgUseRegistrationService().getUseInfoMapper(), useInfoOld, useInfoNew, projectContraptionChangeDataDto.getProjectContraptionId() + "/" + useInfoNew.getRecord(), "record", useInfoNew.getRecord());
        // 管道不记录使用信息变化，使用信息的变化已装置来体现
        // allChangeColumns.addAll(useInfoFieldChangeMetas);
    }

    static void setNewUseAddressInfo(ProjectContraptionChangeDataDto projectContraptionChangeDataDto, IdxBizJgUseInfo useInfoNew) {
        useInfoNew.setUseUnitCreditCode(projectContraptionChangeDataDto.getUseUnitCreditCode());
        useInfoNew.setUseUnitName(projectContraptionChangeDataDto.getUseUnitName());
        useInfoNew.setProjectContraption(projectContraptionChangeDataDto.getProjectContraption());
        useInfoNew.setProjectContraptionId(projectContraptionChangeDataDto.getProjectContraptionId());
        useInfoNew.setProvince(projectContraptionChangeDataDto.getProvince());
        useInfoNew.setProvinceName(projectContraptionChangeDataDto.getProvinceName());
        useInfoNew.setCity(projectContraptionChangeDataDto.getCity());
        useInfoNew.setCityName(projectContraptionChangeDataDto.getCityName());
        useInfoNew.setCounty(projectContraptionChangeDataDto.getCounty());
        useInfoNew.setCountyName(projectContraptionChangeDataDto.getCountyName());
        useInfoNew.setFactoryUseSiteStreet(projectContraptionChangeDataDto.getStreet());
        useInfoNew.setStreetName(projectContraptionChangeDataDto.getStreetName());
        useInfoNew.setAddress(projectContraptionChangeDataDto.getAddress());
    }

    private void setNameForDictKey(ProjectContraptionChangeDataDto projectContraptionChangeDataDto) {
        // 1.使用地点name冗余
        // 市
        List<LinkedHashMap> city = (List<LinkedHashMap>) commonEquipDataProcessService.getRedisUtils().get("CITY");
        // 区
        List<LinkedHashMap> region = (List<LinkedHashMap>) commonEquipDataProcessService.getRedisUtils().get("REGION");
        // 街道
        List<LinkedHashMap> street = (List<LinkedHashMap>) commonEquipDataProcessService.getRedisUtils().get("STREET");
        // 城市
        if (StringUtils.isNotEmpty(projectContraptionChangeDataDto.getCity()) && !ObjectUtils.isEmpty(city)) {
            city.forEach(item -> {
                if (String.valueOf(item.get("regionCode")).equals(projectContraptionChangeDataDto.getCity())) {
                    projectContraptionChangeDataDto.setCityName(String.valueOf(item.get("regionName")));
                }
            });
        }
        // 区县
        if (StringUtils.isNotEmpty(projectContraptionChangeDataDto.getCounty()) && !ObjectUtils.isEmpty(region)) {
            region.forEach(item -> {
                if (String.valueOf(item.get("regionCode")).equals(projectContraptionChangeDataDto.getCounty())) {
                    projectContraptionChangeDataDto.setCountyName(String.valueOf(item.get("regionName")));
                }
            });
        }
        // 街道
        if (StringUtils.isNotEmpty(projectContraptionChangeDataDto.getStreet()) && !ObjectUtils.isEmpty(street)) {
            street.forEach(item -> {
                if (String.valueOf(item.get("regionCode")).equals(projectContraptionChangeDataDto.getStreet())) {
                    projectContraptionChangeDataDto.setStreetName(String.valueOf(item.get("regionName")));
                }
            });
        }
        // 属地监管部门设置
        if (StringUtils.isNotEmpty(projectContraptionChangeDataDto.getOrgCode())) {
            CompanyBo companyBo = commonEquipDataProcessService.getCommonMapper().queryCompanyByOrgCode(projectContraptionChangeDataDto.getOrgCode());
            projectContraptionChangeDataDto.setOrgName(companyBo.getCompanyName());
        }
    }


    private Map<String, Object> cast2UnderCase(Map<String, Object> re) {
        // 由于历史遗留问题，和前端保存统一，要转成大写下滑线驼峰
        Map<String, Object> result = new HashMap<>();
        re.forEach((k, v) -> {
            result.put(CharSequenceUtil.toUnderlineCase(k).toUpperCase(), v);
        });
        return result;
    }


    @Override
    public IBizDataChangeHandleStrategy.ModelType canHandleMode() {
        return DefaultBizDataChangeHandler.ModelType.singleProject;
    }
}
