package com.yeejoin.equipmanage.common.entity.dto;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 
 * <pre>
 * 在岗监测事件
 * </pre>
 *
 * @author gwb
 * @version $Id: MonitorEvent.java, v 0.1 2021年9月10日 下午3:19:23 gwb Exp $
 */
@Data
@ApiModel(value = "在岗监测事件记录", description = "")
public class MonitorEventDto implements Serializable
{
	
	/**
	 * <pre>
	 * 
	 * </pre>
	 */
	private static final long serialVersionUID = 710637336545868090L;

	@ApiModelProperty(value = "主键 ")
	private Long id;

	/**
	 * 事件内容
	 */
	@ApiModelProperty(value = "事件内容")
	private String eventContent;

	/**
	 * 事件类型
	 */
	@ApiModelProperty(value = "事件类型")
	private String eventType;

	/**
	 * 摄像头设备id
	 */
	@ApiModelProperty(value = "摄像头设备id")
	private Long videoId;

	/**
	 * 摄像头设备名称
	 */
	@ApiModelProperty(value = "摄像头设备名称")
	private String videoName;

	/**
	 * 摄像头设备编码
	 */
	@ApiModelProperty(value = "摄像头设备编码")
	private String videoCode;

	/**
	 * 摄像头设备位置
	 */
	@ApiModelProperty(value = "摄像头设备位置")
	private String videoPosition;

	/**
	 * 摄像头设备监控区域
	 */
	@ApiModelProperty(value = "摄像头设备监控区域")
	private String videoMonitorPosition;

	/**
	 * 事件状态
	 */
	@ApiModelProperty(value = "事件状态")
	private String eventState;
	
	/**
	 * 抓拍图片
	 */
	@ApiModelProperty(value = "抓拍图片")
	private String snapPictures;

	/**
	 * 发生时间
	 */
	@ApiModelProperty(value = "发生时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date eventDate;

	/**
	 * 值班人员，包括姓名、单位/部门、岗位
	 */
	@ApiModelProperty(value = "值班人员")
	private String onduty;

	/**
	 * 事件处理记录
	 */
	@ApiModelProperty(value = "事件处理记录")
	private String disposalRecord;

	/**
	 * 处理人id
	 */
	@ApiModelProperty(value = "处理人id")
	private String disposalUserId;

	/**
	 * 处置人姓名
	 */
	@ApiModelProperty(value = "处置人姓名")
	private String disposalUserName;

	/**
	 * 处理时间
	 */
	@ApiModelProperty(value = "处理时间")
	private Date disposalDate;


    @ApiModelProperty(value = "创建时间 ")
    private Date createDate;
    
}
