package com.yeejoin.amos.boot.module.elevator.api.dto;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author tb
 * @date 2021-06-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tcb_rescue_station")
@ApiModel(value = "RescueStationDto", description = "RescueStationDto")
public class RescueStationDto extends BaseDto {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "应急救援机构名称")
    private String name;

    @ApiModelProperty(value = "省份")
    private String province;

    @ApiModelProperty(value = "地市")
    private String city;

    @ApiModelProperty(value = "区县")
    private String district;

    @ApiModelProperty(value = "区域代码")
    private String regionCode;

    @ApiModelProperty(value = "地址(详细地址，包括道路、门牌号码)")
    private String address;

    @ApiModelProperty(value = "责任人id")
    private Long principalId;

    @ApiModelProperty(value = "主要负责人")
    private String principal;

    @ApiModelProperty(value = "负责人电话")
    private String principalPhone;

    @ApiModelProperty(value = "应急救援负责人")
    private String rescueLeader;

    @ApiModelProperty(value = "应急救援负责人手机号")
    private String rescueLeaderPhone;

    @ApiModelProperty(value = "应急救援负责人id")
    private Long rescueLeaderId;

    @ApiModelProperty(value = "所属单位（维保单位）")
    private String affiliatedUnit;

    @ApiModelProperty(value = "所属单位id")
    private Long affiliatedUnitId;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "距离")
    private String distance;

    @ApiModelProperty(value = "人员信息")
    List<DutyPersonDto> dutyPersonList;
}
