package com.yeejoin.amos.boot.module.tcm.api.entity;

import lombok.Data;
import lombok.experimental.Accessors;
import org.elasticsearch.common.geo.GeoPoint;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.GeoPointField;

/**
 * @author tb
 * @date 2022-04-20.
 */
@Data
@Accessors(chain = true)
@Document(indexName = "cylinder", replicas = 0)
public class EsCylinder {

	/**
	 * 主键
	 */
	@Id
	private Long sequenceNbr;

	/**
	 * 气瓶出厂编号
	 */
	@Field(type = FieldType.Text)
	private String factoryNum;

//	/**
//	 * 所属省
//	 */
//	@Field(type = FieldType.Text)
//	private String province;
//
//	/**
//	 * 所属地市
//	 */
//	@Field(type = FieldType.Text)
//	private String city;
//
//	/**
//	 * 所属区县
//	 */
//	@Field(type = FieldType.Text)
//	private String district;
//
	/**
	 * 所属区域代码
	 */
	@Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
	private String regionCode;

	/**
	 * 产权单位名称
	 */
	@Field(type = FieldType.Text)
	private String unitName;

	/**
	 * 经度
	 */
	@Field(type = FieldType.Double)
	private Double longitude;

	/**
	 * 纬度
	 */
	@Field(type = FieldType.Double)
	private Double latitude;

	/**
	 * 经纬度字段
	 */
	@GeoPointField
	private GeoPoint location;

	/**
	 * 地址
	 */
	@Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
	private String address;

}
