package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum EquipAdvanceSearchEnum {

    /**
     * 高级搜索枚举
     */
    USE_ORG_CODE("使用登记证编号", "USE_ORG_CODE", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Keyword),
    EQU_LIST("设备种类", "EQU_LIST_CODE", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryEquipList", null, null, FieldType.Keyword),
    EQU_CATEGORY("设备类别", "EQU_CATEGORY_CODE", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryEquCategory?type={type}", null, "EQU_LIST_CODE", FieldType.Keyword),
    EQU_DEFINE("设备品种", "EQU_DEFINE_CODE", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryEquDefine?type={type}", null, "EQU_CATEGORY_CODE", FieldType.Keyword),
    PRODUCT_NAME("设备名称", "PRODUCT_NAME", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Keyword),
    TECH_PARAM("技术参数", "techParam", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryTechParam", null, "EQU_LIST_CODE,EQU_CATEGORY_CODE,EQU_DEFINE_CODE,WHETHER_VEHICLE_CYLINDER,QZ_OR_TANK", FieldType.Auto),
    PARAM_RANGE("参数范围", "paramRange", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Auto),
    NEXT_INSPECT_DATE("检验有效期", "NEXT_INSPECT_DATE", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryInspectionDate", null, null, FieldType.Date),
    EQU_STATE("设备状态", "EQU_STATE", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryEquState", null, null, FieldType.Integer),
    WHETHER_VEHICLE_CYLINDER("是否车用气瓶", "WHETHER_VEHICLE_CYLINDER", null, "/statistics/comprehensiveStatisticalAnalysis/select/vehicleCylinder", null, null, FieldType.Keyword),
    QZ_OR_TANK("是否撬装球罐", "QZ_OR_TANK", null, "/statistics/comprehensiveStatisticalAnalysis/select/qzOrTank", null, null, FieldType.Auto),
    //    IS_SUPERVISORY_CODE("赋码状态", "IS_SUPERVISORY_CODE", null,"/statistics/comprehensiveStatisticalAnalysis/select/queryIsSupervisoryCode",null,null),
    DATA_QUALITY_SCORE("数据完整性", "DATA_QUALITY_SCORE", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryDataQualityScore", null, null, FieldType.Integer),
    USE_DATE("使用年限", "USE_DATE", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryUscDate", null, null, FieldType.Date),
    REGISTER_STATUS("登记状态", "registerStatus", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryRegisterStatus", null, null, FieldType.Auto),
    //    UNIT_TYPE("所属单位类型", "unitType", null,"/statistics/comprehensiveStatisticalAnalysis/select/queryUnitType",null,null),
    USC_UNIT_NAME("所属单位名称", "USE_UNIT_NAME", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Text),
    PRODUCE_UNIT_NAME("制造单位名称", "PRODUCE_UNIT_NAME", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Keyword),
    DESIGN_UNIT_NAME("设计单位名称", "designUnitName", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Text),
    ME_UNIT_NAME("维保单位名称", "MAINTAIN_UNIT_NAME", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Keyword),
    AZUSC_UNIT_NAME("安装改造维修单位名称", "USC_UNIT_NAME", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Text),
    CODE96333("96333识别码", "CODE96333", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Keyword),
    SUPERVISORY_CODE("监管码", "SUPERVISORY_CODE", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Keyword),
    EQU_TYPE("设备型号", "EQU_TYPE", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Text),
    PRODUCE_DATE("制造日期", "PRODUCE_DATE", TechnicalParameter.ParamType.DATE, "", null, null, FieldType.Date),
    designDate("设计日期", "designDate", TechnicalParameter.ParamType.DATE, "", null, null, FieldType.Date),
    use_date("投用日期", "use_date", TechnicalParameter.ParamType.DATE, "", null, null, FieldType.Date),
    ISSUE_DATE("使用登记证日期", "issueDate", TechnicalParameter.ParamType.DATE, "", null, null, FieldType.Date),
    JDJY("监督检验日期", "JDJY", TechnicalParameter.ParamType.DATE, "", null, null, FieldType.Date),
    DQJY("定期检验日期", "DQJY", TechnicalParameter.ParamType.DATE, "", null, null, FieldType.Date),
    SCJY("首次检验日期", "SCJY", TechnicalParameter.ParamType.DATE, "", null, null, FieldType.Date),
    DTJY("电梯检测日期", "DTJY", TechnicalParameter.ParamType.DATE, "", null, null, FieldType.Date),
    nextInspectDate("下次检验日期", "nextInspectDate", TechnicalParameter.ParamType.DATE, "", null, null, FieldType.Date),
    //    PRODUCE_DATE("是否进口", "PRODUCE_DATE", TechnicalParameter.ParamType.DATE,""),
    USE_PLACE_CODE("使用地点", "USE_PLACE", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Keyword),
    USE_PLACE("使用场所", "USE_SITE_CODE", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryDicData?type={type}", "ADDRESS", null, FieldType.Keyword),

    ;

    private String name;
    private String code;
    private TechnicalParameter.ParamType paramType;
    private String url;
    private String dataKey;
    private String argKey;
    private FieldType esType;

    public static JSONArray getAll() {
        JSONArray jsonArray = new JSONArray();
        for (EquipAdvanceSearchEnum item : values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label", item.name);
            jsonObject.put("value", item.code);
            jsonObject.put("key", item.code);
            jsonObject.put("dataKey", item.dataKey);
            jsonObject.put("argKey", item.argKey);
            jsonObject.put("paramType", item.paramType);
            jsonObject.put("isMulti", false);
            if (TechnicalParameter.ParamType.BIG_DECIMAL.equals(item.paramType)) {
                jsonObject.put("type", "inputNumber");
            } else if (TechnicalParameter.ParamType.STRING.equals(item.paramType)) {
                jsonObject.put("type", "input");
            } else if (TechnicalParameter.ParamType.DATE.equals(item.paramType)) {
                jsonObject.put("type", "date");
            } else {
                jsonObject.put("type", "select");
            }
            if ("技术参数".equals(item.name)) {
                jsonObject.put("type", "select2");
                jsonObject.put("method", "POST");
                jsonObject.put("conditions", ConditionEnum.getByCode("eq",item.paramType));
            } else {
                jsonObject.put("conditions", ConditionEnum.getByCode(item.paramType));
            }
            jsonObject.put("url", item.url);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }


    public static Map<String, FieldType> getEsType = new HashMap<>();

    static {
        for (EquipAdvanceSearchEnum e : EquipAdvanceSearchEnum.values()) {
            getEsType.put(e.code, e.esType);
        }
    }
}
