package com.yeejoin.amos.boot.module.common.api.dto;

import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.RoleNameExplicitConstraint;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
* 消防队员
*
* @author tb
* @date 2021-06-07
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="FirefightersDto", description="消防队员")
public class FirefightersExcelDto extends BaseDto {
    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    @ExcelIgnore
    @ApiModelProperty(value = "系统账号")
    private String systemAccount;

    @ExcelProperty(value = "姓名", index = 0)
    @ApiModelProperty(value = "姓名")
    private String name;

    @ExcelProperty(value = "员工编码", index = 1)
    @ApiModelProperty(value = "员工编码")
    private String employeeNumber;

    @ExplicitConstraint(indexNum = 2, sourceClass = RoleNameExplicitConstraint.class,method="getFireTeam") //动态下拉内容
    @ExcelProperty(value = "消防队伍", index = 2)
    @ApiModelProperty(value = "队伍")
    private String fireTeam;

    @ExcelIgnore
    @ApiModelProperty(value = "所属机构")
    private String company;

    @ExcelIgnore
    @ApiModelProperty(value = "机构code")
    private String companyCode;

    @ExplicitConstraint(indexNum = 3, sourceClass = RoleNameExplicitConstraint.class,method="getCompany") //动态下拉内容// BUG 2760 修改消防人员导出模板和 导入问题 bykongfm
    @ExcelProperty(value = "所属部门", index = 3)
    @ApiModelProperty(value = "机构名称")
    private String companyName;

    @ExplicitConstraint(type = "RYZJLX", indexNum = 4, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "证件类型", index = 4)
    @ApiModelProperty(value = "常用证件类型代码")
    private String certificatesType;

    @ExcelProperty(value = "证件号码", index = 5)
    @ApiModelProperty(value = "证件号码")
    private String certificateNumber;

    @ExcelProperty(value = "出生日期", index = 6)
    @ApiModelProperty(value = "出生日期")
    private Date birthdayTime;

    @ExplicitConstraint(indexNum = 7, source = {"男", "女"}) //固定下拉内容
    @ExcelProperty(value = "性别", index = 7)
    @ApiModelProperty(value = "性别")
    private String gender;

    @ExplicitConstraint(indexNum = 8, sourceClass = RoleNameExplicitConstraint.class, method = "getNations") //固定下拉内容
    @ExcelProperty(value = "民族", index = 8)
    @ApiModelProperty(value = "民族")
    private String nation;

    @ExplicitConstraint(indexNum = 9, sourceClass = RoleNameExplicitConstraint.class, method = "getMaritalStatus") //固定下拉内容
    @ExcelProperty(value = "婚姻状况", index = 9)
    @ApiModelProperty(value = "婚姻状况")
    private String maritalStatus;



    @ExplicitConstraint(indexNum = 10, sourceClass = RoleNameExplicitConstraint.class,method="getCitys") //动态下拉内容// BUG 2760 修改消防人员导出模板和 导入问题 bykongfm
    @ExcelProperty(value = "户籍所在地", index = 10)
    @ApiModelProperty(value = "籍贯/户口所在地的值")
    private String nativePlaceValue;

    // BUG 3658 优化 by kongfm 2021-09-13 需求详细说明 1. 添加两个字段  2. 地区选择联动  只有新增时带联动  编辑时不带联动 3. 导出模板及导入同步修改
    @ExcelProperty(value = "籍贯/户口所在地详细地址", index = 11)
    @ApiModelProperty(value = "籍贯/户口所在地详细地址")
    private String nativePlaceVal;

    @ExplicitConstraint(indexNum = 12, sourceClass = RoleNameExplicitConstraint.class, method = "getPoliticalOutlook") //固定下拉内容
    @ExcelProperty(value = "政治面貌", index = 12)
    @ApiModelProperty(value = "政治面貌代码")
    private String politicalOutlook;

    @ExplicitConstraint(indexNum = 13, sourceClass = RoleNameExplicitConstraint.class,method="getCitys") //动态下拉内容// BUG 2760 修改消防人员导出模板和 导入问题 bykongfm
    @ExcelProperty(value = "现居住地", index = 13)
    @ApiModelProperty(value = "现居住地")
    private String residence;
    // BUG 3658 优化 by kongfm 2021-09-13 需求详细说明 1. 添加两个字段  2. 地区选择联动  只有新增时带联动  编辑时不带联动 3. 导出模板及导入同步修改
    @ExcelProperty(value = "现居住地详细地址", index = 14)
    @ApiModelProperty(value = "现居住地详细地址")
    private String residenceDetailVal;

    @ExcelProperty(value = "机场住宿情况", index = 15)
    @ApiModelProperty(value = "机场住宿情况")
    private String airportAccommodation;

    @ExcelProperty(value = "联系电话", index = 16)
    @ApiModelProperty(value = "手机")
    private String mobilePhone;

    @ExplicitConstraint(type = "RYZT", indexNum = 17, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "人员状态", index = 17)
    @ApiModelProperty(value = "人员状态，在职/离职")
    private String state;

    @ExcelIgnore
    @ApiModelProperty(value = "人员状态，在职/离职字典code")
    private String stateCode;

    @ExplicitConstraint(type = "GWMC", indexNum = 18, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "岗位名称", index = 18)
    @ApiModelProperty(value = "岗位名称")
    private String jobTitle;

    @ExcelProperty(value = "紧急联系人姓名", index = 19)
    @ApiModelProperty(value = "紧急联系人姓名")
    private String emergencyContact;

    @ExplicitConstraint(type = "RJGX", indexNum = 20, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "与紧急联系人关系", index = 20)
    @ApiModelProperty(value = "紧急联系人与本人所属关系")
    private String relationship;

    @ExcelProperty(value = "紧急联系人电话", index = 21)
    @ApiModelProperty(value = "紧急联系人电话")
    private String emergencyContactPhone;

    @ExcelIgnore
    @ApiModelProperty(value = "身份证正面")
    private String idPositive;

    @ExcelIgnore
    @ApiModelProperty(value = "身份证反面")
    private String idReverse;

    @ExcelIgnore
    @ApiModelProperty(value = "办公电话")
    private String officeTelephone;

    @ExcelIgnore
    @ApiModelProperty(value = "互联网_电子信箱")
    private String email;

    @ExcelIgnore
    @ApiModelProperty(value = "人员照片")
    private String personnelPhotos;

    @ExcelIgnore
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ExcelIgnore
    @ApiModelProperty(value = "操作人名称")
    private String recUserName;
    
    @ExcelIgnore
    @ApiModelProperty(value = "人员id")
    private Long firefightersId;
	/*************************岗位职级***********************/
    @ApiModelProperty(value = "员工层级")
    @ExcelProperty(value = "员工层级", index = 22)
    @ExplicitConstraint(type = "YGCJ", indexNum = 22, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    private String employeeHierarchy;

    @ApiModelProperty(value = "行政职务")
    @ExplicitConstraint(type = "XZZW", indexNum = 23, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "行政职务", index = 23)
    private String administrativePosition;

    @ApiModelProperty(value = "岗位资质")
    @ExplicitConstraint(type = "GWZZ", indexNum = 24, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "岗位资质", index = 24)
    private String postQualification;

    @ApiModelProperty(value = "消防救援人员类别")
    @ExplicitConstraint(type = "XFRYLB", indexNum = 25, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "消防救援人员类别", index = 25)
    private String category;

//    @ApiModelProperty(value = "消防救援人员状态")
//    private String state;

    @ApiModelProperty(value = "消防救援衔级别代码")
    @ExplicitConstraint(type = "XFJYJB", indexNum = 26, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "消防救援衔级别代码", index = 26)
    private String level;

    @ApiModelProperty(value = "消防专家领域")
    @ExplicitConstraint(type = "ZJLY", indexNum = 27, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "消防专家领域", index = 27)
    private String areasExpertise;
    
    /*************************学历教育***********************/
    @ApiModelProperty(value = "第一学历")
    @ExplicitConstraint(type = "XLLX", indexNum = 28, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "第一学历", index = 28)
    private String firstDegree;

    @ApiModelProperty(value = "最高学历")
    @ExplicitConstraint(type = "XLLX", indexNum = 29, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "最高学历", index = 29)
    private String highestEducation;

    @ApiModelProperty(value = "学位")
    @ExplicitConstraint(type = "XWLX", indexNum = 30, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "学位", index = 30)
    private String academicDegree;

    @ApiModelProperty(value = "毕业院校")
    @ExcelProperty(value = "毕业院校", index = 31)
    private String school;

    @ApiModelProperty(value = "毕业专业名称")
    @ExcelProperty(value = "毕业专业名称", index = 32)
    private String professionalName;

    
    /*************************工作履历岗***********************/
    @ApiModelProperty(value = "参加工作时间")
    @ExcelProperty(value = "参加工作时间", index = 33)
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date workingHours;

	@ApiModelProperty(value = "参加消防部门工作时间")
	 @ExcelProperty(value = "参加消防部门工作时间", index = 34)
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date fireWorkingHours;
	
	
	

 
    
    
	

}
