package com.yeejoin.amos.boot.module.common.api.dto;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author DELL
 */
@Data
@ApiModel(value="PeopleInfoDto", description="人员基本信息")
public class PeopleBasicInfoDto {
    @ApiModelProperty(value = "系统账号")
    private String systemAccount;

    @ApiModelProperty(value = "员工编码")
    private String personNumber;

    @ApiModelProperty(value = "所属机构")
    private String company;

    @ApiModelProperty(value = "岗位类型-用于列表筛选")
    private String positionType;

    @ApiModelProperty(value = "机构code")
    private String companyCode;

    @ApiModelProperty(value = "是否进行安全培训")
    private String safetyTraining;

    @ApiModelProperty(value = "人员照片")
    private String personImg;

    @ApiModelProperty(value = "重点工种资质证书")
    private String certificateImg;

    @ApiModelProperty(value = "队伍id")
    private Long fireTeamId;

    @ApiModelProperty(value = "消防队伍名称")
    private String  fireTeamName;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "常用证件类型代码")
    private String certificatesType;

    @ApiModelProperty(value = "常用证件类型代码code")
    private String certificatesTypeCode;


    @ApiModelProperty(value = "证件号码")
    private String certificatesNumber;

    @ApiModelProperty(value = "出生日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date birthdayTime;

    @ApiModelProperty(value = "性别")
    private String gender;

    @ApiModelProperty(value = "民族")
    private String nation;

    @ApiModelProperty(value = "籍贯/户口所在地")
    private String nativePlace;

    @ApiModelProperty(value = "籍贯/户口所在地")
    private String nativePlaceCode;

    @ApiModelProperty(value = "现居住地")
    private String residence;

    @ApiModelProperty(value = "现居住地")
    private String residenceDetails;

    @ApiModelProperty(value = "现居住地")
    private String residenceDetailsCode;

    @ApiModelProperty(value = "机场住宿情况")
    private String airportAccommodation;

    @ApiModelProperty(value = "岗位名称")
    private String jobTitle;


    @ApiModelProperty(value = "岗位名称数据字典code")
    private String jobTitleCode;

    @ApiModelProperty(value = "人员状态，在职/离职")
    private String state;
    @ApiModelProperty(value = "人员状态，在职/离职字典code")
    private String stateCode;

    @ApiModelProperty(value = "婚姻状况")
    private String maritalStatus;

    @ApiModelProperty(value = "办公电话")
    private String telephone;

    @ApiModelProperty(value = "手机")
    private String mobilePhone;

    @ApiModelProperty(value = "互联网_电子信箱")
    private String email;

    @ApiModelProperty(value = "政治面貌代码")
    private String politicalOutlook;

    @ApiModelProperty(value = "人员照片")
    private String personnelPhotos;

    @ApiModelProperty(value = "身份证正面")
    private String idPositive;

    @ApiModelProperty(value = "身份证反面")
    private String idReverse;

    @ApiModelProperty(value = "更新时间")
    @TableField(fill= FieldFill.UPDATE)
    private Date updateTime;

    @ApiModelProperty(value = "机构名称")
    private String companyName;

    @ApiModelProperty(value = "籍贯/户口所在地的值")
    private String nativePlaceValue;

    // BUG 3658 优化 by kongfm 2021-09-13 需求详细说明 1. 添加两个字段  2. 地区选择联动  只有新增时带联动  编辑时不带联动 3. 导出模板及导入同步修改
    @ApiModelProperty(value = "户籍所在地详细地址")
    private String nativePlaceVal;

    @ApiModelProperty(value = "现居住地详细地址")
    private String residenceDetailVal;

    @ApiModelProperty(value = "amos账户名称")
    private String amosName;

    @ApiModelProperty(value = "amos账户id")
    private String amosUserId;

    @ApiModelProperty(value = "机构/部门名称")
    private String bizOrgName;

    @ApiModelProperty(value = "机构编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "人员类型")
    private String peopleType;

    @ApiModelProperty(value = "主键")
    private String sequenceNbr;

    @ApiModelProperty(value = "用户id")
    private String userId;

    @ApiModelProperty(value = "单位人员id")
    private String orgUsrId;

}
