package com.yeejoin.precontrol.common.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

/**
 * 奖励表Vo
 *
 * @author duanwei
 * @date 2021-04-06
 */
@Data
public class RewardVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 奖励人id
     */
    @ApiModelProperty(value = "奖励人id")
    private Long personId;
    /**
     * 奖励人奖励人姓名
     */
    @ApiModelProperty(value = "奖励人姓名")
    @Excel(name = "奖励人姓名")
    private String userName;
    /**
     * 任务id
     */
    @ApiModelProperty(value = "任务id")
    private Long taskId;
    /**
     * 单号
     */
    @ApiModelProperty(value = "单号")
    private String taskNo;
    /**
     * 任务类型
     */
    @ApiModelProperty(value = "任务类型")
    private String taskType;
    /**
     * 业务类型
     */
    @ApiModelProperty(value = "业务类型")
    private String businessType;
    /**
     * 分包商名称
     */
    @ApiModelProperty(value = "分包商名称")
    private String companyName;
    /**
     * 分包商名称
     */
    @ApiModelProperty(value = "分包商id")
    private Long companyId;
    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String taskName;
    /**
     * 状态Code
     */
    @ApiModelProperty(value = "任务状态Code")
    private String statusCode;
    /**
     * 状态描述
     */
    @ApiModelProperty(value = "任务状态描述")
    private String statusValue;
    /**
     * 奖励金额
     */
    @ApiModelProperty(value = "奖励金额")
    @Excel(name = "奖励金额")
    private BigDecimal money;
    /**
     * 状态（0-未兑换，1-已兑换）
     */
    @ApiModelProperty(value = "状态（0-未兑换，1-已兑换）")
    private Integer status;
    /**
     * 状态名称 （0-未兑换，1-已兑换）
     */
    @ApiModelProperty(value = "状态（0-未兑换，1-已兑换）")
    private String statusName;
    /**
     * 兑换日期
     */
    @ApiModelProperty(value = "兑换日期")
    private Date exchangeDate;
    /**
     * 开始日期
     */
    @ApiModelProperty(value = "开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /**
     * 结束日期
     */
    @ApiModelProperty(value = "结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;


    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    //@JsonFormat(pattern = "yyyy-MM-dd")
    private Date createDate;

    /**
     * 奖励人头像
     */
    @ImagePrefix
    @ApiModelProperty(value = "奖励人头像")
    private String headPhoto;

    /**
     * 奖励人角色
     */
    @ApiModelProperty(value = "奖励人角色")
    private String roleName;

    /**
     * 违章类型
     */
    @ApiModelProperty(value = "违章类型")
    @Excel(name = "违章类型")
    private String nature;

    /**
     * 项目名称
     */
    @ApiModelProperty(value = "项目名称")
    @Excel(name = "项目名称")
    private String projectName;


    /**
     * 累计违章检查数量
     */
    @ApiModelProperty(value = "累计违章检查数量")
    private Integer sumViolationCount;

    /**
     * 累计奖励金额
     */
    @ApiModelProperty(value = "累计奖励金额")
    private BigDecimal sumRewardMoney;

    /**
     * 已发放违章检查数量
     */
    @ApiModelProperty(value = "已发放违章检查数量")
    private Integer issuedViolationCount;

    /**
     * 已发放奖励金额
     */
    @ApiModelProperty(value = "已发放奖励金额")
    private BigDecimal issuedRewardMoney;

    /**
     * 未发放违章检查数量
     */
    @ApiModelProperty(value = "未发放违章检查数量")
    private Integer unissuedViolationCount;

    /**
     * 未发放奖励金额
     */
    @ApiModelProperty(value = "未发放奖励金额")
    private BigDecimal unissuedRewardMoney;

    /**
     * 开始时间
     */
    @ApiModelProperty(value = "开始时间")
    private String beforeCreateDate;

    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间")
    private String endCreateDate;
    
    
    private int operType;

    
	@ApiModelProperty(value = "排序")
	private String sort;

	@ApiModelProperty(value = "排序字段名")
	private String sortName;
	
	@ApiModelProperty(value = "排序顺序")
	private String sortOrder;
}
