package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireEquipmentSignalDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireEquipmentSignalServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 设备报警信息表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "设备信号信息表Api")
@RequestMapping(value = "/fire-equipment-signal")
public class FireEquipmentSignalController extends BaseController {

    @Autowired
    FireEquipmentSignalServiceImpl fireEquipmentSignalServiceImpl;

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "设备报警信息表列表全部数据查询", notes = "设备报警信息表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireEquipmentSignalDto>> selectForList() {
        return ResponseHelper.buildResponse(fireEquipmentSignalServiceImpl.queryForFireEquipmentAlarmList());
    }
}
