package com.yeejoin.equipmanage.fegin;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;

//装备
@FeignClient(name ="${patrol.fegin.name}",configuration={MultipartSupportConfig.class})
public interface PatrolFeign  {

    @RequestMapping(value = "/patrol/api/equipmnetRule/equipmnetInput", method = RequestMethod.POST ,consumes="application/json")
    Object getEquipDetail(@RequestBody(required = true)String equipRuleParams);


    @RequestMapping(value = "/patrol/api/user/patrolCount", method = RequestMethod.GET ,consumes="application/json")
    Object getPatrolCount( @RequestHeader(name = "appKey", required = true) String appKey,
                           @RequestHeader(name = "product", required = true) String product,
                           @RequestHeader(name = "token", required = true) String token);

//    @Component
//    static class PatrolFeignHystrix implements PatrolFeign{
//        @Override
//        public Object getEquipDetail(String equipRuleParams) {
//            throw  new BaseException(BaseExceptionEnum.REQUEST_TIME_OUT.getCode(),BaseExceptionEnum.REQUEST_TIME_OUT.getMsg());
//        }
//
//        @Override
//        public Object getPatrolCount(String appKey, String product, String token) {
//            throw  new BaseException(BaseExceptionEnum.REQUEST_TIME_OUT.getCode(),BaseExceptionEnum.REQUEST_TIME_OUT.getMsg());
//        }
//    }
}

