package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.biz.common.dto.OrgMenuDto;
import com.yeejoin.amos.feign.morphic.model.ResourceDTO;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.equipmanage.common.entity.Building;
import com.yeejoin.equipmanage.common.entity.SourceScene;
import com.yeejoin.equipmanage.common.entity.dto.BuildIsRiskDTO;
import com.yeejoin.equipmanage.common.entity.dto.BuildSearchDTO;
import com.yeejoin.equipmanage.common.entity.vo.BuildingListVO;
import com.yeejoin.equipmanage.common.entity.vo.BuildingVideoListVO;
import com.yeejoin.equipmanage.common.entity.vo.BuildingVideoVO;
import com.yeejoin.equipmanage.common.entity.vo.EquiplistSpecificBySystemVO;
import com.yeejoin.equipmanage.common.entity.vo.PointTreeVo;
import com.yeejoin.equipmanage.common.vo.BuildingTreeAndEquipVO;
import com.yeejoin.equipmanage.common.vo.BuildingTreeVo;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author ZeHua Li
 * @date 2020/11/12 15:39
 * @since v2.0
 */
public interface IBuilldService extends IService<Building> {
    /**
     * @param groupCode
     * @Description 根据groupCode查询allowOperation对应的操作菜单
     * @Return List<DictionarieValueModel>
     * @Date 2020/12/18 10:13
     */
    List<DictionarieValueModel> rightClickMenu(String groupCode);

    /**
     * 创建画布
     *
     * @param model 模型
     * @return RiskSourceScene
     */
    Map<String, String> createMorphic(Map<String, String> model);

    /**
     * 更新画布
     *
     * @param resourceDTO 参数
     */
    ResourceDTO updateMorphic(ResourceDTO resourceDTO);


    /**
     * 删除画布
     * @param id
     * @return
     */
    Boolean isDeleteCanvas(Long id);


    /**
     * 根据类型，id，获取画布list
     *
     * @param id
     * @param groupType
     * @return
     */
    List<SourceScene> getScenesList(Long id, String groupType);

    /**
     * 消防建筑树查询接口
     *
     * @return List<BuildingTreeVo>
     */
    List<BuildingTreeVo> getBuildingTree(String bizOrgCode);

    /**
     * 消防建筑树查询接口(带条件bizOrgCode)
     *
     * @return List<BuildingTreeVo>
     */
    List<BuildingTreeVo> getBuildingTreeByBizOrgCode(String bizOrgCode);

    /**
     * 消防建筑层级树查询接口
     *
     * @return List<BuildingTreeVo>
     */
    List<BuildingTreeVo> getBuildingTierTree(Integer tier);

    /**
     * 通用表单保存
     *
     * @param groupCode   表单类型
     * @param companyCode 公司编号
     * @param map         form
     * @return Object
     */
    Object saveForm(String groupCode, String companyCode, Map<String, Object> map, String caseId);

    /**
     * 通用表单更新
     *
     * @param instanceId 实例id
     * @param companyCode 公司编号
     * @param map         form
     * @return Object
     */
    Object updateForm(Long instanceId, String companyCode, Map<String, Object> map, String groupCode);

    /**
     * 获取 建筑装备树
     *
     * @return
     * @param bizOrgCode
     */
    List<PointTreeVo> getBuildTree(String bizOrgCode,String instanceId);

    List<PointTreeVo> getEquipTree(String bizOrgCode,String instanceId,String displayName);

    List<PointTreeVo> getBuildTreeNew(String bizOrgCode,String instanceId);
    List<PointTreeVo> getBuildTreeNot(String bizOrgCode);
    /**
     * 获取 建筑装备树
     *
     * @return
     */
    List<PointTreeVo> get3dBuildTree();
    /**
     * @Description 分页查询
     * @param dto 查询参数
     * @Return List<Map<String,Object>>
     * @Date 2020/12/19 11:47
     */
    Page buildingList(Page page, BuildSearchDTO dto);
    /**
     * @Description 建筑楼层分页查询
     * @param dto 查询参数
     * @Return List<Map<String,Object>>
     * @Date 2020/12/19 11:47
     */
    Page floorPage(Page page, BuildSearchDTO dto);
    /**
     * @Description 房间
     * @param page
     * @param dto
     * @Return Page
     * @Date 2020/12/22 13:55
     */
    Page roomPage(Page page, BuildSearchDTO dto);
    /**
     * @Description 装备统计
     * @param instanceId 查询参数
     * @param groupType 分组类型
     * @Return List<Map<String,Object>>
     * @Date 2020/12/19 11:47
     */
    Long equipmentTotal(Long instanceId,String groupType);
    /**
     * @Description 所属楼层
     * @param map
     * @Date 2020/12/22 11:29
     */
    void sourceBuild(Map<String,Object> map);
    /**
     * @Description 统计房间数
     * @param coll
     * @Date 2020/12/22 15:33
     */
    void roomNum(List<Map<String,Object>> coll,Map<String,Object> map);
    /**
     * @Description 文件
     * @param map
     * @Return
     * @Exception
     * @Date 2020/12/22 19:39
     */
    void files(Map<String,Object> map);
    /**
     * 查询详情
     * @param instanceId 实例id
     * @return List<Map<String, Object>>
     */
    Map<String, Object> buildingDetail(Long instanceId);

    /**
     * 建筑删除
     * @param instanceId 实例id
     * @return Boolean
     */
    Boolean deleteBuilding(Long instanceId);

    /**
     * 查询所有树节点操作
     * @return Map<String, Object>
     */
    Map<String, Object> getAllPermission();

    /**
     * 获取建筑下库存装备数量
     * @param id
     * @param groupType
     * @return
     */
    Map<String ,Object> getEveryCount( Long id, String  groupType, String bizOrgCode);

    /**
     * 消防建筑视屏监控统计树
     * @return
     */
    List<BuildingTreeVo> getBuildingVideoTree();

    /**
     * 消防建筑视屏监控分页列表
     * @param page
     * @param dto
     * @return
     */
    Page<BuildingVideoVO> buildingVideoList(Page page, BuildingVideoListVO dto);

    /**
     * 通过监控视频 查看 绑定的 消防设备
     * @param videoId
     * @return
     */
    List<BuildingListVO> getFireEquipByVideoId(Long videoId);

    /**
     * 通过监控视频 查看 绑定的  电力设备
     * @param videoId
     * @return
     */
    List<BuildingListVO> getPowerEquipByVideoId(Long videoId);

    List<BuildIsRiskDTO> getChildrenNotIsRiskList(String instanceId);

    /**
     * 解除区域与建筑绑定
     * @param instanceId 建筑id
     */
    void unbindRelation(Long instanceId);

    /**
     * 消防建筑视屏监控统计树
     * @return
     */
    List<BuildingTreeVo> getBuildingVideoColaTree();

    /**
     * 消防建筑可乐视屏监控分页列表
     * @param page
     * @param dto
     * @return
     */
    Page<BuildingVideoVO> buildingColaVideoList(Page page, BuildingVideoListVO dto);

    /**
     * 通过监控视频查看绑定的消防设备
     * @param id
     * @return
     */
    List<BuildingListVO> getFireEquipment(Long id);

    /**
     * 通过监控视频查看绑定的安防设备
     * @param id
     * @return
     */
    List<BuildingListVO> getSecurityEquipment(Long id);

    /**
     * 建筑和装备树
     * @return
     */
    List<BuildingTreeAndEquipVO> gettreeAndEquip();


    Map<String ,Object> getBuildDetaliByFloorId( String  instanceId);

    /**
     * 获取id与绝对位置对应的的map
     * @return
     */
    Map<Long, String> getBuildingAbsolutePosition();

    Map<String, Long> getBuildingCodeKey();

    /**
     * 根据所属单位id获取储罐编号
     * @return
     */
    Map<String, String> getStorageTankCodeByBelongUnitId(String belongUnitId,String groupCode);

    /** // 需求958 导出模板需要列表获取建筑 by kongfm 2021-09-15
     * 查询所有建筑 用于数据字典
     * @return Map<String, Object>
     */
    List<LinkedHashMap<String, Object>> getAllBuilding();
/**
 * 查询指定建筑的经纬度信息
 * @param instanceId
 * @return
 */
	Map<String, String> getBuildingToLongitudeAndLatitude(String instanceId);

    /**
     * 根据登陆人获取公司部门树
     * @return list
     * @param authKey
     */
    List<BuildingTreeVo> getCompanyBuildingTree(String authKey);

    /**
     * 获取单位树
     * @param authKey
     * @return
     */
    List<BuildingTreeVo> selectCompanyTree(String authKey);


    List<BuildingTreeVo> getBuildingVideoTreeNew();

	List<Map<String, Object>> getBuildingDetaiList();

    /**
     * 查询指定楼层下装备、摄像头
     * @param floorId 楼层id
     * @return List<EquiplistSpecificBySystemVO>
     */
    List<EquiplistSpecificBySystemVO> getPointInFloor(Long floorId);

    /**
     * 建筑树
     * @param bizOrgCode 所在公司
     * @return List<BuildingTreeVo>
     */
    List<BuildingTreeVo> getBuildingTreeInOrgCode(String bizOrgCode);

    List<OrgMenuDto> companyTreeByUserAndType();

    List<BuildingTreeVo> treeByName(String bizOrgCode, String name);
}
