package com.yeejoin.amos.boot.module.tdc.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.module.tdc.api.dto.CheckResultDto;
import com.yeejoin.amos.boot.module.tdc.api.dto.DimensionTableDto;
import com.yeejoin.amos.boot.module.tdc.api.dto.ModelTreeDto;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckResult;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;


@Service
public interface CheckResultService extends IService<CheckResult> {


    IPage<CheckResultDto> selectResult(int current,int size,String code);

    List<CheckResult> selectCheckResult(String batchNo);

    Map<String,Object> selectTotal(String batchNo);

    List<CheckResultDto> selectStatistion(String batchNo,String amosOrgCode);

    List<CheckResultDto> selectDetails(String batchNo,Integer modelId);

    String saveSql(String amosOrgCode,String userName, String batchNo);

    /**
     * 根据机构code获取模型数据树
     * @param amosOrgCode 机构code
     * @return 树
     */
    List<ModelTreeDto> getAllModelDataTree(String amosOrgCode);

    /**
     * 根据模型id获取模型数据树
     * @param modelId 模型id
     * @return 树
     */
    List<ModelTreeDto> getModelDataTree(String modelId);

    /**
     * 根据批次号查询存储属性个数
     * @param batchNo 批次号
     * @return 属性个数
     */
    Integer selectItemCount(String batchNo);

    /**
     * 查询不合格项
     * @param batchNo 批次号
     * @return 属性个数
     */
    Integer selectItemNo(String batchNo,Long modelId);

    List<DimensionTableDto> getDimensionTable(String id);

}
