package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireVideoDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireBuildingServiceImpl;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireVideoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 消防视频表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "消防视频表Api")
@RequestMapping(value = "/fire-video")
public class FireVideoController extends BaseController {

    @Autowired
    FireVideoServiceImpl fireVideoServiceImpl;


    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{stationCode}/page")
    @ApiOperation(httpMethod = "GET", value = "消防视频表分页查询", notes = "消防视频表分页查询")
    public ResponseModel<Page<FireVideoDto>> queryForPage(
            @ApiParam(value = "建筑名称") @RequestParam(value = "name", required = false) String name,
            @ApiParam(value = "当前页", required = true) @RequestParam(value = "current") int current,
            @ApiParam(value = "页大小", required = true) @RequestParam(value = "size") int size,
            @ApiParam(value = "换流站code", required = true) @PathVariable String stationCode,
            @ApiParam(value = "所在建筑,多个用逗号分隔") @RequestParam(value = "buildingMrids", required = false) String buildingMrids) {
        List<String> buildingMridList = new ArrayList<>();
        //根节点id(全部建筑时使用，本来可以不送来实现过滤，但是地图前端不支持)
        String rootMrid = FireBuildingServiceImpl.ROOT_ID;
        if (StringUtils.isNotBlank(buildingMrids) && !rootMrid.equals(buildingMrids)) {
            buildingMridList = Arrays.stream(buildingMrids.split(",")).collect(Collectors.toList());
        }
        Page<FireVideoDto> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(fireVideoServiceImpl.queryForFireVideoPage(page, name, stationCode, buildingMridList));
    }

}
