package com.yeejoin.amos.boot.module.common.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 故障报修验收记录
 *
 * @author system_generator
 * @date 2021-08-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="FailureVerifyDto", description="故障报修验收记录")
public class FailureVerifyDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "验收人")
    private String acceptor;

    @ApiModelProperty(value = "验收部门")
    private String verifyDepartment;

    @ApiModelProperty(value = "验收部门的id")
    private Long verifyDepartmentId;

    @ApiModelProperty(value = "审核结果 0：同意 1：拒绝 ")
    private Integer verifyResult;

    @ApiModelProperty(value = "验收时间")
    private Date verifyTime;

    @ApiModelProperty(value = "验收意见")
    private String verifyOpinion;

    @ApiModelProperty(value = "设备故障报修单id")
    private Long faultId;

 @ApiModelProperty(value = "审核结果条件判断，0同意，1拒绝")
 private String condition;


}
