package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author LiuLin
 *
 */
@Getter
@AllArgsConstructor
public enum VehicleApanageEnum {

    /**
     * 属性机构枚举
     */
    XIAN("陕A","610100"),
    TONG_CHUAN("陕B","610200"),
    BAO_JI("陕C","610300"),
    XIAN_YANG("陕D","610400"),
    WEI_NAN("陕E","610500"),
    YAN_AN("陕J","610600"),
    HAN_ZHONG("陕F","610700"),
    YU_LIN("陕K","610800"),
    AN_KANG("陕G","610900"),
    SHANG_LUO("陕H","611000"),
    XI_XIAN("陕U","617000"),
    YANG_LING("陕V","610403"),
    SHEN_MU("陕K","610881"),
    FU_GU("陕K","610822"),
    HAN_CHENG("陕Y","610581");

    private final String city;
    private final String code;

    /**
     * 根据机构代码返回属地前缀
     * @param code 属地代码
     * @return 属地前缀
     */
    public static String of(String code){
        for(VehicleApanageEnum e : VehicleApanageEnum.values()){
            if(e.getCode().equals(code)){
                return e.getCity();
            }
        }
        return null;
    }
}
