package com.yeejoin.equipmanage.fegin;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;


/**
 * @author DELL
 */
@FeignClient(name = "${iot.vehicle.track}", path = "iot", configuration = {FeignConfiguration.class})
public interface IotFeign {

    @RequestMapping(value = "/v1/livedata/list", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel selectList(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestParam(value = "timeStart") String beginDate,
            @RequestParam(value = "timeEnd") String endDate,
            @RequestParam(value = "productKey") String productKey,
            @RequestParam(value = "deviceName") String deviceName,
            @RequestParam(required = false, value = "fieldKey") String fieldKey);

    @RequestMapping(value = "/v1/livedata/page", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel selectPage(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestParam(value = "timeStart") String beginDate,
            @RequestParam(value = "timeEnd") String endDate,
            @RequestParam(value = "productKey") String productKey,
            @RequestParam(value = "deviceName") String deviceName,
            @RequestParam(required = false, value = "fieldKey") String fieldKey,
            @RequestParam(value = "current") Integer current,
            @RequestParam(value = "size") Integer size);



    @RequestMapping(value = "v1/livedata/common/top", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel selectOne(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestParam(value = "top") String top,
            @RequestParam(value = "productKey") String productKey,
            @RequestParam( required = false, value = "deviceName") String deviceName,
            @RequestParam("FHS_PressurePump_Start") String key,
            @RequestParam(required = false, value = "fieldKey") String fieldKey);

    @RequestMapping(value = "v1/livedata/common/list", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel selectListNew(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestParam(value = "measurement") String measurement,
            @RequestParam(value = "timeStart") String beginDate,
            @RequestParam(value = "timeEnd") String endDate,
            @RequestParam("FHS_PressurePump_Start") String key,
            @RequestParam(required = false, value = "fieldKey") String fieldKey);


}
