package com.yeejoin.equipmanage.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarmLog;
import com.yeejoin.equipmanage.common.enums.IndexStatusEnum;
import com.yeejoin.equipmanage.common.utils.DateUtils;
import com.yeejoin.equipmanage.common.utils.StringUtil;
import com.yeejoin.equipmanage.common.utils.UnitTransformUtil;
import com.yeejoin.equipmanage.fegin.IotFeign;
import com.yeejoin.equipmanage.mapper.EmergencyMapper;
import com.yeejoin.equipmanage.service.IEmergencyService;
import com.yeejoin.equipmanage.service.IEquipmentSpecificAlarmLogService;
import com.yeejoin.equipmanage.service.IEquipmentSpecificSerivce;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.ParseException;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 *
 * 四横八纵应急模块接口服务类
 *
 */
@Service
public class EmergencyServiceImpl implements IEmergencyService {


    @Autowired
    private EmergencyMapper emergencyMapper;

    @Autowired
    private IEquipmentSpecificSerivce equipmentSpecificSerivce;

    @Autowired
    private IEquipmentSpecificAlarmLogService equipmentSpecificAlarmLogService;

    @Autowired
    private IotFeign iotFeign;

    @Value("${equipment.pressurepump.start}")
    private String pressurePumpStart;

    @Override
    public List<Map<String, Object>> getSystemState(String bizOrgCode) {
        List<Map<String, Object>> list = emergencyMapper.getSystemState(bizOrgCode);
        if (0 < list.size()) {
            list.forEach(x -> {
                List<Map<String, Object>> list1 = new ArrayList();
                Map<String, Object> map = new HashMap<>();
                map.put("name", x.get("status"));
                if ("正常".equals(String.valueOf(x.get("status")))) {
                    map.put("level", "success");
                } else {
                    map.put("level", "warning");
                }
                list1.add(map);
                x.put("status", list1);
            });
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> getCAFSWaterTankInfo() {
        List<Map<String, Object>> list = emergencyMapper.getCAFSWaterTankInfo();
        if (0 < list.size()) {
            for (Map<String, Object> m : list) {
                Map<String, Object> transResult = UnitTransformUtil.transformValues(String.valueOf(m.get("value")),
                        String.valueOf(m.get("unit")), String.valueOf(m.get("minLevel")), String.valueOf(m.get("maxLevel")));
                m.put("value", transResult.get("nowValue"));
                if (StringUtil.isNotEmpty(IndexStatusEnum.getEnumByKey(String.valueOf(transResult.get("status"))))) {
                    m.put("statusDesc", IndexStatusEnum.getEnumByKey(String.valueOf(transResult.get("status"))).getDescribe1());
                } else {
                    m.put("statusDesc", "--");
                }
                m.put("sxyl", transResult.get("abs"));
            }
        }
        return Optional.ofNullable(list).orElse(Lists.newArrayList());
    }

    @Override
    public Map<String, Object> emergencyMaterials() {
        return emergencyMapper.selectEmergencyMaterials();
    }

    @Override
    public Page<Map<String, Object>> emergencyMaterialsDetails(Page<Map<String, Object>> page, String bizOrgCode) {
        return emergencyMapper.selectEmergencyMaterialsDetails(page , bizOrgCode);
    }

    @Override
    public Page<Map<String, Object>> selectFireMonitor(Page<Map<String, Object>> page, String bizOrgCode, String code) {
        return emergencyMapper.selectFireMonitor(page, bizOrgCode, code);
    }

    @Override
    public Page<Map<String, Object>> selectFoamTank(Page<Map<String, Object>> page) {
        Page<Map<String, Object>> page1 = emergencyMapper.selectFoamTank(page);
        List<Map<String, Object>> res = page1.getRecords();
        if (0 < res.size()) {
            for (Map<String, Object> m : res) {
                Map<String, Object> transResult = UnitTransformUtil.transformValues(String.valueOf(m.get("nowLevel")),
                        String.valueOf(m.get("unit")), String.valueOf(m.get("minLevel")), String.valueOf(m.get("maxLevel")));
                m.put("nowLevel", transResult.get("nowValue"));
                if (StringUtil.isNotEmpty(IndexStatusEnum.getEnumByKey(String.valueOf(transResult.get("status"))))) {
                    m.put("status", IndexStatusEnum.getEnumByKey(String.valueOf(transResult.get("status"))).getDescribe1());
                } else {
                    m.put("status", "--");
                }
                m.put("abs", transResult.get("abs"));
            }
        }
        return page1;
    }

    @Override
    public Page<Map<String, Object>> selectOilDrainage(Page<Map<String, Object>> page, String bizOrgCode, String code) {
        return emergencyMapper.selectOilDrainage(page, bizOrgCode, code);
    }

    @Override
    public Page<Map<String, Object>> selectPressureFlow(Page<Map<String, Object>> page, String bizOrgCode) {
        return emergencyMapper.selectPressureFlow(page, bizOrgCode);
    }

    @Override
    public List<Map<String, Object>> selectAlarmAnalysis(String startDate, String endDate, String dataType, String date, String systemType) {
        List<String> strings = emergencyMapper.selectSystemCodes(systemType);
        if (!CollectionUtils.isEmpty(strings)) {
            return emergencyMapper.selectAlarmAnalysis(startDate, endDate, dataType, date, strings);
        }
        return null;

    }

    @Override
    public List<Map<String, Object>> selectAlarmAnalysisCount(String systemType, String startDate, String endDate) {
        List<String> strings = emergencyMapper.selectSystemCodes(systemType);
        if (!CollectionUtils.isEmpty(strings)) {
            return emergencyMapper.selectAlarmAnalysisCount( startDate, endDate,strings);
        }
        return null;

    }

    @Override
    public Map<String, Object> systemAndCar() {
        return emergencyMapper.getSystemAndCarCount();
    }

    @Override
    public List<Map<String, Object>> selectFireCannonAlarmAnalysisPie(String startDate, String endDate, String systemType) {
        List<String> strings = emergencyMapper.selectSystemCodes(systemType);
        if (!CollectionUtils.isEmpty(strings)) {
            return emergencyMapper.selectFireCannonAlarmAnalysisPie(startDate, endDate, strings);
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> waterSystemAlarmAnalysisPie(String startDate, String endDate, String systemType) {
        List<String> strings = emergencyMapper.selectSystemCodes(systemType);
        if (!CollectionUtils.isEmpty(strings)) {
            return emergencyMapper.waterSystemAlarmAnalysisPie(startDate, endDate, strings);
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> waterSystemAlarmAnalysis(String startDate, String endDate, String dataType, String date, String systemType) {
        List<String> strings = emergencyMapper.selectSystemCodes(systemType);
        if (!CollectionUtils.isEmpty(strings)) {
            return emergencyMapper.waterSystemAlarmAnalysis(startDate, endDate, dataType, date, strings);
        }
        return null;

    }

    @Override
    public List<Map<String, Object>> fireCannonSystemAlarmAnalysis(String startDate, String endDate, String dataType, String date, String systemType) {
        List<String> strings = emergencyMapper.selectSystemCodes(systemType);
        if (!CollectionUtils.isEmpty(strings)) {
            return emergencyMapper.fireCannonSystemAlarmAnalysis(startDate, endDate, dataType, date, strings);
        }
        return null;

    }


    @Override
    public List<Map<String, Object>> getEquipExpiryStatistics(Integer expiryDayNum) {
        List<Map<String, Object>> equipExpiryStatistics = emergencyMapper.getEquipExpiryStatistics(expiryDayNum);
        equipExpiryStatistics.forEach(item -> {
            item.put("value", Integer.parseInt(item.get("value").toString()));
        });
        return equipExpiryStatistics;
    }

    @Override
    public List<Map<String, String>> getEquipExpiryList(Integer expiryDayNum) {

        return emergencyMapper.getEquipExpiryList(expiryDayNum);
    }

    @Override
    public Map<String, Integer> getStockEquipStatistics() {
        return emergencyMapper.getStockEquipStatistics();
    }

    @Override
    public Map<String, Object> getPressurePumpStatusChart(String equipmentCode, String startTime, String endTime, String bizOrgCode, String appKey, String product, String token) {
        Map<String, Object> map = new HashMap<>();
        List<String> timeList = DateUtils.getTimeStrListByStartAndEnd(startTime, endTime, "MM-dd HH:mm");
        //  获取稳压泵
        List<Map<String, Object>> list = equipmentSpecificSerivce.getListByEquipmentCode(equipmentCode, bizOrgCode);
        if (!CollectionUtils.isEmpty(list)) {
            List<Map<String, Object>> yData = new ArrayList<>();
            list.forEach(x -> {
                Map<String, Object> yMap = new HashMap<>();
                List<Integer> yList = new ArrayList<>();
                String name = x.get("name").toString();
                yMap.put("name", name);
                Object iotCode = x.get("iotCode");
                String prefix = null;
                String suffix = null;
                if (x.get("iotCode") != null && iotCode.toString().length() > 8) {
                    prefix = iotCode.toString().substring(0, 8);
                    suffix = iotCode.toString().substring(8);
                    ResponseModel responseModel = null;
                    try {
                        responseModel = iotFeign.selectListNew(appKey, product, token, prefix, startTime, endTime, null, pressurePumpStart);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (200 == responseModel.getStatus()) {
                        String json = JSON.toJSONString(responseModel.getResult());
                        List<Map<String, String>> dataList = (List<Map<String, String>>) JSONArray.parse(json);
                        if (!CollectionUtils.isEmpty(dataList)) {
                            Collections.reverse(dataList);
                            Map<String, List<Map<String, String>>> dataMap = dataList.stream().filter(y -> y.containsKey("createdTime")).collect(Collectors.groupingBy(e -> e.get("createdTime").substring(5, 16).replace("T", " ")));
                            timeList.forEach(t -> {
                                List<Map<String, String>> data = dataMap.get(t);
                                if (!CollectionUtils.isEmpty(data)) {
                                    List<Map<String, String>> yDataList = dataMap.get(t).stream().filter(o -> "true".equals(o.get(pressurePumpStart).toString())).collect(Collectors.toList());
                                    yList.add(CollectionUtils.isEmpty(yDataList) ? 0 : 1);
                                } else {
                                    yList.add(0);
                                }
                            });
                        } else {
                            timeList.forEach(t -> {
                                yList.add(0);
                            });
                        }
                    }
                    yMap.put("data", yList);
                    yData.add(yMap);
                }
            });
            map.put("xData", timeList);
            map.put("yData", yData);
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> getPressurePumpDiagnosticAnalysis(String equipmentCode, String nameKeys, String fieldKey, String bizOrgCode, String appKey, String product, String token) {
        List<Map<String, Object>> list = new ArrayList<>();
        //  1. 判断稳压泵整体是否故障
        List<EquipmentSpecificAlarmLog> alarmLogList = equipmentSpecificAlarmLogService.getAlarmLogInfoList(equipmentCode, nameKeys, "true", "false", bizOrgCode);
        HashMap<String, Object> isFaultMap = new HashMap<>();
        isFaultMap.put("key", 1);
        isFaultMap.put("code", 1);
        isFaultMap.put("name", "稳压泵是否有故障");
        isFaultMap.put("value", CollectionUtils.isEmpty(alarmLogList) ? "无" : "有");
        isFaultMap.put("unit", "");
        list.add(isFaultMap);
        //  2. 最近一次启停间隔
        HashMap<String, Object> intervalMap = new HashMap<>();
        intervalMap.put("key", 2);
        intervalMap.put("code", 2);
        intervalMap.put("name", "最近一次启动间隔");
        intervalMap.put("unit", "分钟");
        //  3. 最近一次启动时长
        HashMap<String, Object> durationlMap = new HashMap<>();
        durationlMap.put("key", 3);
        durationlMap.put("code", 3);
        durationlMap.put("name", "最近一次启动时长");
        durationlMap.put("unit", "分钟");
        //  4. 半小时启动
        //  5. 2小时启动
        String nowStrLong = DateUtils.getNowStrLong();
        Date halfHour = DateUtils.dateAddMinutes(null, -30);
        Date twoHour = DateUtils.dateAddHours(null, -2);
        String half = DateUtils.convertDateToString(halfHour, DateUtils.DATE_TIME_PATTERN);
        String two = DateUtils.convertDateToString(twoHour, DateUtils.DATE_TIME_PATTERN);

        HashMap<String, Object> pipeMap = new HashMap<>();
        pipeMap.put("key", 6);
        pipeMap.put("code", 6);
        pipeMap.put("name", "管网压力");
        pipeMap.put("value", "正常");
        pipeMap.put("unit", "");

        //  获取稳压泵
        List<Map<String, Object>> specificList = equipmentSpecificSerivce.getListByEquipmentCode(equipmentCode, bizOrgCode);
        AtomicInteger halfNum = new AtomicInteger();
        AtomicInteger twoNum = new AtomicInteger();
        if (!CollectionUtils.isEmpty(specificList)) {
            String prefix = null;
            for (Map<String, Object> x : specificList) {
                Object iotCode = x.get("iotCode");
                String suffix = null;
                if (x.get("iotCode") != null && iotCode.toString().length() > 8) {
                    prefix = iotCode.toString().substring(0, 8);
                    suffix = iotCode.toString().substring(8);
                    try {
                        ResponseModel halfResponseModel = iotFeign.selectList(appKey, product, token, half, nowStrLong, prefix, suffix, pressurePumpStart);
                        ResponseModel twoResponseModel = iotFeign.selectList(appKey, product, token, two, nowStrLong, prefix, suffix, pressurePumpStart);
                        if (200 == halfResponseModel.getStatus()) {
                            String json = JSON.toJSONString(halfResponseModel.getResult());
                            List<Map<String, String>> halfDataList = (List<Map<String, String>>) JSONArray.parse(json);
                            List<Map<String, String>> halfCollect = halfDataList.stream().filter(o -> "true".equals(o.get(pressurePumpStart).toString())).collect(Collectors.toList());
                            halfNum.addAndGet(halfCollect.size());
                        }
                        if (200 == twoResponseModel.getStatus()) {
                            String json = JSON.toJSONString(twoResponseModel.getResult());
                            List<Map<String, String>> twoDataList = (List<Map<String, String>>) JSONArray.parse(json);
                            List<Map<String, String>> twoCollect = twoDataList.stream().filter(o -> "true".equals(o.get(pressurePumpStart).toString())).collect(Collectors.toList());
                            twoNum.addAndGet(twoCollect.size());
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ResponseModel intervalResponseModel = iotFeign.selectOne(appKey, product, token, "1", prefix, null, null, pressurePumpStart);
            String intervalTime = nowStrLong;
            String durationTime = nowStrLong;
            if (200 == intervalResponseModel.getStatus()) {
                String json = JSON.toJSONString(intervalResponseModel.getResult());
                List<Map<String, String>> intervalDataList = (List<Map<String, String>>) JSONArray.parse(json);
                if (!CollectionUtils.isEmpty(intervalDataList)) {
                    String value = intervalDataList.get(0).get(pressurePumpStart);
                    if ("true".equals(value)) {
                        ResponseModel stopResponseModel = iotFeign.selectOne(appKey, product, token, "1", prefix, null, "false", pressurePumpStart);
                        if (200 == stopResponseModel.getStatus()) {
                            String stopJson = JSON.toJSONString(stopResponseModel.getResult());
                            List<Map<String, String>> stopDataList = (List<Map<String, String>>) JSONArray.parse(stopJson);
                            List<Map<String, String>> collect = stopDataList.stream().filter(o -> o.containsKey("createdTime")).collect(Collectors.toList());
                            if (!CollectionUtils.isEmpty(collect)) {
                                intervalTime = collect.get(0).get("createdTime").substring(0, 19).replace("T", " ");
                                //  停泵前的前5分钟，判断管网压力状态
                                try {
                                    String stop5BeforeTime = DateUtils.convertDateToString(DateUtils.dateAddMinutes(DateUtils.convertStrToDate(intervalTime, "yyyy-MM-dd HH:mm:ss"), -5), "yyyy-MM-dd HH:mm:ss");
                                    ResponseModel pipeResponseModel = iotFeign.selectListNew(appKey, product, token, prefix, stop5BeforeTime, intervalTime, null, "FHS_PipePressureDetector_PipePressure");
                                    if (200 == pipeResponseModel.getStatus()) {
                                        String pipeJson = JSON.toJSONString(pipeResponseModel.getResult());
                                        List<Map<String, String>> pipeDataList = (List<Map<String, String>>) JSONArray.parse(pipeJson);
                                        List<Map<String, String>> collect1 = pipeDataList.stream().filter(o -> o.containsKey("FHS_PipePressureDetector_PipePressure")).collect(Collectors.toList());
                                        if (!CollectionUtils.isEmpty(collect1)) {
                                            int val1 = Integer.parseInt(collect1.get(0).get("FHS_PipePressureDetector_PipePressure"));
                                            int val2 = Integer.parseInt(collect1.get(pipeDataList.size() - 1).get("FHS_PipePressureDetector_PipePressure"));
                                            pipeMap.put("value", (val1 - val2) > 0.05 ? "异常" : "正常");
                                        }
                                    }
                                } catch (ParseException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }
                        ResponseModel startResponseModel = iotFeign.selectOne(appKey, product, token, "2", prefix, null, "true", pressurePumpStart);
                        if (200 == startResponseModel.getStatus()) {
                            String startJson = JSON.toJSONString(startResponseModel.getResult());
                            List<Map<String, String>> startDataList = (List<Map<String, String>>) JSONArray.parse(startJson);
                            List<Map<String, String>> collect = startDataList.stream().filter(o -> o.containsKey("createdTime")).collect(Collectors.toList());
                            if (!CollectionUtils.isEmpty(collect) && collect.size() > 1) {
                                durationTime = collect.get(1).get("createdTime").substring(0, 19).replace("T", " ");
                            }
                        }
                    } else {
                        ResponseModel startResponseModel = iotFeign.selectOne(appKey, product, token, "1", prefix, null, "true", pressurePumpStart);
                        if (200 == startResponseModel.getStatus()) {
                            String startJson = JSON.toJSONString(startResponseModel.getResult());
                            List<Map<String, String>> startDataList = (List<Map<String, String>>) JSONArray.parse(startJson);
                            List<Map<String, String>> collect = startDataList.stream().filter(o -> o.containsKey("createdTime")).collect(Collectors.toList());
                            if (!CollectionUtils.isEmpty(collect)) {
                                intervalTime = collect.get(0).get("createdTime").substring(0, 19).replace("T", " ");
                                durationTime = intervalTime;
                            }
                        }
                    }
                }
            }
            intervalMap.put("value", DateUtils.getDurationMinutes(intervalTime, nowStrLong, "yyyy-MM-dd HH:mm:ss"));
            durationlMap.put("value", DateUtils.getDurationMinutes(durationTime, nowStrLong, "yyyy-MM-dd HH:mm:ss"));
        } else {
            intervalMap.put("value", 0);
            durationlMap.put("value", 0);
            pipeMap.put("value", "正常");
        }
        list.add(intervalMap);
        list.add(durationlMap);
        HashMap<String, Object> halfMap = new HashMap<>();
        halfMap.put("key", 4);
        halfMap.put("code", 4);
        halfMap.put("name", "半小时启动");
        halfMap.put("value", halfNum);
        halfMap.put("unit", "次");
        list.add(halfMap);

        HashMap<String, Object> twoMap = new HashMap<>();
        twoMap.put("key", 5);
        twoMap.put("code", 5);
        twoMap.put("name", "2小时启动");
        twoMap.put("value", twoNum);
        twoMap.put("unit", "次");
        list.add(twoMap);
        //  6. 管网压力
        list.add(pipeMap);
        return list;
    }

}
