package com.yeejoin.amos.patrol.business.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.ws.rs.POST;
import java.util.List;
import java.util.Map;

// 机场服务
@FeignClient(name = "${jcs.fegin.name}", path = "jcs", configuration = FeignConfiguration.class)
public interface JcsFeignClient {

    /**
     * 根据机场人员ids获取amos平台人员列表
     *
     * @param orgUserId 机场单位人员ids
     * @return AgencyUserModel 平台人员信息列表
     **/
    @RequestMapping(value = "/org-usr/amos/list/{orgUserId}", method = RequestMethod.GET)
    ResponseModel<List<AgencyUserModel>> getAmosUserByUserId(@PathVariable String orgUserId);

    /**
     * 根据机场单位id获取单位下人员列表
     *
     * @param companyId 机场单位id
     * @return Object 单位下人员列表
     **/
    @RequestMapping(value = "/org-usr/{companyId}/person/list", method = RequestMethod.GET)
    ResponseModel<List<Map<String, Object>>> getPersonListByCompanyId(@PathVariable String companyId);


    /**
     * 查询本单位下及下级部门下的人员
     */
    @GetMapping(value = "/org-person/list")
    ResponseModel<Page<Map<String, Object>>> listPage(@RequestParam Map<String, Object> requestBody);

    /**
     * 根据bizOrgCode查询公司部门
     */
    @GetMapping(value = "/org-usr/find/getByOrgCode")
    ResponseModel<Object> getByOrgCode(@RequestParam String bizOrgCode);

    @GetMapping(value = "/org-usr/company/bizOrgCode/list")
    ResponseModel<Object> getCompanyByBizOrgCodeList(@RequestParam String bizOrgCode);

    /**
     * 查询用户单位信息
     * @param userId 用户id
     * @return ResponseModel<ReginParams.PersonIdentity>
     */
    @GetMapping(value = "/org-person/getUser/{id}")
    FeignClientResult selectById(@PathVariable String id);

    @PostMapping (value = "/org-person/getUserList")
    FeignClientResult<List<Map<String, Object>>> selectByIdList(@RequestBody List<String> id);

    @GetMapping(value = "/org-usr/getCompanyInfo")
     ResponseModel<Object> getCompanyInfo(@RequestParam(value = "companyId") String companyId);


    @PostMapping (value = "/org-usr/selectByIdDeptList")
    FeignClientResult<List<Map<String, Object>>> selectByIdDeptList(@RequestBody String ids);
    @PostMapping (value = "/org-usr/selectByAmosOrgIdDeptList")
    FeignClientResult<List<Map<String, Object>>> selectByAmosOrgIdDeptList(@RequestBody String ids);


    @PostMapping (value = "/org-usr/getDetByCompanyId")
    FeignClientResult<List<Map<String, Object>>> getDetByCompanyId();

    @GetMapping(value = "/org-person/listCompany/{bizOrgCode}")
     Object listCompany(@PathVariable String bizOrgCode) ;
}

