package com.yeejoin.amos.api.householdapi.Utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.api.householdapi.constant.GoLangConstant;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.GolangStationList;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.GolangStationMapper;
import com.yeejoin.amos.api.householdapi.face.service.impl.HouseholdPvProducerInfoServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.cache.Redis;

import java.util.*;
@Component

public class GolangRequestUtil {
    private final static String API_REDIS_PREFIX = "HOUSEHOLD_API_CACHE_";

    @Autowired
    private HouseholdPvProducerInfoServiceImpl householdPvProducerInfoServiceImpl;

    @Autowired
    private GolangStationMapper golangStationMapper;
    /**
     * @return HashMap<String, Object>   发送请求前的准备 准备header信息
     * @deprecated 根据厂商编码获取厂商的hearer
     */
    public HashMap<String, Object> getHeaderOfGolang() {
        HashMap<String, Object> hashMap = new HashMap<>();
        HashMap<String, String> hashMaphead = new HashMap<>();
        String url = GoLangConstant.baseurl + GoLangConstant.tokenurl;
        hashMap.put("apiurl", GoLangConstant.baseurl);
        hashMaphead.put("Content-type", "application/json;charset=UTF-8");
        hashMaphead.put("Authorization", "API " + GoLangConstant.prodcerappid);
        hashMaphead.put("Content-MD5", null);
        hashMaphead.put("Date", GoLangHeaderUtils.getGMTTime());
        hashMap.put("header", hashMaphead);
        hashMap.put("appsecret", GoLangConstant.prodcerappsecret);
        return hashMap;
    }

    /**
     * @return String 请求返回的response字符串
     */
    public <T> List<T> getResPonse(String apiurl,String requestMethod,String requestParmInfo,String ResultResolveRule,Class <T> tClass) {
        String respone = "";
        String params = "";
        JSONArray jsonArray = null;
        HashMap<String, Object> producerInfo = getHeaderOfGolang();
        String baseurl = (String) producerInfo.get("apiurl");
        HashMap<String, String> headMap = (HashMap<String, String>) producerInfo.get("header");
        String orginalAuthorization = headMap.get("Authorization") + ":";
        String url = baseurl + apiurl;
        String appsecret = (String) producerInfo.get("appsecret");
        JLYHeaderMapHandler(params, headMap, orginalAuthorization, appsecret,apiurl);
        respone = sendRequest(requestMethod, url,requestParmInfo, headMap);
        jsonArray = handlerResponseByResultResolverule(ResultResolveRule, respone);
        List<T> result = JSONArray.parseArray(jsonArray.toJSONString(),tClass);
        return result;
    }

    /**
     * @param resultResovle 请求返回的解析规则 来源与数据库
     * @param response      请求返回的字符串
     * @return 解析后的数据
     */
    public JSONArray handlerResponseByResultResolverule(String resultResovle, String response) {
        JSONObject jsonObject = JSONObject.parseObject(response);
        JSONArray jsonArray = new JSONArray();
        if (ObjectUtil.isNotEmpty(resultResovle)) {
            String[] rules = resultResovle.split(",");
            if (rules.length > 0) {
                for (int i = 0; i < rules.length; i++) {
                    try {
                        jsonObject = (JSONObject) jsonObject.get(rules[i]);
                        if (jsonObject == null) {
                            jsonArray = (JSONArray) jsonObject.get(rules[i]);
                        }
                    } catch (Exception exception) {
                        jsonArray = (JSONArray) jsonObject.get(rules[i]);
                    }
                }
            }
            if (jsonArray.size() == 0) {
                jsonArray.add(jsonObject);
            }
        }
        return jsonArray;
    }

    /**
     * @param seq         apiID
     * @param cacheField  要缓存的字段
     * @param jsonArray   处理后的数据请求
     * @param measurement 要在influxdb中存储的数
     * @describe 该方法用于缓存需要缓存的字段 且将需要入库的数据进行入库
     */
    public void handleResponseAndCacheData(String seq, String cacheField, JSONArray jsonArray, String measurement, String produceID) {
        String apiID = API_REDIS_PREFIX + seq;
        List list = new ArrayList();
        List saveList = new ArrayList();
        if (jsonArray.size() > 0) {
            for (Object o : jsonArray) {
                List<Map<String, Object>> lines = new ArrayList<>();
                Map<String, Object> maps1 = (Map<String, Object>) o;
                LinkedHashMap<String, Object> sortHashMap = new LinkedHashMap<>();
                sortHashMap.put("station_list", "station_list." + measurement);
                sortHashMap.put("timestamp", System.currentTimeMillis());
                sortHashMap.put("value", 10.1);
                Set<String> keys = maps1.keySet();
                keys.forEach((key) -> {
                    maps1.put(key, ObjectUtils.isEmpty(maps1.get(key)) ? "null" : maps1.get(key).toString());
                });
                if (!ObjectUtils.isEmpty("cacheField")) {
                    list.add(maps1.get(cacheField));
                }
                sortHashMap.put("tags", maps1);
                lines.add(sortHashMap);
//                Map<String, String> maps2 = new HashMap<>();
//                maps2.put("key", UUID.randomUUID().toString());
                if (!ObjectUtils.isEmpty(measurement)) {
//                    influxDbConnection.insert(measurement, maps2, maps1);
//                    log.error(JSONObject.toJSONString(lines));
//                    tdEngineUtils.writeDataIntoTdEngine(JSONObject.toJSONString(lines));
                }
            }
        }
//        tdEngineUtils.writeDataIntoTdEngine(lines.stream().map(s -> String.valueOf(s)).toArray(String[]::new));
        if (!ObjectUtils.isEmpty(cacheField)) {
            saveList = Redis.getRedisTemplate().opsForList().range(apiID, 0, -1);
            if (saveList.size() == 0) {
                Redis.getRedisTemplate().opsForList().leftPushAll(apiID, list);
            }
            saveList = Redis.getRedisTemplate().opsForList().range(apiID, 0, -1);
            if (saveList.size() != list.size()) {
                Redis.getRedisTemplate().delete(apiID);
                Redis.getRedisTemplate().opsForList().leftPushAll(apiID, list);
            }
        }
    }

    public String sendRequest(String requestMethod, String url, String params, HashMap<String, String> headMap) {
        String respone = "";
        if (requestMethod.equals("POST")) {
            respone = HttpUtil.createPost(url).headerMap(headMap, false).
                    body(params).execute().body();
        }
        if (requestMethod.equals("GET")) {
            respone = HttpUtil.createGet(url).headerMap(headMap, true).
                    body(params).execute().body();
        }
        return respone;
    }

    /***
     *
     * @param params 参数字符窜
     * @param headMap header头
     * @param orginalAuthorization 原始的orginalAuthorization
     * @param appsecret  appsecret
     * @desc 锦浪云请求参数及head头处理
     */
    public void JLYHeaderMapHandler(String params, HashMap<String, String> headMap, String orginalAuthorization, String appsecret, String apiurl) {
            String contentMD5 = GoLangHeaderUtils.getDigest(params);
            headMap.put("Date", GoLangHeaderUtils.getGMTTime());
            String param = "POST" + "\n" + contentMD5 + "\n" + "application/json" + "\n" + headMap.get("Date") + "\n" + apiurl;
            String sign = "";
            try {
                sign = GoLangHeaderUtils.HmacSHA1Encrypt(param, appsecret);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
            headMap.put("Content-MD5", contentMD5);
            headMap.put("Authorization", orginalAuthorization + sign);
    }

    public Integer getPagesize(String pageSizeResovle, String response) {
        Integer pageSize = 0;
        String[] rules = pageSizeResovle.split(",");
        JSONObject jsonObject = JSONObject.parseObject(response);
        if (rules.length > 0) {
            for (int i = 0; i < rules.length - 1; i++) {
                jsonObject = (JSONObject) jsonObject.get(rules[i]);
            }
        }
        pageSize = (Integer) jsonObject.get(rules[rules.length - 1]);
        return pageSize;
    }
}
