package com.yeejoin.amos.api.householdapi.face.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.api.householdapi.Utils.GolangRequestUtil;
import com.yeejoin.amos.api.householdapi.constant.GoLangConstant;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpStation;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.*;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.*;
import com.yeejoin.amos.api.householdapi.face.service.GoLangDataAcquisitionService;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpStationMapper;
import com.yeejoin.amos.openapi.enums.PVProducerInfoEnum;
import fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Service

public class GoLangDataAcquisitionServiceImpl implements GoLangDataAcquisitionService {
    @Autowired
    private GolangRequestUtil golangRequestUtil;
    @Autowired
    private GolangStationMapper golangStationMapper;
    @Autowired
    private JpStationMapper jpStationMapper;
    @Autowired
    private GolangStationDetailMapper golangStationDetailMapper;
    @Autowired
    private GolangCollectorListMapper golangCollectorListMapper;
    @Autowired
    private GolangInverterListMapper golangInverterListMapper;
    //户用光伏 场站历史
    @Autowired
    private HYGFJPStationPowerHistoryMapper hygfjpStationPowerHistoryMapper;
    //
    @Autowired
    private HYGFJPInverterHistoryMapper hygfjpInverterHistoryMapper;
    @Autowired
    private HYGFJPCollectorHistoryMapper hygfjpCollectorHistoryMapper;
    @Autowired
    private HYGFJPInverterWarnMapper hygfjpInverterWarnMapper;
    @Autowired
    private HYGFJPInverterElecHistoryMapper hygfjpInverterElecHistoryMapper;


    @Override

    public void stationList() {
        HashMap<String, Object> requestInfo = new HashMap<>();
        requestInfo.put("pageNo", 1);
        requestInfo.put("pageSize", 100);
        String requestParaminfo = JSON.toJSONString(requestInfo);
        List<GolangStationList> result = golangRequestUtil.getResPonse(GoLangConstant.stationListUrl,
                GoLangConstant.requestPost,
                requestParaminfo,
                GoLangConstant.resovleRule_data_page_records,
                GolangStationList.class
        );
        for (int i = 0; i < result.size(); i++) {
            GolangStationList golangStationList = result.get(i);
            golangStationList.setCreatedTime(new Date());
            golangStationMapper.insert(golangStationList);
        }
    }

    @Override
    public void stationDetail() {
        List<String> stationIds = golangStationMapper.getStationIds();
        for (int i = 0; i < stationIds.size(); i++) {
            try {
                TimeUnit.SECONDS.sleep(1);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("id", Long.valueOf(stationIds.get(i)));
            String requestParaminfo = JSON.toJSONString(requestInfo);
            List<GolangStationDetail> result = golangRequestUtil.getResPonse(GoLangConstant.stationDetailUrl,
                    GoLangConstant.requestPost,
                    requestParaminfo,
                    GoLangConstant.resovleRule_data,
                    GolangStationDetail.class
            );
            for (int j = 0; j < result.size(); j++) {
                GolangStationDetail golangStationDetail = result.get(j);
                golangStationDetail.setCreatedTime(new Date());
                JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>().eq("third_code", PVProducerInfoEnum.JLY.getCode()).eq("third_station_id", stationIds.get(i)));
                //给户用光伏存储的数据赋值
                if (ObjectUtils.isEmpty(jpStation)) {
                    jpStation = new JpStation();
                }
                jpStation.setSnCode(golangStationDetail.getNmicode());
                jpStation.setCapacity(Double.valueOf(golangStationDetail.getCapacity()));
                jpStation.setName(golangStationDetail.getStationname());
                jpStation.setPrice(Double.valueOf(golangStationDetail.getPrice()));
                jpStation.setAddress(golangStationDetail.getAddr());
                jpStation.setLongitude(golangStationDetail.getLongitude());
                jpStation.setLatitude(golangStationDetail.getLatitude());
                jpStation.setUserName(golangStationDetail.getUsername());
                jpStation.setUserPhone(String.valueOf(golangStationDetail.getUsermobile()));
                jpStation.setStationContact(String.valueOf(golangStationDetail.getMobile()));
                jpStation.setModuleCount(Math.toIntExact(golangStationDetail.getModule()));
                //并网类型
                jpStation.setOnGridType(GoLangConstant.stationStaus.get(String.valueOf(golangStationDetail.getState())));
                jpStation.setThirdStationId(String.valueOf(golangStationDetail.getId()));
                jpStation.setThirdCode(PVProducerInfoEnum.JLY.getCode());
                jpStation.setRealTimePower(golangStationDetail.getPower());
                jpStation.setState(GoLangConstant.intoNetWorkStatus.get(String.valueOf(golangStationDetail.getStationtypenew())));
                jpStation.setDayGenerate(golangStationDetail.getDayenergy());
                jpStation.setMonthGenerate(golangStationDetail.getMonthenergy());
                jpStation.setYearGenerate(golangStationDetail.getYearenergy());
                jpStation.setDayIncome(golangStationDetail.getDayincome());
                jpStation.setMonthIncome(golangStationDetail.getMonthincome());
                jpStation.setYearIncome(golangStationDetail.getYearincome());
                jpStation.setCumulativeIncome(golangStationDetail.getAllincome());
                jpStation.setArea(golangStationDetail.getRegionstr());

                if (!ObjectUtils.isEmpty(jpStation.getSequenceNbr())) {
                    jpStationMapper.updateById(jpStation);
                } else {
                    jpStationMapper.insert(jpStation);
                }
                HYGFJPStationPowerHistory hygfjpStationPowerHistory = new HYGFJPStationPowerHistory();
                hygfjpStationPowerHistory.setCreatedTime(new Date());
                hygfjpStationPowerHistory.setThirdStationId(jpStation.getThirdStationId());
                hygfjpStationPowerHistory.setPower(jpStation.getRealTimePower());
                hygfjpStationPowerHistory.setThirdCode(jpStation.getThirdCode());
                hygfjpStationPowerHistory.setTime(System.currentTimeMillis());
                golangStationDetailMapper.insert(golangStationDetail);
            }
        }
    }

    @Override
    public void collectorList() {
        List<String> stationIds = golangStationMapper.getStationIds();
        for (int i = 0; i < stationIds.size(); i++) {
            try {
                TimeUnit.SECONDS.sleep(1);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("stationId", Long.valueOf(stationIds.get(i)));
            requestInfo.put("pageNo", 1);
            requestInfo.put("pageSize", 100);
            String requestParaminfo = JSON.toJSONString(requestInfo);
            List<GolangCollectorList> result = golangRequestUtil.getResPonse(GoLangConstant.collectorListUrl,
                    GoLangConstant.requestPost,
                    requestParaminfo,
                    GoLangConstant.resovleRule_data_page_records,
                    GolangCollectorList.class
            );
            for (int j = 0; j < result.size(); j++) {
                GolangCollectorList golangCollectorList = result.get(j);
                golangCollectorList.setCreatedTime(new Date());
                golangCollectorListMapper.insert(golangCollectorList);
            }
        }
    }

    @Override
    public void collectorDetail() {
        List<Long> collectorIds = golangCollectorListMapper.getCollectIds();

    }

    @Override
    public void inverterList() {
        List<String> stationIds = golangStationMapper.getStationIds();
        for (int i = 0; i < stationIds.size(); i++) {
            try {
                TimeUnit.SECONDS.sleep(1);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("stationId", Long.valueOf(stationIds.get(i)));
            requestInfo.put("pageNo", 1);
            requestInfo.put("pageSize", 100);
            String requestParaminfo = JSON.toJSONString(requestInfo);
            List<GolangInverterList> result = golangRequestUtil.getResPonse(GoLangConstant.inverterListUrl,
                    GoLangConstant.requestPost,
                    requestParaminfo,
                    GoLangConstant.resovleRule_data_page_records,
                    GolangInverterList.class
            );
            for (int j = 0; j < result.size(); j++) {
                GolangInverterList golangInverterList = result.get(j);
                golangInverterList.setCreatedTime(new Date());
                golangInverterListMapper.insert(golangInverterList);
            }
        }
    }

    @Override
    public void inverterDetail() {
        List<Long> inverterIds = golangInverterListMapper.getInverterIds();
    }
}
