package com.yeejoin.amos.latentdanger.common.enums;


/**
 * @author DELL
 */

public enum ExecuteTypeEnum {

    /**
     * 未执行
     */
    未执行("未执行", 1, ""),
    通过("通过", 2, "0"),
    驳回("驳回", 3, "1");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    /**
     * 工作流条件（0通过1驳回）
     */
    private String condition;

    ExecuteTypeEnum(String name, Integer code, String condition) {
        this.name = name;
        this.code = code;
        this.condition = condition;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getCondition() {
        return condition;
    }

    public void setCode(String condition) {
        this.condition = condition;
    }

    public static ExecuteTypeEnum getByCode(Integer code) {
        for (ExecuteTypeEnum e : ExecuteTypeEnum.values()) {
            if (code.equals(e.getCode())) {
                return e;
            }
        }
        return null;
    }

    public static String getNameByCode(Integer code) {
        for (ExecuteTypeEnum e : ExecuteTypeEnum.values()) {
            if (code.equals(e.getCode())) {
                return e.getName();
            }
        }
        return null;
    }
}
