package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpCollector;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpInverter;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpPersonStation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 第三方场站
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="JpStationDto", description="第三方场站")
public class JpStationDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "sn编码")
    private String snCode;

    @ApiModelProperty(value = "装机容量")
    private Double capacity;

    @ApiModelProperty(value = "电站名称")
    private String name;

    @ApiModelProperty(value = "电站编码")
    private String code;

    @ApiModelProperty(value = "组织编码")
    private String systemCode;

    @ApiModelProperty(value = "接入平台时间")
    private Date accessTime;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "维度")
    private String latitude;

    @ApiModelProperty(value = "上网电价")
    private Double price;

    @ApiModelProperty(value = "业主姓名")
    private String userName;

    @ApiModelProperty(value = "业主电话")
    private String userPhone;

    @ApiModelProperty(value = "电站联系人")
    private String stationContact;

    @ApiModelProperty(value = "组件数量")
    private Integer moduleCount;

    @ApiModelProperty(value = "并网类型")
    private String onGridType;

    @ApiModelProperty(value = "并网时间")
    private Date onGridTime;

    @ApiModelProperty(value = "第三方电站id")
    private String thirdStationId;

    @ApiModelProperty(value = "电站id")
    private Long stationId;

    @ApiModelProperty(value = "第三方厂商标识")
    private String thirdCode;
    /**
     * 实时功率
     */
    private Double	realTimePower;
    /**
     * 累计发电量
     */
    private Double	accumulatedPower;
    /**
     * 状态
     */
    private String state;
    /**
     * 电站类型
     */
    private String type	;
    /**
     *  组织编码
     */
    private String organizationalCode	;

    //日发电量
    private Double dayGenerate;
    //月发电量
    private Double monthGenerate;
    //年发电量
    private Double yearGenerate;
    //日收益
    private Double  dayIncome;
    //月收益
    private Double monthIncome;
    // 年收益
    private Double yearIncome;
    //地区
    private String area;

    List<JpPersonStation> statioId;

    //累计收益
    private Double cumulativeIncome;


    private Double dayPowerUse;	//	日用电量
    private Double month_power_use;	//	月用电量
    private Double yearPowerUse;	//	年用电量

    private int countBuiltNum;//已建设场站数量
    private int countNBuiltNum;//未建设场站数量


    List<JpInverter> jpInverter;

    List<JpCollector> JpCollector;


}
