package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 户用光伏监盘采集器表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_jp_collector")
public class JpCollector extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * sn编码
     */
	@TableField("sn_code")
    private String snCode;

    /**
     * 状态
     */
	@TableField("state")
    private String state;

    /**
     * 类型
     */
	@TableField("type")
    private String type;

    /**
     * sim卡号
     */
	@TableField("sim_code")
    private String simCode;

    /**
     * 数据来源
     */
	@TableField("data_source")
    private String dataSource;

    /**
     * 更新时间
     */
	@TableField("update_time")
    private Date updateTime;

    /**
     * 采集器版本
     */
	@TableField("version")
    private String version;

    /**
     * 出场日期
     */
	@TableField("discharge_date")
    private Date dischargeDate;

    /**
     * 生产日期
     */
	@TableField("product_date")
    private Date productDate;

    /**
     * 数据上传间隔
     */
	@TableField("data_period")
    private Double dataPeriod;

    /**
     * 本次上电工作时间
     */
	@TableField("this_work_time")
    private Date thisWorkTime;

    /**
     * 累计工作时间
     */
	@TableField("total_work_time")
    private Date totalWorkTime;

    /**
     * 第三方电站id
     */
	@TableField("third_station_id")
    private String thirdStationId;

    /**
     * 第三方厂商标识
     */
	@TableField("third_code")
    private String thirdCode;

}
