package com.yeejoin.amos.boot.module.hygf.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.JpInvertorElecHistoryYearServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInvertorElecHistoryYearDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 户用光伏监盘逆变器电能历史表
 *
 * @author system_generator
 * @date 2023-09-20
 */
@RestController
@Api(tags = "户用光伏监盘逆变器电能历史表Api")
@RequestMapping(value = "/jp-invertor-elec-history-year")
public class JpInvertorElecHistoryYearController extends BaseController {

    @Autowired
    JpInvertorElecHistoryYearServiceImpl jpInvertorElecHistoryYearServiceImpl;

    /**
     * 新增户用光伏监盘逆变器电能历史表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增户用光伏监盘逆变器电能历史表", notes = "新增户用光伏监盘逆变器电能历史表")
	public ResponseModel<JpInvertorElecHistoryYearDto> save(@RequestBody JpInvertorElecHistoryYearDto model) {
	    model = jpInvertorElecHistoryYearServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新户用光伏监盘逆变器电能历史表", notes = "根据sequenceNbr更新户用光伏监盘逆变器电能历史表")
	public ResponseModel<JpInvertorElecHistoryYearDto> updateBySequenceNbrJpInvertorElecHistoryYear(@RequestBody JpInvertorElecHistoryYearDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jpInvertorElecHistoryYearServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除户用光伏监盘逆变器电能历史表", notes = "根据sequenceNbr删除户用光伏监盘逆变器电能历史表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jpInvertorElecHistoryYearServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个户用光伏监盘逆变器电能历史表",  notes = "根据sequenceNbr查询单个户用光伏监盘逆变器电能历史表")
	public ResponseModel<JpInvertorElecHistoryYearDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jpInvertorElecHistoryYearServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "户用光伏监盘逆变器电能历史表分页查询",  notes = "户用光伏监盘逆变器电能历史表分页查询")
	public ResponseModel<Page<JpInvertorElecHistoryYearDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<JpInvertorElecHistoryYearDto> page = new Page<JpInvertorElecHistoryYearDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jpInvertorElecHistoryYearServiceImpl.queryForJpInvertorElecHistoryYearPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "户用光伏监盘逆变器电能历史表列表全部数据查询",   notes = "户用光伏监盘逆变器电能历史表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JpInvertorElecHistoryYearDto>> selectForList() {
	    return ResponseHelper.buildResponse(jpInvertorElecHistoryYearServiceImpl.queryForJpInvertorElecHistoryYearList());
	}
}
