package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import java.util.List;

import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInverterDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpInverter;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpInverterMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IJpInverterService;

/**
 * 户用光伏监盘逆变器表服务实现类
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Service
public class JpInverterServiceImpl extends BaseService<JpInverterDto, JpInverter, JpInverterMapper>
		implements IJpInverterService {
	/**
	 * 分页查询
	 */
	public Page<JpInverterDto> queryForJpInverterPage(Page<JpInverterDto> page, JpInverterDto jpInverterDto) {
		Page<JpInverter> entiryPage = new Page<>(page.getCurrent(), page.getSize());
		LambdaQueryWrapper<JpInverter> wrapper = new LambdaQueryWrapper<>();
		if (jpInverterDto.getState() != null) {
			wrapper.eq(JpInverter::getState, jpInverterDto.getState());
		}
		entiryPage = (Page<JpInverter>) this.page(entiryPage, wrapper);
		if (!ValidationUtil.isEmpty(entiryPage.getRecords())) {
			page.setTotal(entiryPage.getTotal());
			page.setPages(entiryPage.getPages());
			page.setCurrent(entiryPage.getCurrent());
			page.setSize(entiryPage.getSize());

			if (!ValidationUtil.isEmpty(entiryPage.getRecords()))
				page.setRecords(Bean.toModels(entiryPage.getRecords(), this.getModelClass()));
		}
		return page;
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpInverterDto> queryForJpInverterList() {
		return this.queryForList("", false);
	}
}