package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.module.hygf.api.dto.ReviewDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpStation;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpStationMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IJpStationService;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpStationDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

/**
 * 第三方场站服务实现类
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Service
public class JpStationServiceImpl extends BaseService<JpStationDto,JpStation,JpStationMapper> implements IJpStationService {

    @Autowired
    JpStationMapper jpStationMapper;

    /**
     * 分页查询
     */
    public Page<JpStationDto> queryForJpStationPage(int pageNum, int pageSize, JpStationDto reviewDto)   {
        PageHelper.startPage(pageNum, pageSize);
        List<JpStationDto> list = jpStationMapper.queryForDealerReviewPage(reviewDto);
        PageInfo<JpStationDto> page = new PageInfo(list);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<JpStationDto> pagenew = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<JpStationDto>();
        pagenew.setCurrent(pageNum);
        pagenew.setTotal(page.getTotal());
        pagenew.setSize(pageSize);
        pagenew.setRecords(page.getList());
        return pagenew;
    }


}