package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorHistoryAllDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorHistoryMonthDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorHistoryYearDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.TdHygfJpCollectorHistoryDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpCollector;
import com.yeejoin.amos.boot.module.hygf.api.entity.TdHygfJpCollectorHistory;
import com.yeejoin.amos.boot.module.hygf.api.service.ITdHygfJpCollectorHistoryService;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.TdHygfJpCollectorHistoryMapper;
import com.yeejoin.amos.boot.module.hygf.api.util.TimeUtil;

/**
 * 户用光伏监盘采集器历史表服务实现类
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Service
public class TdHygfJpCollectorHistoryServiceImpl
		extends BaseService<TdHygfJpCollectorHistoryDto, TdHygfJpCollectorHistory, TdHygfJpCollectorHistoryMapper>
		implements ITdHygfJpCollectorHistoryService {

	@Autowired
	private JpCollectorServiceImpl jpCollectorServiceImpl;

	/**
	 * 分页查询
	 */
	public Page<TdHygfJpCollectorHistoryDto> queryForTdHygfJpCollectorHistoryPage(
			Page<TdHygfJpCollectorHistoryDto> page) {
		return this.queryForPage(page, null, false);
	}

	/**
	 * 列表查询 示例
	 */
	public List<TdHygfJpCollectorHistoryDto> dayList(long id, Date day) {
		JpCollector collector = jpCollectorServiceImpl.getById(id);

		if (collector != null) {
			return this.baseMapper.dayList(collector.getSnCode(), collector.getThirdStationId(),
					TimeUtil.getStartTimeOfDay(day), TimeUtil.getEndTimeOfDay(day));
		}
		return new ArrayList<>();
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpCollectorHistoryMonthDto> monthList(long id, Date month) {
		JpCollector collector = jpCollectorServiceImpl.getById(id);

		if (collector != null) {
			return this.baseMapper.monthList(collector.getSnCode(), collector.getThirdStationId(),
					month.toString());
		}
		return new ArrayList<>();
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpCollectorHistoryYearDto> yearList(long id, Date year) {
		JpCollector collector = jpCollectorServiceImpl.getById(id);

		if (collector != null) {
			return this.baseMapper.yearList(collector.getSnCode(), collector.getThirdStationId(),
					year.toString());
		}
		return new ArrayList<>();
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpCollectorHistoryAllDto> allList(long id) {
		JpCollector collector = jpCollectorServiceImpl.getById(id);

		if (collector != null) {
			return this.baseMapper.allList(collector.getSnCode(), collector.getThirdStationId());
		}
		return new ArrayList<>();
	}
}