package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInvertorElecHistoryAllDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInvertorElecHistoryMonthDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInvertorElecHistoryYearDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.TdHygfJpInvertorElecHistoryDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpCollector;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpInverter;
import com.yeejoin.amos.boot.module.hygf.api.entity.TdHygfJpInvertorElecHistory;
import com.yeejoin.amos.boot.module.hygf.api.service.ITdHygfJpInvertorElecHistoryService;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.TdHygfJpInvertorElecHistoryMapper;
import com.yeejoin.amos.boot.module.hygf.api.util.TimeUtil;

/**
 * 户用光伏监盘逆变器电能历史表服务实现类
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Service
public class TdHygfJpInvertorElecHistoryServiceImpl extends
		BaseService<TdHygfJpInvertorElecHistoryDto, TdHygfJpInvertorElecHistory, TdHygfJpInvertorElecHistoryMapper>
		implements ITdHygfJpInvertorElecHistoryService {

	@Autowired
	private JpInverterServiceImpl jpInvertorServiceImpl;

	/**
	 * 分页查询
	 */
	public Page<TdHygfJpInvertorElecHistoryDto> queryForTdHygfJpInvertorElecHistoryPage(
			Page<TdHygfJpInvertorElecHistoryDto> page) {
		return this.queryForPage(page, null, false);
	}

	/**
	 * 列表查询 示例
	 */
	public List<TdHygfJpInvertorElecHistoryDto> dayList(long id, Date day) {
		JpInverter invertor = jpInvertorServiceImpl.getById(id);
		if (invertor != null) {
			return this.baseMapper.dayList(invertor.getSnCode(), invertor.getThirdStationId(),
					TimeUtil.getStartTimeOfDay(day), TimeUtil.getEndTimeOfDay(day));
		}
		return new ArrayList<>();
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpInvertorElecHistoryMonthDto> monthList(long id, Date month) {
		JpInverter invertor = jpInvertorServiceImpl.getById(id);

		if (invertor != null) {
			return this.baseMapper.monthList(invertor.getSnCode(), invertor.getThirdStationId(), month.toString());
		}
		return new ArrayList<>();
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpInvertorElecHistoryYearDto> yearList(long id, Date year) {
		JpInverter invertor = jpInvertorServiceImpl.getById(id);

		if (invertor != null) {
			return this.baseMapper.yearList(invertor.getSnCode(), invertor.getThirdStationId(), year.toString());
		}
		return new ArrayList<>();
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpInvertorElecHistoryAllDto> allList(long id) {
		JpInverter invertor = jpInvertorServiceImpl.getById(id);

		if (invertor != null) {
			return this.baseMapper.allList(invertor.getSnCode(), invertor.getThirdStationId());
		}
		return new ArrayList<>();
	}
}