package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanWarningRecord;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanHealthIndexMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanWarningRecordMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@Api(tags = "智能分析 - 大屏API")
@RequestMapping(value = "/bigScreenAnalyse")
public class BigScreenAnalyseController extends BaseController {

    @Autowired
    IdxBizFanHealthIndexMapper idxBizFanHealthIndexMapper;

    @Autowired
    IdxBizFanWarningRecordMapper idxBizFanWarningRecordMapper;

    @Autowired
    StationBasicMapper stationBasicMapper;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "场站设备健康状态指数与趋势 - 仪表盘", notes = "场站设备健康状态指数与趋势 - 仪表盘")
    @GetMapping(value = "/getHealthScoreInfo")
    public ResponseModel<Map<String, BigDecimal>> getHealthScoreInfo(@RequestParam(required = false) String areaCode, @RequestParam(required = false) String stationCode) {
        HashMap<String, BigDecimal> stringBigDecimalHashMap = new HashMap<>();
        stringBigDecimalHashMap.put("value", idxBizFanHealthIndexMapper.getHealthScoreInfo(areaCode, stationCode));
        return ResponseHelper.buildResponse(stringBigDecimalHashMap);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "场站设备健康状态指数与趋势 - 折线图", notes = "场站设备健康状态指数与趋势 - 折线图")
    @GetMapping(value = "/getHealthListInfo")
    public ResponseModel<Map<String, Object>> getHealthListInfo(@RequestParam(required = false) String areaCode, @RequestParam(required = false) String stationCode) {
        HashMap<String, Object> resultMap = new HashMap<>();
        List<Map<String, Object>> healthListInfo = idxBizFanHealthIndexMapper.getHealthListInfo(areaCode, stationCode);
        List<String> time = new ArrayList<>();
        List<String> valueList = new ArrayList<>();
        healthListInfo.forEach(item -> {
            time.add(item.get("date").toString());
            valueList.add(item.get("avgHealthIndex").toString());
        });
        List<Map<String, Object>> arrayList = new ArrayList<>();
        HashMap<String, Object> stringStringHashMap = new HashMap<>();
        stringStringHashMap.put("data", valueList);
        arrayList.add(stringStringHashMap);
        resultMap.put("axisData", time);
        resultMap.put("seriesData", arrayList);
        return ResponseHelper.buildResponse(resultMap);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "全域各片区设备预警情况(条) ", notes = "全域各片区设备预警情况(条) ")
    @GetMapping(value = "/getAllEquipAlarmInfo")
    public ResponseModel<Map<String, Object>> getAllEquipAlarmInfo(@RequestParam(required = false) String tableName) {
        Map<String, Object> resultMap = new HashMap<>();
        List<Map<String, Object>> allEquipAlarmInfo = idxBizFanHealthIndexMapper.getAllEquipAlarmInfo(tableName);
        HashMap<String, Integer> wxMap = new HashMap<>();
        HashMap<String, Integer> zyMap = new HashMap<>();
        HashMap<String, Integer> jgMap = new HashMap<>();
        allEquipAlarmInfo.forEach(item -> {
            if ("危险".equals(item.get("warningName"))) {
                wxMap.put(item.get("area").toString(), Integer.parseInt(item.get("num").toString()));
            } else if ("注意".equals(item.get("warningName"))) {
                zyMap.put(item.get("area").toString(), Integer.parseInt(item.get("num").toString()));
            } else if ("警告".equals(item.get("warningName"))) {
                jgMap.put(item.get("area").toString(), Integer.parseInt(item.get("num").toString()));
            }
        });
        List<Integer> wxList = new ArrayList<>();
        List<Integer> zyList = new ArrayList<>();
        List<Integer> jgList = new ArrayList<>();
        List<String> list = new ArrayList<>();
        if ("idx_biz_fan_warning_record".equals(tableName)) {
            list = Arrays.asList("华中片区", "西北片区", "西南片区", "华南片区", "华东片区", "东北片区", "华北片区");
        } else {
            list = Arrays.asList("华北片区", "东北片区", "华东片区", "华南片区", "西南片区", "西北片区", "华中片区");
        }
        list.forEach(item -> {
            wxList.add(wxMap.getOrDefault(item, 0));
            zyList.add(zyMap.getOrDefault(item, 0));
            jgList.add(jgMap.getOrDefault(item, 0));
        });

        HashMap<String, Object> wxMapResult = new HashMap<>();
        wxMapResult.put("data", wxList);
        wxMapResult.put("name", "危险");
        HashMap<String, Object> zyMapResult = new HashMap<>();
        zyMapResult.put("data", zyList);
        zyMapResult.put("name", "注意");
        HashMap<String, Object> jgMapResult = new HashMap<>();
        jgMapResult.put("data", jgList);
        jgMapResult.put("name", "警告");

        List<Map<String, Object>> hashMaps = Arrays.asList(wxMapResult, zyMapResult, jgMapResult);
        resultMap.put("axisData", list);
        resultMap.put("seriesData", hashMaps);
        return ResponseHelper.buildResponse(resultMap);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "全域各片区设备健康状态指数 ", notes = "全域各片区设备健康状态指数 ")
    @GetMapping(value = "/getHealthInfoByArea")
    public ResponseModel<Map<String, Object>> getHealthInfoByArea() {
        Map<String, Object> resultMap = new HashMap<>();
        List<Map<String, Object>> healthListInfo = idxBizFanHealthIndexMapper.getHealthInfoByArea();
        Map<String, BigDecimal> collect = healthListInfo.stream().collect(Collectors.toMap(t -> t.get("area").toString(), t -> new BigDecimal(t.get("healthIndex").toString())));
        List<String> list = Arrays.asList("华中片区", "西北片区", "西南片区", "华南片区", "华东片区", "东北片区", "华北片区");
        List<Object> seriesData = new ArrayList<>();
        list.forEach(item -> seriesData.add(collect.getOrDefault(item, new BigDecimal("0"))));
        resultMap.put("axisData", list);
        resultMap.put("seriesData", seriesData);
        return ResponseHelper.buildResponse(resultMap);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "全域各场站设备实时预警处置信息", notes = "全域各场站设备实时预警处置信息")
    @GetMapping(value = "/getEquipWarningInfoByPage")
    public ResponseModel<IPage<IdxBizFanWarningRecord>> getEquipWarningInfoByPage(@RequestParam(value = "arae", required = false) String arae,
                                                                                  @RequestParam(value = "station", required = false) String station,
                                                                                  @RequestParam(value = "stationType", required = false) String stationType,
                                                                                  @RequestParam(value = "current", required = false) Integer current,
                                                                                  @RequestParam(value = "size", required = false) Integer size,
                                                                                  @RequestParam(value = "warningName", required = false) String warningName) {
        Integer count = idxBizFanWarningRecordMapper.getEquipWarningInfoByPageCount(arae, station, stationType);
        List<IdxBizFanWarningRecord> idxBizFanWarningRecordIPage = idxBizFanWarningRecordMapper.getEquipWarningInfoByPage(arae, station, stationType, current, size, warningName);
        Page<IdxBizFanWarningRecord> idxBizFanWarningRecordPage = new Page<>(current, size);
        idxBizFanWarningRecordPage.setRecords(idxBizFanWarningRecordIPage);
        idxBizFanWarningRecordPage.setTotal(count);
        return ResponseHelper.buildResponse(idxBizFanWarningRecordPage);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "各场站设备预警情况(条) ", notes = "各场站设备预警情况(条) ")
    @GetMapping(value = "/getAllEquipAlarmInfoByStation")
    public ResponseModel<Map<String, Object>> getAllEquipAlarmInfoByStation() {
        Map<String, Object> resultMap = new HashMap<>();
        List<Map<String, Object>> allEquipAlarmInfo = idxBizFanHealthIndexMapper.getAllEquipAlarmInfoByStation();
        HashMap<String, Integer> wxMap = new HashMap<>();
        HashMap<String, Integer> zyMap = new HashMap<>();
        HashMap<String, Integer> jgMap = new HashMap<>();
        Set<String> list = new HashSet<>();
        allEquipAlarmInfo.forEach(item -> {
            if ("危险".equals(item.get("warningName"))) {
                wxMap.put(item.get("station").toString(), Integer.parseInt(item.get("num").toString()));
            } else if ("注意".equals(item.get("warningName"))) {
                zyMap.put(item.get("station").toString(), Integer.parseInt(item.get("num").toString()));
            } else if ("警告".equals(item.get("warningName"))) {
                jgMap.put(item.get("station").toString(), Integer.parseInt(item.get("num").toString()));
            }
            list.add(item.get("station").toString());
        });
        List<Integer> wxList = new ArrayList<>();
        List<Integer> zyList = new ArrayList<>();
        List<Integer> jgList = new ArrayList<>();
//        List<StationBasic> stationBasics = stationBasicMapper.selectList(null);
//        List<String> list = stationBasics.stream().map(StationBasic::getStationName).collect(Collectors.toList());
        list.forEach(item -> {
            wxList.add(wxMap.getOrDefault(item, 0));
            zyList.add(zyMap.getOrDefault(item, 0));
            jgList.add(jgMap.getOrDefault(item, 0));
        });

        HashMap<String, Object> wxMapResult = new HashMap<>();
        wxMapResult.put("data", wxList);
        wxMapResult.put("name", "危险");
        HashMap<String, Object> zyMapResult = new HashMap<>();
        zyMapResult.put("data", zyList);
        zyMapResult.put("name", "注意");
        HashMap<String, Object> jgMapResult = new HashMap<>();
        jgMapResult.put("data", jgList);
        jgMapResult.put("name", "警告");

        List<Map<String, Object>> hashMaps = Arrays.asList(wxMapResult, zyMapResult, jgMapResult);
        resultMap.put("axisData", list);
        resultMap.put("seriesData", hashMaps);
        return ResponseHelper.buildResponse(resultMap);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "各场站健康状态指数 ", notes = "各场站健康状态指数 ")
    @GetMapping(value = "/getHealthInfoByStation")
    public ResponseModel<Map<String, Object>> getHealthInfoByArea(@RequestParam(required = false) String areaCode) {
        Map<String, Object> resultMap = new HashMap<>();
        List<Map<String, Object>> healthListInfo = idxBizFanHealthIndexMapper.getHealthInfoByStation(areaCode);
        Map<String, BigDecimal> collect = healthListInfo.stream().collect(Collectors.toMap(t -> t.get("area").toString(), t -> new BigDecimal(t.get("healthIndex").toString())));



        List<StationBasic> stationBasics = stationBasicMapper.selectList(new LambdaQueryWrapper<StationBasic>().eq(StationBasic::getAreaName, areaCode));
        List<String> list = stationBasics.stream().map(StationBasic::getStationName).collect(Collectors.toList());
        List<Object> seriesData = new ArrayList<>();
        list.forEach(item -> seriesData.add(collect.getOrDefault(item, new BigDecimal("0"))));
        resultMap.put("axisData", list);
        resultMap.put("seriesData", seriesData);
        return ResponseHelper.buildResponse(resultMap);
    }



    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "场站预警信息统计图 - 雷达图", httpMethod = "GET")
    @GetMapping("/equipWarningRadarMap")
    public ResponseModel<Map<String, Object>> assessIndexRadarMap(@RequestParam(required = false, value = "stationCode") String stationCode) {
        List<Map<String, Object>> list = idxBizFanHealthIndexMapper.equipWarningRadarMap(stationCode);
        HashMap<String, Object> resultMap = new HashMap<>();
        List<List<String>> resultData = new ArrayList<>();
        List<Map<String, Object>> resultList = new ArrayList<>();
        List<String> data = new ArrayList<>();
        list.forEach(item -> {
            HashMap<String, Object> map = new HashMap<>();
            map.put("text", item.get("warningName"));
            resultList.add(map);
            data.add(item.get("num").toString());
        });
        resultData.add(data);
        resultMap.put("radar", resultList);
        resultMap.put("array", resultData);
        return ResponseHelper.buildResponse(resultMap);
    }

}
