package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IndicatorData;
import com.yeejoin.amos.boot.module.jxiop.biz.tdmapper.IndicatorDataMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.List;

@RestController
@RequestMapping(value = "/test")
@Api(tags = "测试Api")
public class TestController extends BaseController {
    @Autowired
    IndicatorDataMapper indicatorDataMapper;

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "test1", notes = "test1")
    @GetMapping("/test1")
    public List<IndicatorData> test1(@RequestParam(value = "startTime") String startTime, @RequestParam(value = "endTime") String endTime, @RequestParam(value = "address") String address, @RequestParam(value = "gatewayId") String gatewayId) {

        List<IndicatorData> indicatorData = indicatorDataMapper.selectDataByAddressAndtime(address, startTime, endTime,gatewayId);

        return indicatorData;
    }
}
