package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.*;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

public class HealthStatusIndicatorServiceImpl {

    @Value("${healthValue_Warn}")
    Double healthValueWarn;
    @Value("${healthValue_Risk}")
    Double healthValueRisk;
    @Value("${healthValue_Notice}")
    Double healthValueNotice;

    @Value("${healthValue_DayCount}")
    long healthValueDayCount;
    @Value("${healthValue_HourCount}")
    long healthValueHourCount;
    @Value("${healthValue_MinCount}")
    long healthValueMinCount;

    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    IdxBizFanHealthIndexMapper idxBizFanHealthIndexMapper;

    @Autowired
    IdxBizFanWarningRecordMapper idxBizFanWarningRecordMapper;

    /***
     * 每一小时获取一次最大粒度内的指数异常数据
     * 判断一小时内数据是否符合预警规则 符合则报警并在redis中缓存 同一级别的预警记录下次不生成
     *
     */



    @Autowired
    IdxBizPvHealthIndexMapper idxBizPvHealthIndexMapper;

    @Autowired
    IdxBizPvWarningRecordMapper idxBizPvWarningRecordMapper;

    /***
     * 每一小时获取一次最大粒度内的指数异常数据
     * 判断一小时内数据是否符合预警规则 符合则报警并在redis中缓存 同一级别的预警记录下次不生成
     *
     */

    @Scheduled(cron = "0 0 */1 * * ?")
    private void healthWarningMinuteGF() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY,calendar.get(Calendar.HOUR_OF_DAY)-1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");

        LambdaQueryWrapper<IdxBizPvHealthIndex> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizPvHealthIndex::getAnalysisType,"按时刻");
        wrapper.le(IdxBizPvHealthIndex::getHealthIndex,healthValueNotice);
        wrapper.ge(IdxBizPvHealthIndex::getRecDate,df.format(calendar.getTime()));
        wrapper.orderByDesc(IdxBizPvHealthIndex::getRecDate);
        List<IdxBizPvHealthIndex> healthIndices = idxBizPvHealthIndexMapper.selectList(wrapper);

        Map<String, Map<String, List<IdxBizPvHealthIndex>>> gateWayMaps = healthIndices.stream().collect(Collectors.groupingBy(IdxBizPvHealthIndex::getGatewayId, Collectors.groupingBy(IdxBizPvHealthIndex::getIndexAddress)));
        for (String gateWayId : gateWayMaps.keySet()) {
            Map<String, List<IdxBizPvHealthIndex>> healthDataMaps = gateWayMaps.get(gateWayId);
            for (String address : healthDataMaps.keySet()) {
                List<IdxBizPvHealthIndex> idxBizPvHealthIndices = healthDataMaps.get(address);
                List<Double> healthIndex = idxBizPvHealthIndices.stream().map(IdxBizPvHealthIndex::getHealthIndex).collect(Collectors.toList());
                long riskNum = healthIndex.stream().filter(e -> e <= healthValueRisk).count();
                long warnNum = healthIndex.stream().filter(e -> e <= healthValueWarn).count();
                long noticeNum = healthIndex.stream().filter(e -> e <= healthValueNotice).count();

                String level = "";
                String content = "";
                String num = "";
                content = healthValueMinCount + "分钟";
                if (riskNum >= healthValueMinCount && !redisUtils.hasKey(gateWayId+"_"+address+"_health_risk_minute")){
                    redisUtils.set(gateWayId+"_"+address+"_health_risk_minute","risk");
                    level ="危险";

                    num = ""+healthValueRisk;
                }else if (warnNum >= healthValueMinCount && !redisUtils.hasKey(gateWayId+"_"+address+"_health_warn_minute") ){
                    redisUtils.set(gateWayId+"_"+address+"_health_warn_minute","warn");
                    level ="警告";
                    num = ""+healthValueWarn;
                }else if (noticeNum >= healthValueMinCount &&  !redisUtils.hasKey(gateWayId+"_"+address+"_health_notice_minute")){
                    redisUtils.set(gateWayId+"_"+address+"_health_notice_minute","notice");
                    level ="注意";
                    num = ""+healthValueNotice;
                }

                if (!level.equals("")){
                    IdxBizPvWarningRecord idxBizPvWarningRecord = new IdxBizPvWarningRecord();
                    idxBizPvWarningRecord.setRecord(idxBizPvHealthIndices.get(0).getRecord());
                    idxBizPvWarningRecord.setArae(idxBizPvHealthIndices.get(0).getArae());
                    idxBizPvWarningRecord.setStation(idxBizPvHealthIndices.get(0).getStation());
                    idxBizPvWarningRecord.setSubarray(idxBizPvHealthIndices.get(0).getSubarray());
                    idxBizPvWarningRecord.setGatewayId(gateWayId);
                    idxBizPvWarningRecord.setIndexAddress(address);
                    idxBizPvWarningRecord.setEquipmentName(idxBizPvHealthIndices.get(0).getEquipmentName());
                    idxBizPvWarningRecord.setAnalysisPointId(idxBizPvHealthIndices.get(0).getAnalysisObjSeq());
                    idxBizPvWarningRecord.setDisposotionState("未处置");
                    idxBizPvWarningRecord.setStatus("0");
                    idxBizPvWarningRecord.setWarningName(level);
                    idxBizPvWarningRecord.setCONTENT("连续"+content+"健康指数<"+num );
                    idxBizPvWarningRecordMapper.insert(idxBizPvWarningRecord);
                }
            }
        }
    }

    /***
     * 每五小时获取一次最大粒度内的指数异常数据
     * 判断五小时内数据是否符合预警规则 符合则报警并在redis中缓存 同一级别的预警记录下次不生成
     *
     */

    @Scheduled(cron = "0 0 */5 * * ?")
    private void healthWarningHourGF() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY,calendar.get(Calendar.HOUR_OF_DAY)-5);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");

        LambdaQueryWrapper<IdxBizPvHealthIndex> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizPvHealthIndex::getAnalysisType,"按小时");
        wrapper.le(IdxBizPvHealthIndex::getHealthIndex,healthValueNotice);
        wrapper.ge(IdxBizPvHealthIndex::getRecDate,df.format(calendar.getTime()));
        wrapper.orderByDesc(IdxBizPvHealthIndex::getRecDate);
        List<IdxBizPvHealthIndex> healthIndices = idxBizPvHealthIndexMapper.selectList(wrapper);

        Map<String, Map<String, List<IdxBizPvHealthIndex>>> gateWayMaps = healthIndices.stream().collect(Collectors.groupingBy(IdxBizPvHealthIndex::getGatewayId, Collectors.groupingBy(IdxBizPvHealthIndex::getIndexAddress)));
        for (String gateWayId : gateWayMaps.keySet()) {
            Map<String, List<IdxBizPvHealthIndex>> healthDataMaps = gateWayMaps.get(gateWayId);
            for (String address : healthDataMaps.keySet()) {
                List<IdxBizPvHealthIndex> idxBizPvHealthIndices = healthDataMaps.get(address);
                List<Double> healthIndex = idxBizPvHealthIndices.stream().map(IdxBizPvHealthIndex::getHealthIndex).collect(Collectors.toList());
                long riskNum = healthIndex.stream().filter(e -> e <= healthValueRisk).count();
                long warnNum = healthIndex.stream().filter(e -> e <= healthValueWarn).count();
                long noticeNum = healthIndex.stream().filter(e -> e <= healthValueNotice).count();

                String level = "";
                String content = "";
                String num = "";
                content = healthValueHourCount + "小时";
                if (riskNum >= healthValueHourCount && !redisUtils.hasKey(gateWayId+"_"+address+"_health_risk_hour")){
                    redisUtils.set(gateWayId+"_"+address+"_health_risk_hour","risk");
                    level ="危险";
                    num = ""+healthValueRisk;
                }else if (warnNum >= healthValueHourCount && !redisUtils.hasKey(gateWayId+"_"+address+"_health_risk_hour") ){
                    redisUtils.set(gateWayId+"_"+address+"_health_warn_hour","warn");
                    level ="警告";
                    num = ""+healthValueWarn;

                }else if (noticeNum >= healthValueHourCount &&  !redisUtils.hasKey(gateWayId+"_"+address+"_health_notice_hour")){
                    redisUtils.set(gateWayId+"_"+address+"_health_notice_hour","notice");
                    level ="注意";
                    num = ""+healthValueNotice;

                }

                if (!level.equals("")){
                    IdxBizPvWarningRecord idxBizPvWarningRecord = new IdxBizPvWarningRecord();
                    idxBizPvWarningRecord.setRecord(idxBizPvHealthIndices.get(0).getRecord());
                    idxBizPvWarningRecord.setArae(idxBizPvHealthIndices.get(0).getArae());
                    idxBizPvWarningRecord.setStation(idxBizPvHealthIndices.get(0).getStation());
                    idxBizPvWarningRecord.setSubarray(idxBizPvHealthIndices.get(0).getSubarray());
                    idxBizPvWarningRecord.setGatewayId(gateWayId);
                    idxBizPvWarningRecord.setIndexAddress(address);
                    idxBizPvWarningRecord.setEquipmentName(idxBizPvHealthIndices.get(0).getEquipmentName());
                    idxBizPvWarningRecord.setAnalysisPointId(idxBizPvHealthIndices.get(0).getAnalysisObjSeq());
                    idxBizPvWarningRecord.setDisposotionState("未处置");
                    idxBizPvWarningRecord.setStatus("0");
                    idxBizPvWarningRecord.setWarningName(level);
                    idxBizPvWarningRecord.setCONTENT("连续"+content+"健康指数<"+num );
                    idxBizPvWarningRecordMapper.insert(idxBizPvWarningRecord);
                }
            }
        }
    }

    /***
     * 每三天取一次最大粒度内的指数异常数据
     * 判断三天内数据是否符合预警规则 符合则报警并在redis中缓存 同一级别的预警记录下次不生成
     *
     */

    @Scheduled(cron = "0 0 0 */3 * ? ")
    private void healthWarningDayGF() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_MONTH,calendar.get(Calendar.DAY_OF_MONTH)-3);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

        LambdaQueryWrapper<IdxBizPvHealthIndex> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizPvHealthIndex::getAnalysisType,"按天");
        wrapper.le(IdxBizPvHealthIndex::getHealthIndex,healthValueNotice);
        wrapper.ge(IdxBizPvHealthIndex::getRecDate,df.format(calendar.getTime()));
        wrapper.orderByDesc(IdxBizPvHealthIndex::getRecDate);
        List<IdxBizPvHealthIndex> healthIndices = idxBizPvHealthIndexMapper.selectList(wrapper);

        Map<String, Map<String, List<IdxBizPvHealthIndex>>> gateWayMaps = healthIndices.stream().collect(Collectors.groupingBy(IdxBizPvHealthIndex::getGatewayId, Collectors.groupingBy(IdxBizPvHealthIndex::getIndexAddress)));
        for (String gateWayId : gateWayMaps.keySet()) {
            Map<String, List<IdxBizPvHealthIndex>> healthDataMaps = gateWayMaps.get(gateWayId);
            for (String address : healthDataMaps.keySet()) {
                List<IdxBizPvHealthIndex> idxBizPvHealthIndices = healthDataMaps.get(address);
                List<Double> healthIndex = idxBizPvHealthIndices.stream().map(IdxBizPvHealthIndex::getHealthIndex).collect(Collectors.toList());
                long riskNum = healthIndex.stream().filter(e -> e <= healthValueRisk).count();
                long warnNum = healthIndex.stream().filter(e -> e <= healthValueWarn).count();
                long noticeNum = healthIndex.stream().filter(e -> e <= healthValueNotice).count();

                String level = "";
                String content = "";
                String num = "";
                content = healthValueDayCount + "天";
                if (riskNum >= healthValueDayCount && !redisUtils.hasKey(gateWayId+"_"+address+"_health_risk_day")){
                    redisUtils.set(gateWayId+"_"+address+"_health_risk_day","risk");
                    level ="危险";
                    num = ""+healthValueRisk;
                }else if (warnNum >= healthValueDayCount && !redisUtils.hasKey(gateWayId+"_"+address+"_health_warn_day") ){
                    redisUtils.set(gateWayId+"_"+address+"_health_warn_day","warn");
                    level ="警告";
                    num = ""+healthValueWarn;
                }else if (noticeNum >= healthValueDayCount &&  !redisUtils.hasKey(gateWayId+"_"+address+"_health_notice_day")){
                    redisUtils.set(gateWayId+"_"+address+"_health_notice_day","notice");
                    level ="注意";
                    num = ""+healthValueNotice;
                }

                if (!level.equals("")){
                    IdxBizPvWarningRecord idxBizPvWarningRecord = new IdxBizPvWarningRecord();
                    idxBizPvWarningRecord.setRecord(idxBizPvHealthIndices.get(0).getRecord());
                    idxBizPvWarningRecord.setArae(idxBizPvHealthIndices.get(0).getArae());
                    idxBizPvWarningRecord.setStation(idxBizPvHealthIndices.get(0).getStation());
                    idxBizPvWarningRecord.setSubarray(idxBizPvHealthIndices.get(0).getSubarray());
                    idxBizPvWarningRecord.setGatewayId(gateWayId);
                    idxBizPvWarningRecord.setIndexAddress(address);
                    idxBizPvWarningRecord.setEquipmentName(idxBizPvHealthIndices.get(0).getEquipmentName());
                    idxBizPvWarningRecord.setAnalysisPointId(idxBizPvHealthIndices.get(0).getAnalysisObjSeq());
                    idxBizPvWarningRecord.setDisposotionState("未处置");
                    idxBizPvWarningRecord.setStatus("0");
                    idxBizPvWarningRecord.setWarningName(level);
                    idxBizPvWarningRecord.setCONTENT("连续"+content+"健康指数<"+num );
                    idxBizPvWarningRecordMapper.insert(idxBizPvWarningRecord);
                }
            }
        }
    }


    @Scheduled(cron = "0 0 */1 * * ?")
    private void healthWarningMinute() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY,calendar.get(Calendar.HOUR_OF_DAY)-1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");

        LambdaQueryWrapper<IdxBizFanHealthIndex> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizFanHealthIndex::getAnalysisType,"按时刻");
        wrapper.le(IdxBizFanHealthIndex::getHealthIndex,healthValueNotice);
        wrapper.ge(IdxBizFanHealthIndex::getRecDate,df.format(calendar.getTime()));
        wrapper.orderByDesc(IdxBizFanHealthIndex::getRecDate);
        List<IdxBizFanHealthIndex> healthIndices = idxBizFanHealthIndexMapper.selectList(wrapper);

        Map<String, Map<String, List<IdxBizFanHealthIndex>>> gateWayMaps = healthIndices.stream().collect(Collectors.groupingBy(IdxBizFanHealthIndex::getGatewayId, Collectors.groupingBy(IdxBizFanHealthIndex::getIndexAddress)));
        for (String gateWayId : gateWayMaps.keySet()) {
            Map<String, List<IdxBizFanHealthIndex>> healthDataMaps = gateWayMaps.get(gateWayId);
            for (String address : healthDataMaps.keySet()) {
                List<IdxBizFanHealthIndex> idxBizFanHealthIndices = healthDataMaps.get(address);
                List<Double> healthIndex = idxBizFanHealthIndices.stream().map(IdxBizFanHealthIndex::getHealthIndex).collect(Collectors.toList());
                long riskNum = healthIndex.stream().filter(e -> e <= healthValueRisk).count();
                long warnNum = healthIndex.stream().filter(e -> e <= healthValueWarn).count();
                long noticeNum = healthIndex.stream().filter(e -> e <= healthValueNotice).count();

                String level = "";
                String content = "";
                String num = "";
                content = healthValueMinCount + "分钟";
                if (riskNum >= healthValueMinCount && !redisUtils.hasKey(gateWayId+"_"+address+"_health_risk_minute")){
                    redisUtils.set(gateWayId+"_"+address+"_health_risk_minute","risk");
                    level ="危险";

                    num = ""+healthValueRisk;
                }else if (warnNum >= healthValueMinCount && !redisUtils.hasKey(gateWayId+"_"+address+"_health_warn_minute") ){
                    redisUtils.set(gateWayId+"_"+address+"_health_warn_minute","warn");
                    level ="警告";
                    num = ""+healthValueWarn;
                }else if (noticeNum >= healthValueMinCount &&  !redisUtils.hasKey(gateWayId+"_"+address+"_health_notice_minute")){
                    redisUtils.set(gateWayId+"_"+address+"_health_notice_minute","notice");
                    level ="注意";
                    num = ""+healthValueNotice;
                }

                if (!level.equals("")){
                    IdxBizFanWarningRecord idxBizFanWarningRecord = new IdxBizFanWarningRecord();
                    idxBizFanWarningRecord.setRecord(idxBizFanHealthIndices.get(0).getRecord());
                    idxBizFanWarningRecord.setArae(idxBizFanHealthIndices.get(0).getArae());
                    idxBizFanWarningRecord.setStation(idxBizFanHealthIndices.get(0).getStation());
                    idxBizFanWarningRecord.setSubSystem(idxBizFanHealthIndices.get(0).getSubSystem());
                    idxBizFanWarningRecord.setGatewayId(gateWayId);
                    idxBizFanWarningRecord.setIndexAddress(address);
                    idxBizFanWarningRecord.setEquipmentName(idxBizFanHealthIndices.get(0).getEquipmentName());
                    idxBizFanWarningRecord.setAnalysisPointId(idxBizFanHealthIndices.get(0).getAnalysisObjSeq());
                    idxBizFanWarningRecord.setDisposotionState("未处置");
                    idxBizFanWarningRecord.setStatus("0");
                    idxBizFanWarningRecord.setWarningName(level);
                    idxBizFanWarningRecord.setCONTENT("连续"+content+"健康指数<"+num );
                    idxBizFanWarningRecordMapper.insert(idxBizFanWarningRecord);
                }
            }
        }
    }

    /***
     * 每五小时获取一次最大粒度内的指数异常数据
     * 判断五小时内数据是否符合预警规则 符合则报警并在redis中缓存 同一级别的预警记录下次不生成
     *
     */

    @Scheduled(cron = "0 0 */5 * * ?")
    private void healthWarningHour() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY,calendar.get(Calendar.HOUR_OF_DAY)-5);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");

        LambdaQueryWrapper<IdxBizFanHealthIndex> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizFanHealthIndex::getAnalysisType,"按小时");
        wrapper.le(IdxBizFanHealthIndex::getHealthIndex,healthValueNotice);
        wrapper.ge(IdxBizFanHealthIndex::getRecDate,df.format(calendar.getTime()));
        wrapper.orderByDesc(IdxBizFanHealthIndex::getRecDate);
        List<IdxBizFanHealthIndex> healthIndices = idxBizFanHealthIndexMapper.selectList(wrapper);

        Map<String, Map<String, List<IdxBizFanHealthIndex>>> gateWayMaps = healthIndices.stream().collect(Collectors.groupingBy(IdxBizFanHealthIndex::getGatewayId, Collectors.groupingBy(IdxBizFanHealthIndex::getIndexAddress)));
        for (String gateWayId : gateWayMaps.keySet()) {
            Map<String, List<IdxBizFanHealthIndex>> healthDataMaps = gateWayMaps.get(gateWayId);
            for (String address : healthDataMaps.keySet()) {
                List<IdxBizFanHealthIndex> idxBizFanHealthIndices = healthDataMaps.get(address);
                List<Double> healthIndex = idxBizFanHealthIndices.stream().map(IdxBizFanHealthIndex::getHealthIndex).collect(Collectors.toList());
                long riskNum = healthIndex.stream().filter(e -> e <= healthValueRisk).count();
                long warnNum = healthIndex.stream().filter(e -> e <= healthValueWarn).count();
                long noticeNum = healthIndex.stream().filter(e -> e <= healthValueNotice).count();

                String level = "";
                String content = "";
                String num = "";
                content = healthValueHourCount + "小时";
                if (riskNum >= healthValueHourCount && !redisUtils.hasKey(gateWayId+"_"+address+"_health_risk_hour")){
                    redisUtils.set(gateWayId+"_"+address+"_health_risk_hour","risk");
                    level ="危险";
                    num = ""+healthValueRisk;
                }else if (warnNum >= healthValueHourCount && !redisUtils.hasKey(gateWayId+"_"+address+"_health_risk_hour") ){
                    redisUtils.set(gateWayId+"_"+address+"_health_warn_hour","warn");
                    level ="警告";
                    num = ""+healthValueWarn;

                }else if (noticeNum >= healthValueHourCount &&  !redisUtils.hasKey(gateWayId+"_"+address+"_health_notice_hour")){
                    redisUtils.set(gateWayId+"_"+address+"_health_notice_hour","notice");
                    level ="注意";
                    num = ""+healthValueNotice;

                }

                if (!level.equals("")){
                    IdxBizFanWarningRecord idxBizFanWarningRecord = new IdxBizFanWarningRecord();
                    idxBizFanWarningRecord.setRecord(idxBizFanHealthIndices.get(0).getRecord());
                    idxBizFanWarningRecord.setArae(idxBizFanHealthIndices.get(0).getArae());
                    idxBizFanWarningRecord.setStation(idxBizFanHealthIndices.get(0).getStation());
                    idxBizFanWarningRecord.setSubSystem(idxBizFanHealthIndices.get(0).getSubSystem());
                    idxBizFanWarningRecord.setGatewayId(gateWayId);
                    idxBizFanWarningRecord.setIndexAddress(address);
                    idxBizFanWarningRecord.setEquipmentName(idxBizFanHealthIndices.get(0).getEquipmentName());
                    idxBizFanWarningRecord.setAnalysisPointId(idxBizFanHealthIndices.get(0).getAnalysisObjSeq());
                    idxBizFanWarningRecord.setDisposotionState("未处置");
                    idxBizFanWarningRecord.setStatus("0");
                    idxBizFanWarningRecord.setWarningName(level);
                    idxBizFanWarningRecord.setCONTENT("连续"+content+"健康指数<"+num );
                    idxBizFanWarningRecordMapper.insert(idxBizFanWarningRecord);
                }
            }
        }
    }

    /***
     * 每三天取一次最大粒度内的指数异常数据
     * 判断三天内数据是否符合预警规则 符合则报警并在redis中缓存 同一级别的预警记录下次不生成
     *
     */

    @Scheduled(cron = "0 0 0 */3 * ? ")
    private void healthWarningDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_MONTH,calendar.get(Calendar.DAY_OF_MONTH)-3);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

        LambdaQueryWrapper<IdxBizFanHealthIndex> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizFanHealthIndex::getAnalysisType,"按天");
        wrapper.le(IdxBizFanHealthIndex::getHealthIndex,healthValueNotice);
        wrapper.ge(IdxBizFanHealthIndex::getRecDate,df.format(calendar.getTime()));
        wrapper.orderByDesc(IdxBizFanHealthIndex::getRecDate);
        List<IdxBizFanHealthIndex> healthIndices = idxBizFanHealthIndexMapper.selectList(wrapper);

        Map<String, Map<String, List<IdxBizFanHealthIndex>>> gateWayMaps = healthIndices.stream().collect(Collectors.groupingBy(IdxBizFanHealthIndex::getGatewayId, Collectors.groupingBy(IdxBizFanHealthIndex::getIndexAddress)));
        for (String gateWayId : gateWayMaps.keySet()) {
            Map<String, List<IdxBizFanHealthIndex>> healthDataMaps = gateWayMaps.get(gateWayId);
            for (String address : healthDataMaps.keySet()) {
                List<IdxBizFanHealthIndex> idxBizFanHealthIndices = healthDataMaps.get(address);
                List<Double> healthIndex = idxBizFanHealthIndices.stream().map(IdxBizFanHealthIndex::getHealthIndex).collect(Collectors.toList());
                long riskNum = healthIndex.stream().filter(e -> e <= healthValueRisk).count();
                long warnNum = healthIndex.stream().filter(e -> e <= healthValueWarn).count();
                long noticeNum = healthIndex.stream().filter(e -> e <= healthValueNotice).count();

                String level = "";
                String content = "";
                String num = "";
                content = healthValueDayCount + "天";
                if (riskNum >= healthValueDayCount && !redisUtils.hasKey(gateWayId+"_"+address+"_health_risk_day")){
                    redisUtils.set(gateWayId+"_"+address+"_health_risk_day","risk");
                    level ="危险";
                    num = ""+healthValueRisk;
                }else if (warnNum >= healthValueDayCount && !redisUtils.hasKey(gateWayId+"_"+address+"_health_warn_day") ){
                    redisUtils.set(gateWayId+"_"+address+"_health_warn_day","warn");
                    level ="警告";
                    num = ""+healthValueWarn;
                }else if (noticeNum >= healthValueDayCount &&  !redisUtils.hasKey(gateWayId+"_"+address+"_health_notice_day")){
                    redisUtils.set(gateWayId+"_"+address+"_health_notice_day","notice");
                    level ="注意";
                    num = ""+healthValueNotice;
                }

                if (!level.equals("")){
                    IdxBizFanWarningRecord idxBizFanWarningRecord = new IdxBizFanWarningRecord();
                    idxBizFanWarningRecord.setRecord(idxBizFanHealthIndices.get(0).getRecord());
                    idxBizFanWarningRecord.setArae(idxBizFanHealthIndices.get(0).getArae());
                    idxBizFanWarningRecord.setStation(idxBizFanHealthIndices.get(0).getStation());
                    idxBizFanWarningRecord.setSubSystem(idxBizFanHealthIndices.get(0).getSubSystem());
                    idxBizFanWarningRecord.setGatewayId(gateWayId);
                    idxBizFanWarningRecord.setIndexAddress(address);
                    idxBizFanWarningRecord.setEquipmentName(idxBizFanHealthIndices.get(0).getEquipmentName());
                    idxBizFanWarningRecord.setAnalysisPointId(idxBizFanHealthIndices.get(0).getAnalysisObjSeq());
                    idxBizFanWarningRecord.setDisposotionState("未处置");
                    idxBizFanWarningRecord.setStatus("0");
                    idxBizFanWarningRecord.setWarningName(level);
                    idxBizFanWarningRecord.setCONTENT("连续"+content+"健康指数<"+num );
                    idxBizFanWarningRecordMapper.insert(idxBizFanWarningRecord);
                }
            }
        }
    }

}
