package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.precontrol.common.entity.Project;
import com.yeejoin.precontrol.common.entity.ProjectVideo;
import com.yeejoin.precontrol.common.service.IProjectService;
import com.yeejoin.precontrol.common.service.IProjectVideoService;
import com.yeejoin.precontrol.common.utils.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * 项目视频表
 *
 * @author duanwei
 * @date 2020-08-06
 */
@RestController
@Api(tags = "项目视频表Api")
@RequestMapping(value = "/project-video", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ProjectVideoController {

    /**
     * 工程视频服务
     */
    @Autowired
    IProjectVideoService iProjectVideoService;

    /**
     * 工程服务
     */
    @Autowired
    IProjectService iProjectService;

    /**
     * 文件服务器
     */
    @Value("${fileserver.domain}")
    private String fileserver;

    @Value("${camera-conf.protocol}")
    private String protocol;

    @Value("${camera-conf.socket}")
    private String socket;

    /**
     * 新增项目视频表
     *
     * @return
     */
    @RequestMapping(value = "", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增项目视频表", notes = "新增项目视频表")
    public boolean saveProjectVideo(@RequestBody ProjectVideo projectVideo) {
        if (ValidationUtil.isEmpty(projectVideo.getIp()) || ValidationUtil.isEmpty(projectVideo.getPort())
                || ValidationUtil.isEmpty(projectVideo.getUsername()) || ValidationUtil.isEmpty(projectVideo.getPassword())
                || ValidationUtil.isEmpty(projectVideo.getProjectId())) {
            throw new BadRequest("参数不正确");
        }
        projectVideo.setProtocol(protocol);
        projectVideo.setSocket(socket);
        updateToken(projectVideo);
        return iProjectVideoService.save(projectVideo);
    }

    private void updateToken(ProjectVideo projectVideo) {
        String token = UUID.randomUUID().toString();
        projectVideo.setToken(token);
        // TODO-调用第三方注册摄像头

    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
        return iProjectVideoService.removeById(id);
    }

    /**
     * 修改项目视频表
     *
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改项目视频表", notes = "修改项目视频表")
    public boolean updateByIdProjectVideo(@PathVariable("id") Long id, @RequestBody ProjectVideo projectVideo) {
        if (null == id) {
            throw new BadRequest("缺少目标");
        }

        ProjectVideo old = iProjectVideoService.getById(id);
        if (null == old) {
            throw new BadRequest("目标不存在");
        }
        if (ValidationUtil.isEmpty(projectVideo) || ValidationUtil.isEmpty(projectVideo.getIp())
                || ValidationUtil.isEmpty(projectVideo.getPort()) || ValidationUtil.isEmpty(projectVideo.getUsername())
                || ValidationUtil.isEmpty(projectVideo.getPassword()) || ValidationUtil.isEmpty(projectVideo.getProjectId())
        ) {
            throw new BadRequest("参数不正确");
        }
        projectVideo.setProtocol(protocol);
        projectVideo.setSocket(socket);
        if (StringUtils.equals(old.getUsername(), projectVideo.getUsername()) && StringUtils.equals(old.getPassword(), projectVideo.getPassword())
                && StringUtils.equals(old.getIp(), projectVideo.getIp()) && projectVideo.getPort().equals(old.getPort())) {
        }else {
            updateToken(projectVideo);
        }
        return iProjectVideoService.updateById(projectVideo);
    }

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public Object selectById(@PathVariable Long id) {
        ProjectVideo res = iProjectVideoService.getById(id);
        return res;
    }

    /**
     * 列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public Object listPage(String projectId) {
        List<ProjectVideo> projectVideoList;
        Map<String, Object> map = new HashMap<>(2);
        map.put("title", "");
        if (StringUtils.isEmpty(projectId)) {
            projectVideoList = iProjectVideoService.list();
        } else {
            Project project = iProjectService.getById(projectId);
            if (project != null) {
                map.put("title", project.getName());
            }
            projectVideoList = iProjectVideoService.list(new LambdaQueryWrapper<ProjectVideo>().eq(ProjectVideo::getProjectId, projectId));
        }
        if (StringUtil.isNotEmpty(projectVideoList)) {
            projectVideoList.forEach(projectVideo -> projectVideo.setUsername(null).setPassword(null));
        }
        map.put("videoList", projectVideoList);
        return map;
    }

}
