package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.ugp.api.constants.XJConstant;
import com.yeejoin.amos.boot.module.ugp.api.dto.MaterialCount;
import com.yeejoin.amos.boot.module.ugp.api.entity.Material;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProjectResource;
import com.yeejoin.amos.boot.module.ugp.api.mapper.AttachmentMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectResourceMapper;
import com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.*;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.MaterialDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 材料信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "材料信息表Api")
@RequestMapping(value = "/material")
public class MaterialController extends BaseController {

    @Autowired
    MaterialServiceImpl materialServiceImpl;
    @Autowired
	AttachmentServiceImpl attachmentServiceImpl;
    @Autowired
	AttachmentMapper attachmentMapper;
	@Autowired
	OrgServiceImpl orgService;
	@Autowired
	ProjectResourceMapper projectResourceMapper;


    /**
     * 新增材料信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增材料信息表", notes = "新增材料信息表")
	public ResponseModel<MaterialDto> save(@RequestBody MaterialDto model) {
	    model = materialServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新材料信息表", notes = "根据sequenceNbr更新材料信息表")
	public ResponseModel<MaterialDto> updateBySequenceNbrMaterial(@RequestBody MaterialDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(materialServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除材料信息表", notes = "根据sequenceNbr删除材料信息表")
	public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") List<Long> sequenceNbr) throws Exception {

		LambdaQueryWrapper<ProjectResource> wrapper = new LambdaQueryWrapper<>();
		for (Long i : sequenceNbr) {
			wrapper.eq(ProjectResource::getResourceId, i);
			if (!projectResourceMapper.selectList(wrapper).isEmpty()) {

				return CommonResponseUtil.failure("无法删除,管材：" + materialServiceImpl.getById(i).getName() + "已绑定项目");
			}
		}
		return ResponseHelper.buildResponse(materialServiceImpl.removeByIds(sequenceNbr));
	}



    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个材料信息表",  notes = "根据sequenceNbr查询单个材料信息表")
	public ResponseModel<MaterialDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(materialServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "材料信息表分页查询",  notes = "材料信息表分页查询")

	public ResponseModel<IPage<Material>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size,
					@RequestParam(value = "name",required = false) String name,
					@RequestParam(value = "code",required = false) String code) {
	    IPage<Material> page = new Page<>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(materialServiceImpl.queryForMaterialPage(page,name,code));
	}

	/**
	 * 提交资料 获取管材列表 分页查询 projectId关联的资源
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping( value = "/pageOutList")
	@ApiOperation(httpMethod = "GET",value = "材料信息表分页查询",  notes = "材料信息表分页查询")
	public ResponseModel<IPage<MaterialDto>> queryPage(@RequestParam(required=false) Integer current,@RequestParam(required=false) Integer size, MaterialDto material) {
		IPage<Material> page = new Page<>();
		if(ValidationUtil.isEmpty(current) && ValidationUtil.isEmpty(size)){
			page.setCurrent(1);
			page.setSize(Long.MAX_VALUE);
		} else{
			page.setCurrent(current);
			page.setSize(size);
		}
		return ResponseHelper.buildResponse(materialServiceImpl.queryOutPage(page,material));
	}

	/**
	 * 提交资料 获取管材列表 分页查询 projectId关联的资源和空闲的资源
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping( value = "/pageInList")
	@ApiOperation(httpMethod = "GET",value = "材料信息表分页查询",  notes = "材料信息表分页查询")
	public ResponseModel<IPage<MaterialDto>> queryMaterialPage( int current, int size, MaterialDto material) {
		IPage<Material> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(materialServiceImpl.queryInPage(page,material));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "材料信息表列表全部数据查询",   notes = "材料信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<MaterialDto>> selectForList() {
	    return ResponseHelper.buildResponse(materialServiceImpl.queryForMaterialList());
	}


//	/**
//     * 根据项目id查询材料信息
//     *
//     * @return
//     */
//	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
//	@ApiOperation(httpMethod = "GET",value = "根据项目id查询材料信息",   notes = "根据项目id查询材料信息")
//	@GetMapping(value = "/selectMess")
//	public ResponseModel<MaterialDto> selectMess(@RequestParam String companyId ) {
//		return ResponseHelper.buildResponse(materialServiceImpl.selectMess(companyId));
//	}

	/**
	 * 材料信息表列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "材料信息表列表全部数据查询",   notes = "材料信息表列表全部数据查询")
	@GetMapping(value = "/selectName")
	public ResponseModel<List<JSONObject>> selectName() {
		return ResponseHelper.buildResponse(materialServiceImpl.selectName());
	}
	/**
	 * 新增材料+附件
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping (value = "/saveIM")
	@ApiOperation(httpMethod = "POST", value = "新增材料+附件", notes = "新增材料+附件")
	public ResponseModel<MaterialDto>  saveMaterial(@RequestBody JSONObject object) {
		MaterialDto model = materialServiceImpl.saveMaterial(object);
		Long mSequenceNbr = model.getSequenceNbr();
		if (object.containsKey("subForm")){
			JSONArray subForm = object.getJSONArray("subForm");
			attachmentServiceImpl.saveAttachment(subForm,mSequenceNbr);
		}
		return  ResponseHelper.buildResponse(model);
	}
	/**
	 * 根据sequenceNbr查询材料的附件
	 *
	 * @param sequenceNbr  主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "findIM/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询材料和附件",  notes = "根据sequenceNbr查询材料和附件")
	public ResponseModel<JSONObject> selectIMOne(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(materialServiceImpl.groupBySeq(sequenceNbr));
	}

	/**
	 * 根据sequenceNbr更新材料及附件
	 *
	 * @param sequenceNbr  主键
	 * @return
	 */

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@PostMapping(value = "updataIM/{sequenceNbr}")
	@ApiOperation(httpMethod = "POST",value = "根据sequenceNbr更新设备和附件",  notes = "根据sequenceNbr更新设备和附件")
	public ResponseModel<String> updataIMOne(@PathVariable Long sequenceNbr,@RequestBody JSONObject object) {
		materialServiceImpl.updateMI(sequenceNbr,object);
		return ResponseHelper.buildResponse("ok");
	}
	/**
	 *根据sequenceNbr删除材料和附件
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@DeleteMapping(value = "deleteIM/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除材料和附件", notes = "根据sequenceNbr删除材料和附件")
	public ResponseModel<Boolean> deleteIMBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
		attachmentMapper.deleteBySourceId(sequenceNbr);
		return ResponseHelper.buildResponse(materialServiceImpl.removeById(sequenceNbr));
	}


	/**
	 * 管材厂家统计
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/pipeManufacturer")
	@ApiOperation(httpMethod = "GET",value = "管材厂家统计",  notes = "管材厂家统计")
	public ResponseModel<JSONObject> pipeManufacturerStatistics() {
		List<MaterialCount> materialCounts = materialServiceImpl.pipeManufacturerStatistics( );
		JSONObject object = new JSONObject( );
		JSONArray axisData = new JSONArray( );
		JSONArray seriesData = new JSONArray( );
       materialCounts.forEach((m)->{
		   axisData.add(m.getManufactureAddr());
		   seriesData.add(m.getSum());
			   }
	   );
		object.put("axisData",axisData);
		object.put("seriesData",seriesData);
		return ResponseHelper.buildResponse(object);
	}

	/**
	 * 新增管材信息上传文件定义
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "getFiles")
	@ApiOperation(httpMethod = "GET",value = "查询需要上传的附件信息",  notes = "查询需要上传的附件信息")
	public ResponseModel<JSONObject> getFiles() {
		JSONObject jsonObject = new JSONObject();
		JSONArray designSubForm = JSON.parseArray(XJConstant.MATERIAL_FILES);
		jsonObject.put("subForm", designSubForm);
		return ResponseHelper.buildResponse(jsonObject);
	}
}
