package com.yeejoin.amos.boot.module.elevator.flc.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 装备信息表
 *
 * @author system_generator
 * @date 2021-11-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "EquipmentDto", description = "装备信息表")
public class EquipmentDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "设备id")
    private String equipId;

    @ApiModelProperty(value = "设备编号")
    private String code;

    @ApiModelProperty(value = "设备名称")
    private String name;

    @ApiModelProperty(value = "设备类别id")
    private Long categoryId;

    @ApiModelProperty(value = "设备类别名称")
    private String categoryName;

    @ApiModelProperty(value = "设备种类id")
    private Long typeId;

    @ApiModelProperty(value = "设备种类名称")
    private String typeName;

    @ApiModelProperty(value = "设备品种id")
    private Long varietyId;

    @ApiModelProperty(value = "设备品种名称")
    private String varietyName;

    @ApiModelProperty(value = "设备品牌")
    private String brand;

    @ApiModelProperty(value = "规格型号")
    private String model;

    @ApiModelProperty(value = "单位内部编号")
    private String innerCode;

    @ApiModelProperty(value = "设计单位名称")
    private String designUnitName;

    @ApiModelProperty(value = "制造单位名称")
    private String manufacturer;

    @ApiModelProperty(value = "设计使用年限")
    private Integer designLife;

    @ApiModelProperty(value = "出厂日期")
    private Date factoryDate;

    @ApiModelProperty(value = "产品编号（出厂编号）")
    private String productCode;

    @ApiModelProperty(value = "监督检验机构")
    private String supervisionAgency;

    @ApiModelProperty(value = "检验报告编号")
    private String inspectionReportCode;

    @ApiModelProperty(value = "设备状态（未安装，已安装）")
    private String status;

    @ExcelIgnore
    @ApiModelProperty(value = "附件")
    @TableField(exist = false)
    private Map<String, List<AttachmentDto>> attachments;

    @ApiModelProperty(value = "设备参数")
    private List<EquipmentIndexDto> equipmentIndex;

    @ApiModelProperty(value = "设备所属单位id")
    private Long equipUnitId;

    @ApiModelProperty(value = "设备所属单位")
    private String equipUnit;

    @ApiModelProperty(value = "详细地址")
    private String address;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "所属区域代码")
    private String regionCode;

}
