package com.yeejoin.precontrol.common.enums;

public enum PersonContractEnum {
	
	LWPQ("劳务派遣形式用工", 1L),

	ZJQD("直接签订用工合同", 2L),

	LWFB("劳务分包", 3L),

	GCFB("工程分包", 4L),

	OTHER("其他", 5L);

	private String label;
	private Long value;

	PersonContractEnum(String label, Long value) {
		this.label = label;
		this.value = value;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public Long getValue() {
		return value;
	}

	public void setValue(Long value) {
		this.value = value;
	}

	public static String getLabelByValue(Long value) {
		String label = null;
		for (SexEum type : SexEum.values()) {
			if (type.getValue().equals(value)) {
				label = type.getLabel();
				break;
			}
		}
		return label;
	}
}
