package com.yeejoin.amos.boot.module.ugp.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @Author cpp
 * @Description
 * @Date 2022/10/18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="AcceptDto", description="接收App数据")
public class AcceptDto  extends BaseDto {

    private static final long serialVersionUID = 1L;
   //人员信息
    @ApiModelProperty(value = "项目id")
    private Long projectId;
    @ApiModelProperty(value = "焊口编号")
    private String code;
    @ApiModelProperty(value = "焊接定位信息")
    private String peopleLocation;
    @ApiModelProperty(value = "人脸识别图片信息")
    private String peoplePhoto;
    @ApiModelProperty(value = "人员id")
    private String userId;
    @ApiModelProperty(value = "阶段检验")
    private String stage;

   //设备
   @ApiModelProperty(value = "设备id")
   private String facilityId;
    @ApiModelProperty(value = "检定状态")
    private String calibrationStatus;
    @ApiModelProperty(value = "设备图片")
    private String facilityPhoto;
    //管材
    @ApiModelProperty(value = "管材id")
    private String materialId;
    @ApiModelProperty(value = "管材图片信息")
    private String materialPhoto;

    //工艺
    @ApiModelProperty(value = "焊接工艺")
    private String craft;
    @ApiModelProperty(value = "焊机设备id")
    private String weldingId;
    @ApiModelProperty(value = "工艺图片")
    private String craftPhoto;
    //埋深
    @ApiModelProperty(value = "埋深检测方式")
    private String depthType;
     @ApiModelProperty(value = "埋深")
     private String depth;
     @ApiModelProperty(value = "埋深定位信息")
     private String depthLocation;
     @ApiModelProperty(value = "埋深图片信息")
     private String depthPhoto;

    //耐压
    @ApiModelProperty(value = "耐压设备id")
    private String pressureId;
    @ApiModelProperty(value = "压力测试")
    private String pressureTest;
    @ApiModelProperty(value = "耐压测试定位信息")
    private String pressureLocation;
    @ApiModelProperty(value = "耐压图片信息")
    private String pressurePhoto;
    //定位
    @ApiModelProperty(value = "焊口精确定位方式")
    private String locationType;
   @ApiModelProperty(value = "图片信息")
   private String locationPhoto;




}
