package com.yeejoin.amos.boot.module.ugp.api.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.*;
import com.yeejoin.amos.boot.module.ugp.api.entity.Material;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProjectResource;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.aspectj.weaver.ast.Test;

/**
 * 项目资源表（包括焊工、管材、设备） Mapper 接口
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Mapper
public interface ProjectResourceMapper extends BaseMapper<ProjectResource> {

    //焊机设备表
    Page<WelderEquipmentDto> WelderEquipment(IPage<WelderEquipmentDto> page, @Param("name") String name, @Param("type") String type);

    Page<WelderEquipmentDto> selectByName(Page<WelderEquipmentDto> page, @Param("name") String name, @Param("unit") String unit);

    Page<WelderEquipmentDto> selectByInfo(Page<WelderEquipmentDto> page, @Param("info") Test info, @Param("unit") String unit);

    WelderEquipmentDto customSelectById(@Param("sequenceNbr") Long sequenceNbr);

    //管材页面分页,根据名称、编号筛选
    Page<ProjectMaterialDto>  MaterialPage(IPage<ProjectMaterialDto> page ,@Param("name") String name, @Param("code") String code);

    //根据resource_id删除项目焊工人员信息
    Boolean deleteByResourceId(Long resourceId);
}
