package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.ugp.api.Enum.StageEnum;
import com.yeejoin.amos.boot.module.ugp.api.dto.*;
import com.yeejoin.amos.boot.module.ugp.api.service.IVerifyService;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.VerifyServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 智能监检管理表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "智能监检管理表Api")
@RequestMapping(value = "/verify")
public class VerifyController extends BaseController {

    @Autowired
    VerifyServiceImpl verifyServiceImpl;
    @Autowired
	IVerifyService service;

    /**
     * 新增智能监检管理表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增智能监检管理表", notes = "新增智能监检管理表")
	public ResponseModel<VerifyDto> save(@RequestBody VerifyDto model) {
	    model = verifyServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新智能监检管理表", notes = "根据sequenceNbr更新智能监检管理表")
	public ResponseModel<VerifyDto> updateBySequenceNbrVerify(@RequestBody VerifyDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(verifyServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除智能监检管理表", notes = "根据sequenceNbr删除智能监检管理表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(verifyServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个智能监检管理表",  notes = "根据sequenceNbr查询单个智能监检管理表")
	public ResponseModel<VerifyDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(verifyServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "智能监检管理表分页查询",  notes = "智能监检管理表分页查询")
	public ResponseModel<Page<VerifyDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<VerifyDto> page = new Page<VerifyDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(verifyServiceImpl.queryForVerifyPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "智能监检管理表列表全部数据查询",   notes = "智能监检管理表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<VerifyDto>> selectForList() {
	    return ResponseHelper.buildResponse(verifyServiceImpl.queryForVerifyList());
	}









	/**   cpp
	 *
	 *焊接管材检验信息列表
	 * @param current
	 * @param size
	 * @return
	 */

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectTubular")
	@ApiOperation(httpMethod = "GET", value = "焊接管材检验信息列表", notes = "焊接管材检验信息列表")
	public ResponseModel<Page<SmartListDto>> selectTubular(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size,SmartListDto smartListDto) {
		Page<SmartListDto> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.commonality(StageEnum.焊前管材质量.getStage(),page,smartListDto));
	}
	/**   cpp
	 *
	 *查询焊接人员检验信息列表
	 * @param current
	 * @param size
	 * @param
	 * @return
	 */

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectWorker")
	@ApiOperation(httpMethod = "GET", value = "查询焊接人员检验信息列表", notes = "查询焊接人员检验信息列表")
	public ResponseModel<Page<SmartListDto>> selectWorker(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size,SmartListDto smartListDto) {
		Page<SmartListDto> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.commonality(StageEnum.焊前人员.getStage(),page,smartListDto));
	}

	/**   cpp
	 *
	 *查询焊接设备检验信息列表
	 * @param current
	 * @param size
	 * @return
	 */

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectFacility")
	@ApiOperation(httpMethod = "GET", value = "查询焊接设备检验信息列表", notes = "查询焊接设备检验信息列表")
	public ResponseModel<Page<SmartListDto>> selectFacility(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size,SmartListDto smartListDto) {
		Page<SmartListDto> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.commonality(StageEnum.焊前设备.getStage(),page,smartListDto));
	}
	/**   cpp
	 *
	 *查询焊接工艺检验信息列表
	 * @param current
	 * @param size
	 * @return
	 */

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectCraft")
	@ApiOperation(httpMethod = "GET", value = "查询焊接工艺检验信息列表", notes = "查询焊接工艺检验信息列表")
	public ResponseModel<Page<SmartListDto>> selectCraft(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size,SmartListDto smartListDto) {
		Page<SmartListDto> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.commonality(StageEnum.焊接工艺.getStage(),page,smartListDto));
	}
	/**   cpp
	 *
	 *查询管道耐压检验信息列表
	 * @param current
	 * @param size
	 * @return
	 */

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectVoltage")
	@ApiOperation(httpMethod = "GET", value = "查询管道耐压检验信息列表", notes = "查询管道耐压检验信息列表")
	public ResponseModel<Page<SmartListDto>> selectVoltage(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size,SmartListDto smartListDto) {
		Page<SmartListDto> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.commonality(StageEnum.管道耐压.getStage(),page,smartListDto));
	}

	/**   cpp
	 *
	 *敷设位置标定检验列表
	 * @param current
	 * @param size
	 * @return
	 */

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectLocation")
	@ApiOperation(httpMethod = "GET", value = "敷设位置标定检验列表", notes = "敷设位置标定检验列表")
	public ResponseModel<Page<SmartListDto>> selectLocation(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size,SmartListDto smartListDto) {
		Page<SmartListDto> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.commonality(StageEnum.定位.getStage(),page,	smartListDto));
	}

	/**
	 *  cpp
	 *     校验
	 * @param dto
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@PostMapping(value = "/checks")
	@ApiOperation(httpMethod = "POST", value = "校验app上传数据", notes = "校验app上传数据")
	public ResponseModel<String> checks(@RequestBody AcceptDto dto) {
		return ResponseHelper.buildResponse(verifyServiceImpl.checks(dto));
	}

















	/**
	 * 焊接工艺效验
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "POST", value = "焊接工艺效验", notes = "焊接工艺效验")
	@PostMapping(value = "/weldeEffect")
	public ResponseModel<String> weldEffect(@RequestBody JSONObject jsonObject) {
		return ResponseHelper.buildResponse(verifyServiceImpl.weldEffect(jsonObject));
	}


	/**
	 * 管材耐压效验
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "POST", value = "管材耐压效验", notes = "管材耐压效验")
	@PostMapping(value = "/materialEffect")
	public ResponseModel<String> materialEffect(@RequestBody JSONObject jsonObject) {
		return ResponseHelper.buildResponse(verifyServiceImpl.materialEffect(jsonObject));
	}
	/**
	 * 敷设质量检验
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "POST", value = "敷设质量检验", notes = "敷设质量检验")
	@PostMapping(value = "/layEffect")
	public ResponseModel<String> layEffect(@RequestBody JSONObject jsonObject) {
		return ResponseHelper.buildResponse(verifyServiceImpl.layEffect(jsonObject));
	}


	/**
	 *焊口敷设位置标定检验
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "POST", value = "焊口敷设位置标定检验", notes = "焊口敷设位置标定检验")
	@PostMapping(value = "/positionEffect")
	public ResponseModel<String> positionEffect(@RequestBody JSONObject jsonObject) {
		return ResponseHelper.buildResponse(verifyServiceImpl.positionEffect(jsonObject));
	}

}
