package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrFormDto;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.boot.module.ugp.api.dto.PercentOfPassDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.WeldDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.QualityInfo;
import com.yeejoin.amos.boot.module.ugp.api.entity.Weld;
import com.yeejoin.amos.boot.module.ugp.api.mapper.IInstallationQualityMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IInstallationQualityService;
import jdk.nashorn.internal.runtime.logging.Logger;
import lombok.extern.log4j.Log4j;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author cpp
 * @Description
 * @Date 2022/10/10
 */
@Service


public class InstallationQualityImpl extends BaseService<PercentOfPassDto, QualityInfo, IInstallationQualityMapper> implements IInstallationQualityService {

    @Resource
    private IInstallationQualityMapper mapper;
    @Resource
    private WeldServiceImpl weldService;
    @Resource
    private OrgUsrServiceImpl orgUsrService;



    //分页查询项目质量监检信息
    @Override
    public Page<PercentOfPassDto> find(Page<PercentOfPassDto> page,PercentOfPassDto pd) {

        String name = pd.getName( );

        List<QualityInfo> qfList = mapper.findss ( );
        List<PercentOfPassDto> list = new ArrayList<> ( );

        for (QualityInfo qualityInfo : qfList) {

            PercentOfPassDto percentOfPassDto = new PercentOfPassDto ( );

            percentOfPassDto.setName (qualityInfo.getProject ( ).getName ( ));
            percentOfPassDto.setAddress (qualityInfo.getProject ( ).getAddress ( ));
            percentOfPassDto.setProgressStatus (qualityInfo.getProject ( ).getProgressStatus ( ));
            percentOfPassDto.setProjectId (qualityInfo.getProjectId ( ));

            percentOfPassDto.setChargePerson (qualityInfo.getProject ( ).getChargePerson ( ));
            //获取监理单位的id
            Long supervisoryUnitId = qualityInfo.getSupervisoryUnitId ( );
            //调用接口
            try {
                OrgUsrFormDto orgUsrFormDto = orgUsrService.selectCompanyById (supervisoryUnitId);
                String currentUnit = orgUsrFormDto.getCurrentUnit ( );
                percentOfPassDto.setCurrentUnit (currentUnit);
            } catch (Exception e) {
                e.printStackTrace ( );
            }

            percentOfPassDto.setStartDate (qualityInfo.getProject ( ).getStartDate ( ));
            percentOfPassDto.setConstructionUnit (qualityInfo.getProject ( ).getConstructionUnit ( ));
            percentOfPassDto.setSubmitDate (qualityInfo.getProject ( ).getSubmitDate ( ));
            list.add (percentOfPassDto);

        }

        //创建新的集合来存放数据
        List<PercentOfPassDto> newsData = new ArrayList<> ( );
        if (list != null && list.size ( ) > 0) {
            //遍历数据
            for (PercentOfPassDto pr : list) {
                //获取项目id
                Long projectId = pr.getProjectId ( );

                //通过项目id查询焊口数据
                List<WeldDto> weldDtoList = weldService.getProjectId (projectId);

                if (weldDtoList != null && weldDtoList.size ( ) > 0) {
                    //获取焊口信息总条数
                    int sum = weldDtoList.size ( );
                    //焊口合格数
                    int qualifiedData = 0;
                    for (WeldDto weldDto : weldDtoList) {
                        String superInspecStatus = weldDto.getSuperInspecStatus ( );
                        if (superInspecStatus.equals ("合格")) {

                            qualifiedData++;
                        }
                    }
                    //合格率
                    BigDecimal sums = new BigDecimal (sum);

                    BigDecimal qualifiedDatas = new BigDecimal (qualifiedData);
                    Double pass = qualifiedDatas.divide (sums, 2, BigDecimal.ROUND_HALF_UP).multiply (new BigDecimal (100)).doubleValue ( );
                    //转换成百分比,生成合格率
                    String fpy = pass.toString ( ) + "%";
                    //将合格率赋值给数据集合
                    pr.setPercentOfPass (fpy);

                    //将数据添加到新集合里面
                    newsData.add (pr);

                }
            }

            //name不为空走条件筛选
            if (!StringUtils.isEmpty(name)) {
                //进行数据筛选
                List<PercentOfPassDto> collect = newsData.stream ( ).filter (b -> b.getName ( ).equals (name)).collect (Collectors.toList ( ));
                page.setRecords (collect);
                page.setTotal (collect.size ());
                return  page;

            }else {

                //如果条件name为空的,直接查询全部
                page.setRecords (newsData);
                page.setTotal (newsData.size ());
                return page;

            }
        }
        return page;
    }
}


