package com.yeejoin.amos.boot.module.ugp.biz.service.impl;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

import com.mao.demo1.TestWeldingRules;
import com.mao.demo1.material.MyPqr;
import com.mao.demo1.material.MyWps;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.ugp.api.Enum.StageEnum;
import com.yeejoin.amos.boot.module.ugp.api.Enum.VerifyEnum;
import com.yeejoin.amos.boot.module.ugp.api.Enum.VerifyTypeEnum;

import com.yeejoin.amos.boot.module.ugp.api.dto.*;
import com.yeejoin.amos.boot.module.ugp.api.entity.QualityProblem;
import com.yeejoin.amos.boot.module.ugp.api.entity.Verify;
import com.yeejoin.amos.boot.module.ugp.api.entity.Weld;
import com.yeejoin.amos.boot.module.ugp.api.mapper.VerifyMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.WeldMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IVerifyService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.*;

/**
 * 智能监检管理表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class VerifyServiceImpl extends BaseService<VerifyDto,Verify,VerifyMapper> implements IVerifyService {
    @Autowired
    InstallNoticeServiceImpl installNoticeService;
    @Autowired
    WeldServiceImpl weldService;
    @Autowired
    WeldMapper weldMapper;
    @Autowired
    OrgServiceImpl orgService;

    @Autowired
    VerifyMapper verifyMapper;

    @Autowired
    QualityProblemServiceImpl qualityProblemService;
    /**
     * 分页查询
     */
    public Page<VerifyDto> queryForVerifyPage(Page<VerifyDto> page)   {
        return this.queryForPage(page, null, false);
    }
    /**
     * 列表查询 示例
     */
    public List<VerifyDto> queryForVerifyList()   {
        return this.queryForList("" , false);
    }







    /**  cpp
     * 智能监检共用查询方法
     * stage 阶段
     * page 分页
     */
    public Page<SmartListDto> commonality(String stage,Page<SmartListDto> page,SmartListDto smartListDto){
        List<Verify> verifyList = verifyMapper.commonality(stage,smartListDto);
        List<SmartListDto> dtoList =new ArrayList<>();
        //进入焊前
        if (verifyList !=null && verifyList.size() !=0){

            for (Verify verify : verifyList) {

                SmartListDto dto = new SmartListDto( );
                dto.setSequenceNbr(verify.getSequenceNbr());//智能监检表id
                dto.setProjectId(verify.getProjectId());  //项目id
                dto.setName(verify.getProject().getName());//项目名称
                dto.setProjectCode(verify.getProject().getCode());//项目编号
                String status = verify.getStatus( );
                if (status.equals("1")) {
                    dto.setStatus(VerifyEnum.已通过.getName());//检验状态
                    dto.setPeopleStatus("合格期内");//持证状态
                }
                if (status.equals("0")) {
                    dto.setStatus(VerifyEnum.未通过.getName());//检验状态
                    dto.setPeopleStatus("超期未检");//持证状态
                }

                dto.setType(verify.getType());//检验方式
                dto.setSubmitTime(verify.getSubmitTime());//交检日期
                dto.setVerifyTime(verify.getVerifyTime());//检验时间
                String stage1 = verify.getStage( );//检验检测阶段
                Map<String, String> map = StageEnum.getStatusByVerifyNameMap;
                for (String key:map.keySet()){
                    if (key.equals(stage1)) {
                        dto.setStage(map.get(key).toString());//将阶段赋值
                    }
                }

                String targetInfo = verify.getTargetInfo();//app上传数据
                Map mapInfo = JSON.parseObject(targetInfo, Map.class);
                for (Object o:mapInfo.keySet()){
                    if (o.toString().equals("code")) {
                        //获取焊口编号
                        String code = (String)mapInfo.get(o.toString( ));
                        dto.setCode(code);

                    }

                    if (o.toString().equals("peopleLocation")) {
                        //获取焊接定位信息
                        String peopleLocation = (String)mapInfo.get(o.toString( ));
                        dto.setPeopleLocation(peopleLocation);
                    }
                    if (o.toString().equals("userId")) {
                        //获取焊工信息
                        String userId = (String)mapInfo.get(o.toString( ));
                        OrgUsr orgUsr = orgService.getOrgUsrById(userId);

                        dto.setPeopleName(orgUsr.getBizOrgName());//焊工姓名
                        dto.setPeopleName(orgUsr.getCode());//焊工编号

                    }
                }

                dtoList.add(dto);
            }
        }
        page.setRecords(dtoList);
        page.setTotal(dtoList.size());

        return page ;
    }

    /**  cpp
     * 智能监检校验数据    人员 设备 管材
     * @param dto
     * @return
     */
    private static final String TYPE="智能检验";
    public String checks(AcceptDto dto) {


        if (dto == null) {
            return "未上传数据,请上传";
        }
        Verify verify = new Verify( );
        //获取公共属性信息
        Long projectId = dto.getProjectId( );//项目id
        String code = dto.getCode( );//焊口编号
        String peopleLocation = dto.getPeopleLocation( );//焊接定位信息
        String stage = dto.getStage( ); //阶段检验
        //获取当前校验时间
        Date time = new Date();


        //人员
        if (stage.equals(StageEnum.焊前人员.getVerifyName())&&dto.getPeoplePhoto() !=null && !dto.getPeoplePhoto().equals("")) {

            //获取焊接人员校验信息
            String peoplePhoto = dto.getPeoplePhoto( ); //人脸识别图片信息
            String userId = dto.getUserId( );//人员id

            HashMap<String, String> map = new HashMap<>( );
            map.put("peoplePhoto",peoplePhoto);
            map.put("code",code);
            map.put("peopleLocation",peopleLocation);
            map.put("userId",userId);
            String  targetInfo= JSON.toJSONString(map, SerializerFeature.WriteMapNullValue); //焊口编号 人脸识别图片信息 焊接定位信息 人员id

            verify.setSequenceNbr(new Date().getTime());
            verify.setProjectId(projectId);

            verify.setStage(StageEnum.焊前人员.getStage()); //阶段
            verify.setType(TYPE);
            verify.setTargetInfo(targetInfo);
            verify.setVerifyTime(time);

            //数据校验

            Boolean falg =false;  /**假设*/






            if (!falg) {
              /*  //校验不通过，存入校验信息，
                verify.setStatus(VerifyEnum.未通过.getStatus());
                try {
                    int insert = verifyMapper.insert(verify);
                } catch (Exception e) {
                    e.printStackTrace();
                }
                //将出现问题的哪一个阶段存入tz_ugp_quality_problem表中,返回失败
                QualityProblem qualityProblem = new QualityProblem();
                qualityProblem.setSequenceNbr(new Date().getTime());
                qualityProblem.setProjectId(projectId);
                //随机生成四位数
                String s = String.valueOf((int) ((Math.random( ) * 9 + 1) * 1000));
                qualityProblem.setCode(code+"-WT"+s);
                qualityProblem.setGenerateStage(stage);
                qualityProblem.setProblemDescribe(stage+"不通过");
                qualityProblem.setStageVerifyId(verify.getSequenceNbr());
                qualityProblemService.save(qualityProblem);
                return VerifyEnum.未通过.getName();*/
                this.addFailData(verify,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }

            //校验通过

            /*//这个是判断过后需要存的状态
            verify.setStatus(VerifyEnum.已通过.getStatus());
            try {
                //智能监检管理表添加数据
                int insert = verifyMapper.insert(verify);
            } catch (Exception e) {
                e.printStackTrace( );
            }
            //焊口表存更改状态
            Weld weld = weldMapper.getWeldByCodeAndProjectId(code, projectId);
            weld.setSuperInspecStatus(stage);
            LambdaQueryWrapper<Weld> wrapper = new LambdaQueryWrapper<>( );
            wrapper.eq(Weld::getCode ,weld.getCode());
            weldMapper.update(weld,wrapper);*/
            this.addSuccessData(verify);


        }

        //设备
        if (stage.equals(StageEnum.焊前设备.getVerifyName())&&dto.getFacilityPhoto() !=null && !dto.getFacilityPhoto().equals("")){
            //获取校验设备信息
            String facilityId = dto.getFacilityId( ); //设备id
            String calibrationStatus = dto.getCalibrationStatus( );//检定状态
            String facilityPhoto = dto.getFacilityPhoto( );//设备图片
            HashMap<String, String> mapfacilty = new HashMap<>( );
            mapfacilty.put("code",code);//焊口编号
            mapfacilty.put("peopleLocation",peopleLocation);//焊接定位信息
            mapfacilty.put("calibrationStatus",calibrationStatus);
            mapfacilty.put("facilityPhoto",facilityPhoto);
            mapfacilty.put("facilityId",facilityId);
            String  targetInfo= JSON.toJSONString(mapfacilty, SerializerFeature.WriteMapNullValue);
            verify.setSequenceNbr(new Date().getTime());//主键
            verify.setProjectId(projectId);
            verify.setStage(StageEnum.焊前设备.getStage());
            verify.setTargetInfo(targetInfo);
            verify.setType(TYPE);
            verify.setVerifyTime(time);


            //数据校验

            Boolean flag =false;




            if (!flag) {
                //校验不通过
                this.addFailData(verify,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            this.addSuccessData(verify);
        }




        //管材
        if (stage.equals(StageEnum.焊前管材质量.getVerifyName())&&dto.getMaterialPhoto() !=null && !dto.getMaterialPhoto().equals("")){

            String materialId = dto.getMaterialId( ); //管材id
            String materialPhoto = dto.getMaterialPhoto( );//管材图片信息

            HashMap<String, String> mapMaterial = new HashMap<>( );
            mapMaterial.put("code",code);
            mapMaterial.put("materialId",materialId);
            mapMaterial.put("materialPhoto",materialPhoto);
            mapMaterial.put("peopleLocation",peopleLocation);
            String  targetInfo= JSON.toJSONString(mapMaterial, SerializerFeature.WriteMapNullValue);
            verify.setTargetInfo(targetInfo);
            verify.setSequenceNbr(new Date().getTime());
            verify.setStage(StageEnum.焊前管材质量.getStage());
            verify.setType(TYPE);
            verify.setVerifyTime(time);
            verify.setProjectId(projectId);


            //数据校验

            MyPqr pqr = new MyPqr( );
            pqr.setCombox_type("高于上转变温度进行焊后热处理(如正火)");
            pqr.setMaterial_a_thickness("1.4");
            pqr.setMaterial_b_thickness("5");
            pqr.setIf_bend("lateral_bending");


            MyWps wps = new MyWps( );
            wps.setMaterial_a_thickness("1.5");
            wps.setMaterial_b_thickness("1.4");
            HashMap<String, String> stringStringHashMap = new TestWeldingRules( ).droolsTest(pqr, wps);
            Boolean flag =false;
            if (!flag) {
                //不通过, 添加数据并返回未通过结果
                this.addFailData(verify,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }

            //校验通过
            this.addSuccessData(verify);
        }
        return VerifyEnum.已通过.getName();

    }


    /**  cpp
     * 校验失败需要添加的数据
     * @param verify
     * @param qualityProblem
     */
    public void addFailData(Verify verify,QualityProblem qualityProblem){
        //校验不通过，存入校验信息，
        verify.setStatus(VerifyEnum.未通过.getStatus());
        try {
            //智能监检管理表添加数据
            int insert = verifyMapper.insert(verify);
        } catch (Exception e) {
            e.printStackTrace();
        }
        //
        //质量问题表添加数据
        qualityProblem.setSequenceNbr(new Date().getTime());
        qualityProblem.setProjectId(verify.getProjectId());
        //随机生成四位数
        String s = String.valueOf((int) ((Math.random( ) * 9 + 1) * 1000));
        String targetInfo = verify.getTargetInfo( );
        Map map = JSON.parseObject(targetInfo, Map.class);

        for (Object o:map.keySet()){
            if (o.toString().equals("code")) {
                String code = (String) map.get(o.toString( ));
                qualityProblem.setCode(code+"-WT"+s);//获取焊口编码
            }

        }

        qualityProblem.setGenerateStage(verify.getStage());
        qualityProblem.setProblemDescribe(verify.getStage()+"不通过");
        qualityProblem.setStageVerifyId(verify.getSequenceNbr());
        qualityProblemService.save(qualityProblem);

    }

    /**   cpp
     * 校验成功需要添加的数据
     * @param verify
     * @param
     */
    public void addSuccessData(Verify verify){

        //效验通过状态
        verify.setStatus(VerifyEnum.已通过.getStatus());
        try {
            //智能监检管理表添加数据
            int insert = verifyMapper.insert(verify);
        } catch (Exception e) {
            e.printStackTrace( );
        }

        //焊口表存更改状态
        String targetInfo = verify.getTargetInfo( );
        String code =null;
        Map map = JSON.parseObject(targetInfo, Map.class);
        for (Object o:map.keySet()){
            if (o.toString().equals("code")) {
                code=(String) map.get(o.toString( ));

            }

        }
        Weld weld = weldMapper.getWeldByCodeAndProjectId(code, verify.getProjectId());
        if (weld != null) {

            //判断是哪一个阶段
            String stage = verify.getStage( );
            Map<String, String> mapEnum = StageEnum.getNameByNameMap;
            for (String s:mapEnum.keySet()){
                if (stage.equals(s)) {
                    String name = mapEnum.get(s);//获取监检状态
                    weld.setSuperInspecStatus(name);
                }
            }

            LambdaQueryWrapper<Weld> wrapper = new LambdaQueryWrapper<>( );
            wrapper.eq(Weld::getCode ,weld.getCode()).
                    eq(Weld::getProjectId,weld.getProjectId());
            weldMapper.update(weld,wrapper);

        }


    }











    private String 效验状态 = "已存在";

    private final String 问题编码="-WT";

    /**
     * 公共效验接口
     */
    public String effect(JSONObject jsonObject,Integer 效验数量,Boolean i) {
//        String 效验状态 = "已存在";
        Verify verify = new Verify();
        //添加筛选条件
        LambdaQueryWrapper<Verify> wrapper = new LambdaQueryWrapper<>();
        //获取target_info
        JSONObject targetInfo = jsonObject.getJSONObject("target_info");
        String code = targetInfo.getString("code");
        //筛选出本焊口监检数
        wrapper.eq(Verify::getCode, code);
        //改焊口焊前数据
        Integer verifyCount = verifyMapper.selectCount(wrapper);
        if (verifyCount == 效验数量) {
            wrapper.eq(Verify::getStatus, VerifyEnum.已通过.getStatus());
            //该焊口焊前效验通过数据
            Integer integer = verifyMapper.selectCount(wrapper);
            //判断入库数量
            if (integer == 效验数量) {

                verify.setProjectId(jsonObject.getLong("projectId"));
                verify.setCode(jsonObject.getString("code"));
                verify.setTargetInfo(jsonObject.getString("target_info"));
                verify.setSubmitTime(new Date());
                verify.setVerifyTime(new Date());
                verify.setType(VerifyTypeEnum.智能检验.getStatus());
                //获取操作阶段
                String stage = targetInfo.getString("stage");
                verify.setStage(stage);
                //获取效验接口
                if (i) {
                    verify.setStatus(VerifyEnum.已通过.getStatus());
                    //添加筛选条件
                    LambdaQueryWrapper<Weld> wrapperWeld = new LambdaQueryWrapper<>();
                    wrapperWeld.eq(Weld::getCode, jsonObject.getString("code"));
                    Weld weld = weldMapper.selectOne(wrapperWeld);
                    weld.setSuperInspecStatus(stage);

                    weldService.updateById(weld);

                    效验状态 = "已通过";
                    this.save(verify);
                } else {
                    int math= (int) ((Math.random() * 9 + 1)*1000);
                    verify.setStatus(VerifyEnum.未通过.getStatus());
                    this.save(verify);
                    LambdaQueryWrapper<Verify> wrapperVerify=new LambdaQueryWrapper<>();
                    wrapperVerify.eq(Verify::getCode,jsonObject.getString("code"));
                    wrapperVerify.eq(Verify::getStage,stage);
                    Verify verifyId = verifyMapper.selectOne(wrapperVerify);
                    QualityProblem qualityProblem = new QualityProblem();
                    //生成问题编码
                    qualityProblem.setStageVerifyId(verifyId.getSequenceNbr());
                    qualityProblem.setCode(jsonObject.getString("code")+问题编码+math);
                    qualityProblem.setProjectId(jsonObject.getLong("projectId"));
                    qualityProblem.setGenerateStage(stage);
                    qualityProblem.setSubmitDate(new Date());
                    qualityProblemService.save(qualityProblem);
                    效验状态 = "未通过";

                }

            }



        }

        return 效验状态;

    }

    /**
     * 焊接工艺效验
     */

    private final Integer 焊前效验数量 = 3;

    public String weldEffect(JSONObject jsonObject) {



//        Verify verify = new Verify();
//        //添加筛选条件
//        LambdaQueryWrapper<Verify> wrapper = new LambdaQueryWrapper<>();
//        JSONObject targetInfo = jsonObject.getJSONObject("target_info");
//        String code = targetInfo.getString("code");
//        //筛选出本焊口监检数
//        wrapper.eq(Verify::getCode, code);
//        //改焊口焊前数据
//        Integer verifyCount = verifyMapper.selectCount(wrapper);
//        if (verifyCount == 焊前效验数量) {
//            wrapper.eq(Verify::getStatus, VerifyEnum.已通过.getStatus());
//            //该焊口焊前效验通过数据
//            Integer integer = verifyMapper.selectCount(wrapper);
//            //判断前三次已经入库
//            if (integer == 焊前效验数量) {
//                //获取效验接口
//                Boolean i = false;
//
//
//                verify.setProjectId(jsonObject.getLong("projectId"));
//                verify.setCode(jsonObject.getString("code"));
//                verify.setTargetInfo(jsonObject.getString("target_info"));
//                verify.setSubmitTime(new Date());
//                verify.setStage(StageEnum.焊接工艺.getStage());
//                if (i) {
//                    verify.setStatus(VerifyEnum.已通过.getStatus());
//                    //添加筛选条件
//                    LambdaQueryWrapper<Weld> wrapperWeld = new LambdaQueryWrapper<>();
//                    wrapperWeld.eq(Weld::getCode, jsonObject.getString("code"));
//                    Weld weld = weldMapper.selectOne(wrapperWeld);
//                    weld.setSuperInspecStatus(StageEnum.焊接工艺.getStage());
//
//                    weldService.updateById(weld);
//
//                    效验状态 = "已通过";
//                    this.save(verify);
//                } else {
//                    int math= (int) (Math.random()*10000);
//                    verify.setStatus(VerifyEnum.未通过.getStatus());
//                    this.save(verify);
//                    LambdaQueryWrapper<Verify> wrapperVerify=new LambdaQueryWrapper<>();
//                    wrapperVerify.eq(Verify::getCode,jsonObject.getString("code"));
//                    wrapperVerify.eq(Verify::getStage,StageEnum.焊接工艺.getStage());
//                    Verify verifyId = verifyMapper.selectOne(wrapperVerify);
//                    QualityProblem qualityProblem = new QualityProblem();
//                    //生成问题编码
//                    qualityProblem.setStageVerifyId(verifyId.getSequenceNbr());
//                    qualityProblem.setCode(jsonObject.getString("code")+问题编码+math);
//                    qualityProblem.setProjectId(jsonObject.getLong("projectId"));
//                    qualityProblem.setGenerateStage(StageEnum.焊接工艺.getStage());
//                    qualityProblem.setSubmitDate(new Date());
//                    qualityProblemService.save(qualityProblem);
//                    效验状态 = "未通过";
//
//                }
//
//            }
//
//
//
//        }
//
        return   effect(jsonObject,焊前效验数量,true);

    }
    /**
     * 管道耐压效验
     */
    private final Integer 管道耐压前效验数量 = 4;
    public String materialEffect(JSONObject jsonObject){


//        Verify verify = new Verify();
//        //添加筛选条件
//        LambdaQueryWrapper<Verify> wrapper = new LambdaQueryWrapper<>();
//        //筛选出本焊口监检数
//        wrapper.eq(Verify::getCode, jsonObject.getString("code"));
//        //该焊口焊前数据
//        Integer verifyCount = verifyMapper.selectCount(wrapper);
//        if (verifyCount == 管道耐压前效验数量) {
//            wrapper.eq(Verify::getStatus, VerifyEnum.已通过.getStatus());
//            //该焊口焊前效验通过数据
//            Integer integer = verifyMapper.selectCount(wrapper);
//            //判断前四次已经入库
//            if (integer == 管道耐压前效验数量) {
//                //获取效验接口
//                Boolean i = true;
//
//
//                verify.setProjectId(jsonObject.getLong("projectId"));
//                verify.setCode(jsonObject.getString("code"));
//                verify.setTargetInfo(jsonObject.getString("target_info"));
//                verify.setSubmitTime(new Date());
//                verify.setStage(StageEnum.焊前管材质量.getStage());
//                if (i) {
//                    verify.setStatus(VerifyEnum.已通过.getStatus());
//                    //添加筛选条件
//                    LambdaQueryWrapper<Weld> wrapperWeld = new LambdaQueryWrapper<>();
//                    wrapperWeld.eq(Weld::getCode, jsonObject.getString("code"));
//                    Weld weld = weldMapper.selectOne(wrapperWeld);
//                    weld.setSuperInspecStatus(StageEnum.焊前管材质量.getStage());
//
//                    weldService.updateById(weld);
//
//                    效验状态 = "已通过";
//                } else {
//                    int math= (int) (Math.random()*10000);
//                    verify.setStatus(VerifyEnum.未通过.getStatus());
//                    this.save(verify);
//                    LambdaQueryWrapper<Verify> wrapperVerify=new LambdaQueryWrapper<>();
//                    wrapperVerify.eq(Verify::getCode,jsonObject.getString("code"));
//                    wrapperVerify.eq(Verify::getStage,StageEnum.焊前管材质量.getStage());
//                    Verify verifyId = verifyMapper.selectOne(wrapperVerify);
//                    QualityProblem qualityProblem = new QualityProblem();
//                    //生成问题编码
//                    qualityProblem.setStageVerifyId(verifyId.getSequenceNbr());
//                    qualityProblem.setCode(jsonObject.getString("code")+问题编码+math);
//                    qualityProblem.setProjectId(jsonObject.getLong("projectId"));
//                    qualityProblem.setGenerateStage(StageEnum.焊前管材质量.getStage());
//                    qualityProblem.setSubmitDate(new Date());
//                    qualityProblemService.save(qualityProblem);
//                    效验状态 = "未通过";
//
//                }
//
//            }
//
//            save(verify);
//
//        }
//
        return   effect(jsonObject,管道耐压前效验数量,true);
    }
    /**
     * 敷设效验
     */
    private final Integer 敷设效验数量 = 5;
    public String layEffect(JSONObject jsonObject){


//
//        Verify verify = new Verify();
//        //添加筛选条件
//        LambdaQueryWrapper<Verify> wrapper = new LambdaQueryWrapper<>();
//        //筛选出本焊口监检数
//        wrapper.eq(Verify::getCode, jsonObject.getString("code"));
//        //该焊口焊前数据
//        Integer verifyCount = verifyMapper.selectCount(wrapper);
//        if (verifyCount == 管道耐压前效验数量) {
//            wrapper.eq(Verify::getStatus, VerifyEnum.已通过.getStatus());
//            //该焊口焊前效验通过数据
//            Integer integer = verifyMapper.selectCount(wrapper);
//            //判断前四次已经入库
//            if (integer == 管道耐压前效验数量) {
//                //获取效验接口
//                Boolean i = true;
//
//
//                verify.setProjectId(jsonObject.getLong("projectId"));
//                verify.setCode(jsonObject.getString("code"));
//                verify.setTargetInfo(jsonObject.getString("target_info"));
//                verify.setSubmitTime(new Date());
//                verify.setStage(StageEnum.敷设质量.getStage());
//                if (i) {
//                    verify.setStatus(VerifyEnum.已通过.getStatus());
//                    //添加筛选条件
//                    LambdaQueryWrapper<Weld> wrapperWeld = new LambdaQueryWrapper<>();
//                    wrapperWeld.eq(Weld::getCode, jsonObject.getString("code"));
//                    Weld weld = weldMapper.selectOne(wrapperWeld);
//                    weld.setSuperInspecStatus(StageEnum.敷设质量.getStage());
//
//                    weldService.updateById(weld);
//
//                    效验状态 = "已通过";
//                } else {
//                    int math= (int) (Math.random()*10000);
//                    verify.setStatus(VerifyEnum.未通过.getStatus());
//                    this.save(verify);
//                    LambdaQueryWrapper<Verify> wrapperVerify=new LambdaQueryWrapper<>();
//                    wrapperVerify.eq(Verify::getCode,jsonObject.getString("code"));
//                    wrapperVerify.eq(Verify::getStage,StageEnum.敷设质量.getStage());
//                    Verify verifyId = verifyMapper.selectOne(wrapperVerify);
//                    QualityProblem qualityProblem = new QualityProblem();
//                    //生成问题编码
//                    qualityProblem.setStageVerifyId(verifyId.getSequenceNbr());
//                    qualityProblem.setCode(jsonObject.getString("code")+问题编码+math);
//                    qualityProblem.setProjectId(jsonObject.getLong("projectId"));
//                    qualityProblem.setGenerateStage(StageEnum.敷设质量.getStage());
//                    qualityProblem.setSubmitDate(new Date());
//                    qualityProblemService.save(qualityProblem);
//                    效验状态 = "未通过";
//
//                }
//
//            }
//
//            save(verify);
//
//        }

        return  effect(jsonObject,敷设效验数量,false);
    }

    /**
     * 定位效验
     */
    private final Integer 定位效验数量 = 6;
    public String positionEffect(JSONObject jsonObject){



//        Verify verify = new Verify();
//        //添加筛选条件
//        LambdaQueryWrapper<Verify> wrapper = new LambdaQueryWrapper<>();
//        //筛选出本焊口监检数
//        wrapper.eq(Verify::getCode, jsonObject.getString("code"));
//        //该焊口焊前数据
//        Integer verifyCount = verifyMapper.selectCount(wrapper);
//        if (verifyCount == 管道耐压前效验数量) {
//            wrapper.eq(Verify::getStatus, VerifyEnum.已通过.getStatus());
//            //该焊口焊前效验通过数据
//            Integer integer = verifyMapper.selectCount(wrapper);
//            //判断前四次已经入库
//            if (integer == 管道耐压前效验数量) {
//                //获取效验接口
//                Boolean i = true;
//
//
//                verify.setProjectId(jsonObject.getLong("projectId"));
//                verify.setCode(jsonObject.getString("code"));
//                verify.setTargetInfo(jsonObject.getString("target_info"));
//                verify.setSubmitTime(new Date());
//                verify.setStage(StageEnum.定位.getStage());
//                if (i) {
//                    verify.setStatus(VerifyEnum.已通过.getStatus());
//                    //添加筛选条件
//                    LambdaQueryWrapper<Weld> wrapperWeld = new LambdaQueryWrapper<>();
//                    wrapperWeld.eq(Weld::getCode, jsonObject.getString("code"));
//
//                    Weld weld = weldMapper.selectOne(wrapperWeld);
//                    weld.setSuperInspecStatus(StageEnum.定位.getStage());
//
//                    weldService.updateById(weld);
//
//                    效验状态 = "已通过";
//                } else {
//                    int math= (int) (Math.random()*10000);
//                    verify.setStatus(VerifyEnum.未通过.getStatus());
//                    this.save(verify);
//                    LambdaQueryWrapper<Verify> wrapperVerify=new LambdaQueryWrapper<>();
//                    wrapperVerify.eq(Verify::getCode,jsonObject.getString("code"));
//                    wrapperVerify.eq(Verify::getStage,StageEnum.定位.getStage());
//                    Verify verifyId = verifyMapper.selectOne(wrapperVerify);
//                    QualityProblem qualityProblem = new QualityProblem();
//                    //生成问题编码
//                    qualityProblem.setStageVerifyId(verifyId.getSequenceNbr());
//                    qualityProblem.setCode(jsonObject.getString("code")+问题编码+math);
//                    qualityProblem.setProjectId(jsonObject.getLong("projectId"));
//                    qualityProblem.setGenerateStage(StageEnum.定位.getStage());
//                    qualityProblem.setSubmitDate(new Date());
//                    qualityProblemService.save(qualityProblem);
//                    效验状态 = "未通过";
//
//                }
//
//            }
//
//            save(verify);
//
//        }

        return effect(jsonObject,定位效验数量,true);
    }


    /**
     * 测试
     * @param args
     */
    public static void main(String[] args) {
        MyPqr pqr = new MyPqr( );
        pqr.setCombox_type("高于上转变温度进行焊后热处理(如正火)");
        pqr.setMaterial_a_thickness("1.4");//厚度
        pqr.setMaterial_b_thickness("5");//厚度
        pqr.setIf_bend("lateral_bending"); //弯度


        MyWps wps = new MyWps( );
        wps.setMaterial_a_thickness("1.5");
        wps.setMaterial_b_thickness("1.4");
        HashMap<String, String> stringStringHashMap = new TestWeldingRules( ).droolsTest(pqr, wps);
        System.out.println(stringStringHashMap );

    }

}