package com.yeejoin.amos.api.openapi.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.yeejoin.amos.api.openapi.converter.*;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;


@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "西安数据对接-设备信息", description = "西安数据对接-设备信息")
public class XiAnEquipInfoExcelDto extends BaseDto {

    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    //----------------------------------------------------------------------基本信息

    @ApiModelProperty(value = "设备种类")
    @ExcelProperty(value = "设备种类", converter = EquListConverter.class)
    @NotBlank(message = "设备种类不能为空")
    private String equList;

    @ApiModelProperty(value = "设备类别")
    @ExcelProperty(value = "设备类别", converter = EquCategoryConverter.class)
    @NotBlank(message = "设备类别不能为空")
    private String equCategory;

    @ApiModelProperty(value = "设备品种")
    @ExcelProperty(value = "设备品种", converter = EquDefineConverter.class)
    private String equDefine;

    @ApiModelProperty(value = "单位内编号")
    @ExcelProperty(value = "单位内编号")
    @NotBlank(message = "单位内编号不能为空")
    private String useInnerCode;

    @ApiModelProperty(value = "产品名称")
    @ExcelProperty(value = "产品名称")
    @NotBlank(message = "产品名称不能为空")
    private String productName;

    @ApiModelProperty(value = "设备型号")
    @ExcelProperty(value = "设备型号")
    @NotBlank(message = "设备型号不能为空")
    private String equType;

    @ApiModelProperty(value = "设备总价值（万元）")
    @ExcelProperty(value = "设备总价值（万元）")
    private String equPrice;


    @ApiModelProperty(value = "有无设备代码")
    @ExcelProperty(value = "有无设备代码", converter = EquCodeTypeConverter.class)
    @NotBlank(message = "有无设备代码不能为空")
    private String equCodeType;

    @ApiModelProperty(value = "设备代码")
    @ExcelProperty(value = "设备代码")
    private String equCode;

    @ApiModelProperty(value = "工程（装置）名称")
    @ExcelProperty(value = "工程（装置）名称")
    private String projectContraption;

    @ApiModelProperty(value = "是否球罐")
    @ExcelProperty(value = "是否球罐", converter = VehicleCylinderConverter.class)
    private String whetherSphericalTank;

    @ApiModelProperty(value = "是否撬装式压力容器")
    @ExcelProperty(value = "是否撬装式压力容器")
    private String whetherSkidMountedPressureVessel;

    @ApiModelProperty(value = "是否车用气瓶")
    @ExcelProperty(value = "是否车用气瓶", converter = VehicleCylinderConverter.class)
    @NotBlank(message = "是否车用气瓶不能为空")
    private String whetherVehicleCylinder;

    @ApiModelProperty(value = "信息化管理情况")
    @ExcelProperty(value = "信息化管理情况", converter = InformationSituationConverter.class)
    private String informationSituation;

    @ApiModelProperty(value = "二维码或者电子标签编号")
    @ExcelProperty(value = "二维码或者电子标签编号")
    private String informationManageCode;

    //-----------------------------------------------------------------------使用信息

    @ApiModelProperty(value = "使用单位统一社会信用代码")
    @ExcelProperty(value = "使用单位统一社会信用代码")
    @NotBlank(message = "使用单位统一社会信用代码不能为空")
    private String useUnitCode;

    @ApiModelProperty(value = "使用单位名称")
    @ExcelProperty(value = "使用单位名称")
    @NotBlank(message = "使用单位名称不能为空")
    private String useUnit;

    //-----------------------------------------------------------------------设计信息

    @ApiModelProperty(value = "设计单位统一社会信用代码")
    @ExcelProperty(value = "设计单位统一社会信用代码")
    @NotBlank(message = "设计单位统一社会信用代码不能为空")
    private String designUnitCreditCode;

    @ApiModelProperty(value = "设计单位名称")
    @ExcelProperty(value = "设计单位名称")
    @NotBlank(message = "设计单位名称不能为空")
    private String designUnitName;

    @ApiModelProperty(value = "设计许可编号")
    @ExcelProperty(value = "设计许可编号")
    private String designLicenseNum;

    @ApiModelProperty(value = "设计使用年限(年)")
    @ExcelProperty(value = "设计使用年限(年)")
    @NotBlank(message = "设计使用年限(年)不能为空")
    private String designUseDate;

    @ApiModelProperty(value = "设计日期")
    @ExcelProperty(value = "设计日期")
    @DateTimeFormat("yyyy-MM-dd")
    @NotBlank(message = "设计日期不能为空")
    private String designDate;

    @ApiModelProperty(value = "总图图号")
    @ExcelProperty(value = "总图图号")
    private String drawingDo;

    @ApiModelProperty(value = "设计文件鉴定单位")
    @ExcelProperty(value = "设计文件鉴定单位")
    private String appraisalUnit;

    @ApiModelProperty(value = "设计文件鉴定日期")
    @ExcelProperty(value = "设计文件鉴定日期")
    @DateTimeFormat("yyyy-MM-dd")
    private String appraisalDate;

    //---------------------------------------------------------------制造信息

    @ApiModelProperty(value = "制造单位统一社会信用代码")
    @ExcelProperty(value = "制造单位统一社会信用代码")
    @NotBlank(message = "制造单位统一社会信用代码不能为空")
    private String produceUnitCreditCode;

    @ApiModelProperty(value = "制造单位名称")
    @ExcelProperty(value = "制造单位名称")
    @NotBlank(message = "制造单位名称不能为空")
    private String produceUnitName;

    @ApiModelProperty(value = "制造许可编号")
    @ExcelProperty(value = "制造许可编号")
    @NotBlank(message = "制造许可编号不能为空")
    private String produceLicenseNum;

    @ApiModelProperty(value = "出厂编号/产品编码")
    @ExcelProperty(value = "出厂编号/产品编码")
    @NotBlank(message = "出厂编号/产品编码不能为空")
    private String factoryNum;

    @ApiModelProperty(value = "制造日期")
    @ExcelProperty(value = "制造日期")
    @NotBlank(message = "制造日期不能为空")
    @DateTimeFormat("yyyy-MM-dd")
    private String produceDate;

    @ApiModelProperty(value = "是否进口")
    @ExcelProperty(value = "是否进口", converter = ImportedConverter.class)
    private String imported;

    @ApiModelProperty(value = "制造国")
    @ExcelProperty(value = "制造国")
    private String produceCountry;

    //--------------------------------------------------------起重机械----技术参数
    @ExcelProperty(value = "额定起重量(t)")
    @ApiModelProperty(value = "额定起重量(t)")
    private String ratedLiftingCapacity;

    @ExcelProperty(value = "悬臂长度(m)")
    @ApiModelProperty(value = "悬臂长度(m)")
    private String cantileverLength;

    @ExcelProperty(value = "起升速度(m/min)")
    @ApiModelProperty(value = "起升速度(m/min)")
    private String liftingSpeed;

    @ExcelProperty(value = "大车运行速度(m/min)")
    @ApiModelProperty(value = "大车运行速度(m/min)")
    private String bigcarRunSpeed;

    @ExcelProperty(value = "起升高度（m）")
    @ApiModelProperty(value = "起升高度（m）")
    private String liftingHeight;

    @ExcelProperty(value = "工作级别", converter = DictParamsConverter.class)
    @ApiModelProperty(value = "工作级别")
    private String workLevel;

    @ExcelProperty(value = "燃爆物质")
    @ApiModelProperty(value = "燃爆物质")
    private String explosiveSubstance;

    @ExcelProperty(value = "区域防爆等级", converter = DictParamsConverter.class)
    @ApiModelProperty(value = "区域防爆等级")
    private String explosionProofGrade;

    @ExcelProperty(value = "小车运行速度(m/min)")
    @ApiModelProperty(value = "小车运行速度(m/min)")
    private String smallcarrunSpeed;

    @ExcelProperty(value = "额定起重力矩(KN.m)")
    @ApiModelProperty(value = "额定起重力矩(KN.m)")
    private String ratedLiftingTorque;

    @ExcelProperty(value = "工作幅度(m)")
    @ApiModelProperty(value = "工作幅度(m)")
    private String spanWorkingRange;

//    @ExcelProperty(value = "跨度(m)")
//    @ApiModelProperty(value = "跨度(m)")
//    private String spanWorkingRange;

    @ExcelProperty(value = "变幅速度(m/min)")
    @ApiModelProperty(value = "变幅速度(m/min)")
    private String derrickingSpeed;

    @ExcelProperty(value = "监检结束高度(m)")
    @ApiModelProperty(value = "监检结束高度(m)")
    private String checkFinshedHeight;

    @ExcelProperty(value = "最大起重量(t)")
    @ApiModelProperty(value = "最大起重量(t)")
    private String maxLiftingCapacity;

    @ExcelProperty(value = "最大起重力矩(KN.m)")
    @ApiModelProperty(value = "最大起重力矩(KN.m)")
    private String maxLiftingTorque;

    @ExcelProperty(value = "运行速度(m/min)")
    @ApiModelProperty(value = "运行速度(m/min)")
    private String runningSpeed;

    @ExcelProperty(value = "额定载重量(Kg)")
    @ApiModelProperty(value = "额定载重量(Kg)")
    private String ratedLoadCapacity;

    @ExcelProperty(value = "额定乘员数（人）")
    @ApiModelProperty(value = "额定乘员数（人）")
    private String ratedMembers;

    @ExcelProperty(value = "额定提升速度(m/min)")
    @ApiModelProperty(value = "额定提升速度(m/min)")
    private String ratedLiftingSpeed;

    @ExcelProperty(value = "自由端高度(m)")
    @ApiModelProperty(value = "自由端高度(m)")
    private String heightFreeEnd;

    @ExcelProperty(value = "监检结束时高度(m)")
    @ApiModelProperty(value = "监检结束时高度(m)")
    private String checkFinishedHeight;

    @ExcelProperty(value = "吊笼数量（个）")
    @ApiModelProperty(value = "吊笼数量（个）")
    private String hangingCagesNumber;

    @ExcelProperty(value = "存容量（辆）")
    @ApiModelProperty(value = "存容量（辆）")
    private String storageCapacity;

    @ExcelProperty(value = "层数（层）")
    @ApiModelProperty(value = "层数（层）")
    private String numberStorey;

    @ExcelProperty(value = "横移速度（m/min）")
    @ApiModelProperty(value = "横移速度（m/min）")
    private String ratedTraverseSpeed;

    @ExcelProperty(value = "适停车辆尺寸（宽）(m)")
    @ApiModelProperty(value = "适停车辆尺寸（宽）(m)")
    private String parkingVehicleWeight;

    @ExcelProperty(value = "升降速度（m/min）")
    @ApiModelProperty(value = "升降速度（m/min）")
    private String ratedLiftSpeed;

    @ExcelProperty(value = "单车最大（出）时间（s）")
    @ApiModelProperty(value = "单车最大（出）时间（s）")
    private String bicycleMaxExitTime;

    @ExcelProperty(value = "单车最大（进）时间（s）")
    @ApiModelProperty(value = "单车最大（进）时间（s）")
    private String bicycleMaxComeTime;

    @ExcelProperty(value = "适停车辆尺寸（长）(m)")
    @ApiModelProperty(value = "适停车辆尺寸（长）(m)")
    private String parkingVehicleLength;

    @ExcelProperty(value = "适停车辆尺寸（高）(m)")
    @ApiModelProperty(value = "适停车辆尺寸（高）(m)")
    private String parkingVehicleHeight;

    @ExcelProperty(value = "吊笼工作行程(m)")
    @ApiModelProperty(value = "吊笼工作行程(m)")
    private String workStrokeCage;

    //--------------------------------------------------------------场内机动车辆----技术参数
    @ExcelProperty(value = "发动机（行走电机）编号")
    @ApiModelProperty(value = "发动机（行走电机）编号")
    private String engineNo;

    @ExcelProperty(value = "车架（底盘）编号")
    @ApiModelProperty(value = "车架（底盘）编号")
    private String frameNo;

    @ExcelProperty(value = "额定起重量(Kg)")
    @ApiModelProperty(value = "额定起重量(Kg)")
    private String liftingCapacity;

    @ExcelProperty(value = "传动方式")
    @ApiModelProperty(value = "传动方式")
    private String transmissionMode;

    @ExcelProperty(value = "自重(Kg)")
    @ApiModelProperty(value = "自重(Kg)")
    private String weight;

    @ExcelProperty(value = "动力方式")
    @ApiModelProperty(value = "动力方式")
    private String powerMode;

    @ExcelProperty(value = "最大运行速度(km/h)")
    @ApiModelProperty(value = "最大运行速度(km/h)")
    private String maxRunningSpeed;

    @ExcelProperty(value = "空载最大起升高度(mm)")
    @ApiModelProperty(value = "空载最大起升高度(mm)")
    private String maxLiftingHeight;

    @ExcelProperty(value = "防爆气体/粉尘组别")
    @ApiModelProperty(value = "防爆气体/粉尘组别")
    private String gasGroup;

    @ExcelProperty(value = "车架结构")
    @ApiModelProperty(value = "车架结构")
    private String frameStructure;

    @ExcelProperty(value = "驾驶方式")
    @ApiModelProperty(value = "驾驶方式")
    private String drivingMode;

    @ExcelProperty(value = "空载最大运行速度（km/h）")
    @ApiModelProperty(value = "空载最大运行速度（km/h）")
    private String carryingIdlerMaxRunningSpeed;

    @ExcelProperty(value = "防爆温度组别")
    @ApiModelProperty(value = "防爆温度组别")
    private String temperatureGroup;

    @ExcelProperty(value = "防爆设备保护级别", converter = DictParamsConverter.class)
    @ApiModelProperty(value = "防爆设备保护级别")
    private String protectGrade;

    @ExcelProperty(value = "额定载客人数(人)")
    @ApiModelProperty(value = "额定载客人数(人)")
    private String passengersNumber;

    @ExcelProperty(value = "最大行驶坡度")
    @ApiModelProperty(value = "最大行驶坡度")
    private String maxDrivingSlope;

    @ExcelProperty(value = "轴距（mm）")
    @ApiModelProperty(value = "轴距（mm）")
    private String wheelBase;

    @ExcelProperty(value = "轮距（前）(mm)")
    @ApiModelProperty(value = "轮距（前）(mm)")
    private String trackWidthFront;

    @ExcelProperty(value = "观光列车每节车厢座位数(个)")
    @ApiModelProperty(value = "观光列车每节车厢座位数(个)")
    private String seatNumber;

    @ExcelProperty(value = "整车整备质量(Kg)")
    @ApiModelProperty(value = "整车整备质量(Kg)")
    private String vehicleMass;

    @ExcelProperty(value = "观光列车车厢数（节）")
    @ApiModelProperty(value = "观光列车车厢数（节）")
    private String carsNumber;

    @ExcelProperty(value = "轮距（后）（mm）")
    @ApiModelProperty(value = "轮距（后）（mm）")
    private String trackWidthBehind;

    @ExcelProperty(value = "观光列车牵引车头座位数（个）")
    @ApiModelProperty(value = "观光列车牵引车头座位数（个）")
    private String tractorSeatNumber;

    //--------------------------------------------------------------锅炉----技术参数

    @ExcelProperty(value = "设备级别", converter = DictParamsConverter.class)
    @ApiModelProperty(value = "设备级别")
    private String deviceLevel;

    @ExcelProperty(value = "额定蒸发量(热功率) (t/h(MW))")
    @ApiModelProperty(value = "额定蒸发量(热功率) (t/h(MW))")
    private String ratedEvaporationCapacityThermalPower;

    @ExcelProperty(value = "额定工作压力(MPa)")
    @ApiModelProperty(value = "额定工作压力(MPa)")
    private String ratedWorkingPressure;

    @ExcelProperty(value = "额定工作温度(℃)")
    @ApiModelProperty(value = "额定工作温度(℃)")
    private String ratedOperatingTemperature;

    @ExcelProperty(value = "设计热效率(%)")
    @ApiModelProperty(value = "设计热效率(%)")
    private String designThermalEfficiency;

    @ExcelProperty(value = "给水温度（℃）")
    @ApiModelProperty(value = "给水温度（℃）")
    private String feedwaterTemperature;

    @ExcelProperty(value = "额定出/回水(油)温度(℃)")
    @ApiModelProperty(value = "额定出/回水(油)温度(℃)")
    private String ratedOutletReturnWaterOilTemperature;

    @ExcelProperty(value = "锅炉本体水(油)容积 (L)")
    @ApiModelProperty(value = "锅炉本体水(油)容积 (L)")
    private String waterOilVolumeOfBoilerProper;

    @ExcelProperty(value = "整装锅炉本体液压试验介质/压力 (MPa)")
    @ApiModelProperty(value = "整装锅炉本体液压试验介质/压力 (MPa)")
    private String hydraulicTestMediumPressureOfPackagedBoilerBody;

    @ExcelProperty(value = "再热器进(出)口温度 (℃)")
    @ApiModelProperty(value = "再热器进(出)口温度 (℃)")
    private String inletOutletTemperatureOfReheater;

    @ExcelProperty(value = "再热器进(出)口压力 (MPa)")
    @ApiModelProperty(value = "再热器进(出)口压力 (MPa)")
    private String reheaterInletOutletPressure;

    @ExcelProperty(value = "再热蒸汽流量 (t/h)")
    @ApiModelProperty(value = "再热蒸汽流量 (t/h)")
    private String reheatSteamFlow;

    @ExcelProperty(value = "有机热载体锅炉气密试验介质/压力 (MPa)")
    @ApiModelProperty(value = "有机热载体锅炉气密试验介质/压力 (MPa)")
    private String glAirtightTest;

    @ExcelProperty(value = "燃烧方式")
    @ApiModelProperty(value = "燃烧方式")
    private String combustionMode;

    @ExcelProperty(value = "燃料（热源）种类", converter = DictParamsConverter.class)
    @ApiModelProperty(value = "燃料（热源）种类")
    private String fuelType;

    @ExcelProperty(value = "主要受压部件-名称", converter = DictParamsConverter.class)
    @ApiModelProperty(value = "主要受压部件-名称")
    private String nameOfPressureParts;

    @ExcelProperty(value = "主要受压部件-材料")
    @ApiModelProperty(value = "主要受压部件-材料")
    private String materialOfPressureParts;

    @ExcelProperty(value = "主要受压部件-壁厚(mm)")
    @ApiModelProperty(value = "主要受压部件-壁厚(mm)")
    private String wallThicknessOfPressureParts;

    @ExcelProperty(value = "主要受压部件-无损检测方法", converter = DictParamsConverter.class)
    @ApiModelProperty(value = "主要受压部件-无损检测方法")
    private String nonDestructiveTestingMethodsForPressureParts;

    @ExcelProperty(value = "主要受压部件-无损检测比例（%）")
    @ApiModelProperty(value = "主要受压部件-无损检测比例（%）")
    private String proportionOfNdtForPressureParts;

    @ExcelProperty(value = "主要受压部件-热处理温度（℃）")
    @ApiModelProperty(value = "主要受压部件-热处理温度（℃）")
    private String heatTreatmentTemperatureOfPressureParts;

    @ExcelProperty(value = "主要受压部件-热处理时间（h）")
    @ApiModelProperty(value = "主要受压部件-热处理时间（h）")
    private String heatTreatmentTimeOfPressureParts;

    @ExcelProperty(value = "主要受压部件-水（耐）压试验介质")
    @ApiModelProperty(value = "主要受压部件-水（耐）压试验介质")
    private String hydrostaticTestMedium;

    @ExcelProperty(value = "主要受压部件-水（耐）压试验压力（Mpa）")
    @ApiModelProperty(value = "主要受压部件-水（耐）压试验压力（Mpa）")
    private String hydrostaticTestPressure;

    //--------------------------------------------------------------压力容器----技术参数

    @ExcelProperty(value = "额定质量(kg)")
    @ApiModelProperty(value = "额定质量(kg)")
    private String ratedQuality;

    @ExcelProperty(value = "型号")
    @ApiModelProperty(value = "型号")
    private String modelNumber;

    @ExcelProperty(value = "外径")
    @ApiModelProperty(value = "外径")
    private String outsideDiameter;

    @ExcelProperty(value = "材料（管路）")
    @ApiModelProperty(value = "材料（管路）")
    private String piping;

    @ExcelProperty(value = "无损检测比例（管路）(％)")
    @ApiModelProperty(value = "无损检测比例（管路）(％)")
    private String glRatio;

    @ExcelProperty(value = "耐压试验压力（管路）(MPa)")
    @ApiModelProperty(value = "耐压试验压力（管路）(MPa)")
    private String glPressure;

    @ExcelProperty(value = "气密性试验压力（管路）(MPa)")
    @ApiModelProperty(value = "气密性试验压力（管路）(MPa)")
    private String glAirTightness;

    @ExcelProperty(value = "使用环境温度(℃)")
    @ApiModelProperty(value = "使用环境温度(℃)")
    private String ambientTemperature;

    @ExcelProperty(value = "壁厚")
    @ApiModelProperty(value = "壁厚")
    private String wallThickness;

    @ExcelProperty(value = "无损检测方法（气瓶）", converter = DictParamsConverter.class)
    @ApiModelProperty(value = "无损检测方法（气瓶）")
    private String qpLossless;

    @ExcelProperty(value = "无损检测比例（气瓶）(％)")
    @ApiModelProperty(value = "无损检测比例（气瓶）(％)")
    private String qpRatio;

    @ExcelProperty(value = "气密性试验压力（气瓶）(MPa)")
    @ApiModelProperty(value = "气密性试验压力（气瓶）(MPa)")
    private String qpAirTightness;

    @ExcelProperty(value = "气瓶安装位置")
    @ApiModelProperty(value = "气瓶安装位置")
    private String installationPosition;

    @ExcelProperty(value = "瓶体内含氧量(％)")
    @ApiModelProperty(value = "瓶体内含氧量(％)")
    private String oxygen;

    @ExcelProperty(value = "单瓶容积(L)")
    @ApiModelProperty(value = "单瓶容积(L)")
    private String singleBottleVolume;

    @ExcelProperty(value = "充装介质",converter = DictParamsConverter.class)
    @ApiModelProperty(value = "充装介质")
    private String chargingMedium;

    @ExcelProperty(value = "长度")
    @ApiModelProperty(value = "长度")
    private String length;

    @ExcelProperty(value = "材料（瓶体）")
    @ApiModelProperty(value = "材料（瓶体）")
    private String bottleBody;

    @ExcelProperty(value = "无损检测方法（管路）", converter = DictParamsConverter.class)
    @ApiModelProperty(value = "无损检测方法（管路）")
    private String glLossless;

    @ExcelProperty(value = "气体置换后压力(MPa)")
    @ApiModelProperty(value = "气体置换后压力(MPa)")
    private String displacementPressure;

    @ExcelProperty(value = "规格")
    @ApiModelProperty(value = "规格")
    private String specification;

    @ExcelProperty(value = "公称工作压力(MPa)")
    @ApiModelProperty(value = "公称工作压力(MPa)")
    private String nominalWorkingPressure;

    @ExcelProperty(value = "材料（端塞）")
    @ApiModelProperty(value = "材料（端塞）")
    private String endPlug;

    @ExcelProperty(value = "耐压试验压力（气瓶）(MPa)")
    @ApiModelProperty(value = "耐压试验压力（气瓶）(MPa)")
    private String qpPressure;

    @ExcelProperty(value = "热处理方式")
    @ApiModelProperty(value = "热处理方式")
    private String heatTreatmentMethod;

    @ExcelProperty(value = "热处理温度(℃)")
    @ApiModelProperty(value = "热处理温度(℃)")
    private String qpHeatTreatmentTemperature;

    @ExcelProperty(value = "容器容积(m³)")
    @ApiModelProperty(value = "容器容积(m³)")
    private String totalVolume;

    @ExcelProperty(value = "材料（封头）")
    @ApiModelProperty(value = "材料（封头）")
    private String pressureMaterialHead;

    @ExcelProperty(value = "厚度（封头）(mm)")
    @ApiModelProperty(value = "厚度（封头）(mm)")
    private String fixedHead;

    @ExcelProperty(value = "盛装介质重量(kg)")
    @ApiModelProperty(value = "盛装介质重量(kg)")
    private String mediumWeight;

    @ExcelProperty(value = "设计温度（壳程）(℃)")
    @ApiModelProperty(value = "设计温度（壳程）(℃)")
    private String temperatureShell;

    @ExcelProperty(value = "介质（壳程）")
    @ApiModelProperty(value = "介质（壳程）")
    private String mediumShell;

    @ExcelProperty(value = "介质（夹套）")
    @ApiModelProperty(value = "介质（夹套）")
    private String mediumJacket;

    @ExcelProperty(value = "耐压试验种类")
    @ApiModelProperty(value = "耐压试验种类")
    private String withstandVoltage;

    @ExcelProperty(value = "耐压试验压力(MPa)")
    @ApiModelProperty(value = "耐压试验压力(MPa)")
    private String withstandPressureTest;

    @ExcelProperty(value = "容器内径(mm)")
    @ApiModelProperty(value = "容器内径(mm)")
    private String pressureVesselDiameter;

    @ExcelProperty(value = "材料（衬里）")
    @ApiModelProperty(value = "材料（衬里）")
    private String pressureMaterialLining;

    @ExcelProperty(value = "厚度（衬里）(mm)")
    @ApiModelProperty(value = "厚度（衬里）(mm)")
    private String fixedLining;

    @ExcelProperty(value = "设计压力（壳程）")
    @ApiModelProperty(value = "设计压力（壳程）")
    private String pressureHousingPath;

    @ExcelProperty(value = "设计温度（管程）(℃)")
    @ApiModelProperty(value = "设计温度（管程）(℃)")
    private String temperaturePipe;

    @ExcelProperty(value = "介质（管程）")
    @ApiModelProperty(value = "介质（管程）")
    private String mediumPipe;

    @ExcelProperty(value = "安装型式")
    @ApiModelProperty(value = "安装型式")
    private String installation;

    @ExcelProperty(value = "泄漏试验种类")
    @ApiModelProperty(value = "泄漏试验种类")
    private String leakage;

    @ExcelProperty(value = "泄漏试验压力(MPa)")
    @ApiModelProperty(value = "泄漏试验压力(MPa)")
    private String leakPressure;

    @ExcelProperty(value = "容器高(长)(mm)")
    @ApiModelProperty(value = "容器高(长)(mm)")
    private String height;

    @ExcelProperty(value = "材料（夹套）")
    @ApiModelProperty(value = "材料（夹套）")
    private String materialJacket;

    @ExcelProperty(value = "厚度（夹套）(mm)")
    @ApiModelProperty(value = "厚度（夹套）(mm)")
    private String fixedJacket;

    @ExcelProperty(value = "设计压力（管程）")
    @ApiModelProperty(value = "设计压力（管程）")
    private String pressurePipe;

    @ExcelProperty(value = "设计温度（夹套）(℃)")
    @ApiModelProperty(value = "设计温度（夹套）(℃)")
    private String temperatureJacket;

    @ExcelProperty(value = "最高允许工作压力（管程）")
    @ApiModelProperty(value = "最高允许工作压力（管程）")
    private String maxPressurePipe;

    @ExcelProperty(value = "支座型式")
    @ApiModelProperty(value = "支座型式")
    private String support;

    @ExcelProperty(value = "保温绝热方式")
    @ApiModelProperty(value = "保温绝热方式")
    private String insulation;

    @ExcelProperty(value = "材料（筒体(球壳)）")
    @ApiModelProperty(value = "材料（筒体(球壳)）")
    private String materialCylinderShell;

    @ExcelProperty(value = "厚度（筒体(球壳)）(mm)")
    @ApiModelProperty(value = "厚度（筒体(球壳)）(mm)")
    private String thickness;

    @ExcelProperty(value = "容器自重(kg)")
    @ApiModelProperty(value = "容器自重(kg)")
    private String selfWeight;

    @ExcelProperty(value = "设计压力（夹套）")
    @ApiModelProperty(value = "设计压力（夹套）")
    private String pressureJacket;

    @ExcelProperty(value = "最高允许工作压力（夹套）")
    @ApiModelProperty(value = "最高允许工作压力（夹套）")
    private String maxPressureJacket;

    @ExcelProperty(value = "最高允许工作压力（壳程）")
    @ApiModelProperty(value = "最高允许工作压力（壳程）")
    private String maxPressureShell;

    @ExcelProperty(value = "主体结构型式", converter = DictParamsConverter.class)
    @ApiModelProperty(value = "主体结构型式")
    private String mainStructureType;

    @ExcelProperty(value = "无损检测方法", converter = DictParamsConverter.class)
    @ApiModelProperty(value = "无损检测方法")
    private String checkLossless;

    @ExcelProperty(value = "容器型号")
    @ApiModelProperty(value = "容器型号")
    private String container;

    @ExcelProperty(value = "工作压力(MPa)")
    @ApiModelProperty(value = "工作压力(MPa)")
    private String workingPressure;

    @ExcelProperty(value = "厚度（筒体）(mm)")
    @ApiModelProperty(value = "厚度（筒体）(mm)")
    private String thicknessCylinder;

    @ExcelProperty(value = "罐车编号")
    @ApiModelProperty(value = "罐车编号")
    private String carNum;

    @ExcelProperty(value = "设计温度(℃)")
    @ApiModelProperty(value = "设计温度(℃)")
    private String designTemperature;

    @ExcelProperty(value = "腐蚀裕量(mm)")
    @ApiModelProperty(value = "腐蚀裕量(mm)")
    private String corrosionMargin;

    @ExcelProperty(value = "容积(L)")
    @ApiModelProperty(value = "容积(L)")
    private String volume;

    @ExcelProperty(value = "设计压力")
    @ApiModelProperty(value = "设计压力")
    private String designPressure;

    @ExcelProperty(value = "材料（筒体）")
    @ApiModelProperty(value = "材料（筒体）")
    private String materialCylinder;

    @ExcelProperty(value = "最大充装量(kg)")
    @ApiModelProperty(value = "最大充装量(kg)")
    private String maxFill;

    @ExcelProperty(value = "工作温度(℃)")
    @ApiModelProperty(value = "工作温度(℃)")
    private String workTemperature;

    @ExcelProperty(value = "介质")
    @ApiModelProperty(value = "介质")
    private String medium;

    @ExcelProperty(value = "氧舱品种")
    @ApiModelProperty(value = "氧舱品种")
    private String oxygenChamber;

    @ExcelProperty(value = "温度(℃)")
    @ApiModelProperty(value = "温度(℃)")
    private String temperature;

    @ExcelProperty(value = "额定进舱人数(人)")
    @ApiModelProperty(value = "额定进舱人数(人)")
    private String ratedEntryCapacity;

    @ExcelProperty(value = "压力介质")
    @ApiModelProperty(value = "压力介质")
    private String pressureMedium;

    @ExcelProperty(value = "主体结构")
    @ApiModelProperty(value = "主体结构")
    private String chamberMain;

    @ExcelProperty(value = "人均舱容(m³)")
    @ApiModelProperty(value = "人均舱容(m³)")
    private String perCapitaCabinCapacity;

    @ExcelProperty(value = "压力(MPa)")
    @ApiModelProperty(value = "压力(MPa)")
    private String chamberPressure;

    //--------------------------------------------------------------------压力管道----技术参数

    @ExcelProperty(value = "管道类别", converter = DictParamsConverter.class)
    @ApiModelProperty(value = "管道类别")
    private String pipelineClass;

    @ExcelProperty(value = "公称壁厚(mm)")
    @ApiModelProperty(value = "公称壁厚(mm)")
    private String wallThickness_YLGD;

    @ExcelProperty(value = "公称直径（mm）")
    @ApiModelProperty(value = "公称直径（mm）")
    private String nominalDiameter;

    @ExcelProperty(value = "管道长度（m）")
    @ApiModelProperty(value = "管道长度（m）")
    private String pipeLength;

    @ExcelProperty(value = "压力（MPa）")
    @ApiModelProperty(value = "压力（MPa）")
    private String pressure;

    @ExcelProperty(value = "介质")
    @ApiModelProperty(value = "介质")
    private String medium_YLGD;

    @ExcelProperty(value = "起/始位置 （经纬度）（格式：经度-纬度）")
    @ApiModelProperty(value = "起/始位置 （经纬度）（格式：经度-纬度）")
    private String startePosition;

    @ExcelProperty(value = "温度(℃)")
    @ApiModelProperty(value = "温度(℃)")
    private String temperature_YLGD;

    @ExcelProperty(value = "管道编号")
    @ApiModelProperty(value = "管道编号")
    private String pipelineNumber;

    @ExcelProperty(value = "管道级别", converter = DictParamsConverter.class)
    @ApiModelProperty(value = "管道级别")
    private String deviceLevel_YLGD;

    @ExcelProperty(value = "备注")
    @ApiModelProperty(value = "备注")
    private String remarks;

    //--------------------------------------------------------------大型游乐设施----技术参数

    @ExcelProperty(value = "轨道高度（m）")
    @ApiModelProperty(value = "轨道高度（m）")
    private String trackHeight;

    @ExcelProperty(value = "运行速度（km/h (m/s)）")
    @ApiModelProperty(value = "运行速度（km/h (m/s)）")
    private String runningSpeed_DXYLSS;

    @ExcelProperty(value = "承载人数/车 (人)")
    @ApiModelProperty(value = "承载人数/车 (人)")
    private String numberOfPassengers;

    @ExcelProperty(value = "滑道长度（m）")
    @ApiModelProperty(value = "滑道长度（m）")
    private String slideLength;

    @ExcelProperty(value = "运行高度（m）")
    @ApiModelProperty(value = "运行高度（m）")
    private String operatingHeight;

    @ExcelProperty(value = "蹦极绳长度（m）")
    @ApiModelProperty(value = "蹦极绳长度（m）")
    private String slideLength_DXYLSS;

//    @ExcelProperty(value = "滑索长度（m）")
//    @ApiModelProperty(value = "滑索长度（m）")
//    private String slideLength_DXYLSS;

    @ExcelProperty(value = "回转直径（m）")
    @ApiModelProperty(value = "回转直径（m）")
    private String rotaryDiameter;

    @ExcelProperty(value = "单侧摆角（°）")
    @ApiModelProperty(value = "单侧摆角（°）")
    private String unilateralSwingAngle;

    @ExcelProperty(value = "车辆数量 (个)")
    @ApiModelProperty(value = "车辆数量 (个)")
    private String numberOfVehicles;

    @ExcelProperty(value = "设备高度(m)")
    @ApiModelProperty(value = "设备高度(m)")
    private String equipmentHeight;

    @ExcelProperty(value = "运行高度(m)")
    @ApiModelProperty(value = "运行高度(m)")
    private String operatingHeight_DXYLSS;

    @ExcelProperty(value = "回转速度（km/h (m/s)）")
    @ApiModelProperty(value = "回转速度（km/h (m/s)）")
    private String slewingSpeed;

    @ExcelProperty(value = "倾角(°)")
    @ApiModelProperty(value = "倾角(°)")
    private String dip;

    //--------------------------------------------------------------------客运索道----技术参数

    @ExcelProperty(value = "平距（m）")
    @ApiModelProperty(value = "平距（m）")
    private String horizontalDistance;

    @ExcelProperty(value = "支架数据(座)")
    @ApiModelProperty(value = "支架数据(座)")
    private String supportsCount;

    @ExcelProperty(value = "斜长（m）")
    @ApiModelProperty(value = "斜长（m）")
    private String obliqueLength;

    @ExcelProperty(value = "主电机型式")
    @ApiModelProperty(value = "主电机型式")
    private String mainMotorModel;

    @ExcelProperty(value = "主电机功率(W)")
    @ApiModelProperty(value = "主电机功率(W)")
    private String mainMotorPower;

    @ExcelProperty(value = "高差（m）")
    @ApiModelProperty(value = "高差（m）")
    private String altitudeDifference;

    @ExcelProperty(value = "运量（p/h）")
    @ApiModelProperty(value = "运量（p/h）")
    private String freightVolume;

    @ExcelProperty(value = "运载索", converter = DictParamsConverter.class)
    @ApiModelProperty(value = "运载索")
    private String carrierLine;

    @ExcelProperty(value = "速度（m/s）")
    @ApiModelProperty(value = "速度（m/s）")
    private String speed;

    @ExcelProperty(value = "承载索")
    @ApiModelProperty(value = "承载索")
    private String bearingCable;

    @ExcelProperty(value = "索距（m）")
    @ApiModelProperty(value = "索距（m）")
    private String cablePitch;

    @ExcelProperty(value = "张紧油压（重锤重量）（MPa）")
    @ApiModelProperty(value = "张紧油压（重锤重量）（MPa）")
    private String oilPressureHeavyHammer;

    @ExcelProperty(value = "运载工具数量和类型")
    @ApiModelProperty(value = "运载工具数量和类型")
    private String numberAndTypeOfVehicles;

    @ApiModelProperty(value = "原设备代码")
    @ExcelIgnore
    private String originalEquCode;

    @ApiModelProperty(value = "序号")
    @ExcelProperty(value = "序号")
    private String xaSerial;

    @ApiModelProperty(value = "资料是否齐全（0齐全， 1不齐全）-西安数据导入")
    @ExcelIgnore
    private Integer isCompleteXa;

    @ApiModelProperty(value = "属地监管部门")
    @ExcelProperty(value = "属地监管部门")
    private String orgBranchName;
}