package com.yeejoin.amos.boot.module.common.api.dto;

import java.io.Serializable;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "OrgUsr", description = "机构/部门/人员表")
public class OrgUsrTreeDto extends BaseDto implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	@ApiModelProperty(value = "机构名称")
	private String bizOrgName;

	@ApiModelProperty(value = "机构编码")
	private String bizOrgCode;

	@ApiModelProperty(value = "机构类型（部门：DEPARTMENT，单位：COMPANY，人员：PERSON）")
	private String bizOrgType;

	@ApiModelProperty(value = "归属机构")
	private String parentId;
	@ApiModelProperty(value = "部门数量")
	private int num;
}
