package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseRelationEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 单位下摄像头配置表
 *
 * @author system_generator
 * @date 2024-10-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_base_enterprise_video")
public class BaseEnterpriseVideo extends BaseRelationEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 获取token地址
     */
    @TableField("token_url")
    private String tokenUrl;

    /**
     * 获取播放地址
     */
    @TableField("url")
    private String url;

    /**
     * 对接信息标识
     */
    @TableField("app_key")
    private String appKey;

    /**
     * 对接信息密匙
     */
    @TableField("app_secret")
    private String appSecret;

    /**
     * 设备序列号
     */
    @TableField("device_serial")
    private String deviceSerial;

    /**
     * 流播放协议，1-ezopen、2-hls、3-rtmp、4-flv，默认为1
     */
    @TableField("protocol")
    private String protocol;

    /**
     * 通道号
     */
    @TableField("channel_no")
    private String channelNo;

    /**
     * 过期时长，单位秒；针对hls/rtmp/flv设置有效期，相对时间；30秒-720天
     */
    @TableField("expire_time")
    private Long expireTime;

    /**
     * 单位唯一标识
     */
    @TableField("use_unit_code")
    private String useUnitCode;

    /**
     * 摄像头所在位置行政区域，拼接树使用（企业无此字段故冗余此字段）
     */
    @TableField("region_code")
    private String regionCode;

    /**
     * 标识什么设种类使用的摄像头
     */
    @TableField("equ_list_code")
    private String equListCode;

    @TableField("platform")
    private String platform;

    @TableField("is_enabled")
    private Boolean isEnabled;

}
